/* Dies ein ein Demonstrationsprogramm zur Erluterung wie Sie das
	Connect! - Paket in Ihre Programme integrieren knnen.
	Hier wird dynamisches Linken ber Ordinalzahlen (Funktionsindices)
	demonstriert.
	Das Programm erwartet eine Kommandozeile mit folgendem Format:
	Kommando=Datei
	"Kommando" kann die folgenden Werte annehmen:
	"UPDATE" (Aufruf von update_control)
	"Install" (Aufruf von call_install)
	"Request" (Aufruf von filebase)
	"Upload"  (Aufruf von FileUpload)

	"Datei" ist der Dateiname die die Struktur "RequestControl" bzw. "UpdateControl" enthlt.

	Sie knnen auf diese Weise das Connect! - System nutzen, ohne es direkt mit
	Ihren	Programmen linken zu mssen.

	Compiler: Borland C++ 4.52
	Copyright  Hansjrg Pfister                                                       */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include "upcon.h"
#include "ordinal.h"    // Enthlt den Index der DLL - Funktionen

#define UPDATE  1
#define INSTALL 2
#define REQUEST 3
#define UPLOAD  4

char *ERR_CMDLINE = "Falsche Kommandozeile";
char *ERR_FILEOPEN= "Datei kann nicht geffnet werden";
char *ERR_READ = "Datei kann nicht gelesen werden";



void fehler (char *s)
{
	MessageBox (0,s,"Fehler",MB_OK);
	exit (1);
}


void fatal_error (char *name)
{
char puffer [256];
	sprintf (puffer,"%s %s %s","Funktion",name,"konnte nicht gefunden werden");
	MessageBox (0,puffer,"Fehler",MB_OK);
	exit (1);
}


HINSTANCE LoadLib (char *name)
{
HINSTANCE h;
char puffer [256];
h = LoadLibrary (name);
if (h < HINSTANCE_ERROR)
{
	 sprintf (puffer,"%s %s %s %d","DLL",name,"konnte nicht geladen werden, Fehlercode:",h);
	 MessageBox (0,puffer,"Fehler",MB_OK);
	 exit (1);
}
return h;
}

void ende ()
{
exit (0);
}

void request (char *cmd,short was)
{
char *c;
FILE *fp;
short (*filebase) (RequestControl *);
short (*FileUpload) (RequestControl *);

RequestControl rc;
HINSTANCE fbase;
c = strchr (cmd,'=');
if (!c) fehler (ERR_CMDLINE);
c++;
fp = fopen (c,"rb");
if (!fp) fehler (ERR_FILEOPEN);
if (fread (&rc,sizeof (RequestControl),1,fp) != 1) fehler (ERR_READ);
fclose (fp);
fbase = LoadLib ("filebase.dll");
if (was == UPLOAD)
{
	FileUpload = (short (*) (RequestControl *)) GetProcAddress (fbase,MAKEINTRESOURCE (FileUpload_FUNC));
	if (!FileUpload) fatal_error ("FileUpload");
	FileUpload (&rc);
} else
{
	filebase = (short (*) (RequestControl *)) GetProcAddress (fbase,MAKEINTRESOURCE (filebase_FUNC));
	if (!filebase) fatal_error ("filebase");
	filebase (&rc);
}
FreeLibrary (fbase);
ende ();
}

void update (char *cmd,short was)
{
char *c;
FILE *fp;
UpdateControl uc;
HINSTANCE ucontrol;
short (*update_control)( UpdateControl *);
short (*call_install)( UpdateControl *);

c = strchr (cmd,'=');
if (!c) fehler (ERR_CMDLINE);
c++;
fp = fopen (c,"rb");
if (!fp) fehler (ERR_FILEOPEN);
if (fread (&uc,sizeof (UpdateControl),1,fp) != 1) fehler (ERR_READ);
fclose (fp);
ucontrol = LoadLib ("ucontrol.dll");
if (was == INSTALL)
{
	call_install = (short (*) (UpdateControl *)) GetProcAddress (ucontrol,MAKEINTRESOURCE (call_install_FUNC));
	if (!call_install) fatal_error ("call_install");
	call_install (&uc);
} else
{
	update_control = (short (*) (UpdateControl *)) GetProcAddress (ucontrol,MAKEINTRESOURCE (update_control_FUNC));
	if (!update_control) fatal_error ("update_control");
	update_control (&uc);
}
FreeLibrary (ucontrol);
ende ();
}




int pascal WinMain (HINSTANCE current,HINSTANCE previous,LPSTR cmd,int show)
{
HINSTANCE modem;
short (*ModemConfig)(long);

if (!strnicmp (cmd,"Update",6)) update (cmd,UPDATE);
if (!strnicmp (cmd,"Install",7)) update (cmd,INSTALL);
if (!strnicmp (cmd,"Request",7)) request (cmd,REQUEST);
if (!strnicmp (cmd,"Upload",6)) request (cmd,UPLOAD);
if (!strnicmp (cmd,"Konfig",6))
{
	modem = LoadLib ("mconfig.dll");
	ModemConfig = (short (*) (long)) GetProcAddress (modem,MAKEINTRESOURCE (ModemConfig_FUNC));
	if (!ModemConfig) fatal_error ("ModemConfig");
	ModemConfig (0);
	FreeLibrary (modem);
	ende ();
}
MessageBox (0,"Falsche oder fehlende Kommandozeile","Fehler",MB_OK);
ende ();
}
