/*
*. ABSTRACT - Part of Seedump
*. AUTHOR   - Wolf Neumann
*. (C) Copyright Wolf Neumann 1995
*/

/*
*. xall - generates different exceptions
*. ABSTRACT
*.
*. AUTHOR
*. Wolf Neumann, 29 Apr 95
*/

#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <math.h>
#include "dumper.h"

/* typedefs */
typedef int calladdr( int argc, char ** argv);

/* function prototypes */
void usage( int argc, char ** argv );
void CallInvalidFunctionAddress( int argc, char ** argv );
int DivideByZero( int argc, char ** argv );
int InvalidPointerAssignment( int argc, char ** argv );
int trapper( int argc, char ** argv );

void FloatingPointException( ) /* not working for watcom or cset2 !!! */
{
  double a,b,c = 0.0;
  a = 1.0;
  a = b / c;
  b = a * a;
  b = sqrt( a );
  b = log( a );
}

void tthread( )
{
  char * p = (char *)1234;
  SetXCPTHandler( );
  InvalidPointerAssignment( 0, 0 );
}

int Recursion( )
{
  int lineno = __LINE__;
  char * fname = __FILE__;
  char consume[1000];
  return Recursion( );
}

int main(int argc, char *argv[])
{
  SetXCPTHandler();
  return trapper( argc, argv );
}
int trapper( int argc, char ** argv )
{
  int i;
  char c;
  if (argc == 1)
  {
    usage( argc, argv );
  }

  c = argv[1][0];
  if (c >= '0' && c <= '9')
  {
  }
  else
  {
    fprintf( stderr, "%s integer as trap_kind, parm %s invalid\n",
             argv[0], argv[1] );
    usage( argc, argv );
  }
  i = atoi( argv[1] );
  switch (i)
  {
    case 1:
      DivideByZero( argc, argv );
      break;
    case 2:
      InvalidPointerAssignment( argc, argv );
      break;
    case 3:
      printf( "not supported !!\n" );
      break;
    case 4:
      FloatingPointException( );
      break;
    case 5: /* invalid pointer assignm. in thread */
      {
        TID tid;
        DosCreateThread( &tid,
                         (PFNTHREAD)tthread,
                         0,
                         0,
                         4 * 4096 );
        DosWaitThread( &tid, 0 );
      }
      break;
    case 6:
      Recursion( );
      break;
    case 98:
      if (atoi(argv[2]) == 1)
      {
        trapper( 2, argv+3 );
      }
      else
      {
        int k = atoi( argv[2] ) - 1;
        itoa( k, argv[2], 10 );
        trapper( 98, argv );
      }
      break;
    case 99:
      CallInvalidFunctionAddress( argc, argv );
      break;
    default:
      fprintf( stderr, "unknown trap_kind %s\n", argv[1] );
      usage( argc, argv );
  } /* end switch: (i) */
  exit( 0 );
  return 0;
} /* end of : main */

void usage( int argc, char ** argv )
{
  int l = strlen( argv[0] );
  fprintf( stderr, "%s integer\n", argv[0] );
  fprintf( stderr, "%*s  1 - divide by zero\n", l, " ", argv[0] );
  fprintf( stderr, "%*s  2 - assign to invalid pointer\n", l, " ", argv[0] );
  fprintf( stderr, "%*s  3 - calls 16-bit code divide by zero\n", l, " ", argv[0] );
  fprintf( stderr, "%*s  4 - floating point exception\n", l, " ", argv[0] );
  fprintf( stderr, "%*s  5 - access violation in thread 2\n", l, " ", argv[0] );
  fprintf( stderr, "%*s 99 - call an ivalid functionaddress\n", l, " ", argv[0] );
  exit( 1 );
}

void CallInvalidFunctionAddress( int argc, char ** argv )
{
  ULONG l = (0x17 + (ULONG)main);
  calladdr * m = (calladdr *)l;
  m( argc, argv );
}

int DivideByZero( int argc, char ** argv )
{
  int i = 9;
  i /= (i - i);
  return i;
}

int InvalidPointerAssignment( int argc, char ** argv )
{
  char * p = (char *)1;

  *p = 'a';
  return 0;
}

