/*
** utilities.h - functions in utilities.C
**
** utilities.h utilities.h 1.31   Delta'd: 15:23:09 10/31/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991, 1992 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef __UTILITIES_H
#define __UTILITIES_H

#include <stdio.h>
#include "classes.h"

//
// possible response for yes_or_no command
//
enum Response { No, Yes };

extern void         adjust_window();
extern void         block_tstp_and_winch();
extern void         display_string(const char *str, int len =0, int offset =0);
extern void         error(const char *fmt, ...);
extern void         exec_with_system(const char *cmd, int prompt = 1);
extern int          execute(const char *file, const char *argv[], int prompt=0);
extern const char  *expand_tilde(char *str);
extern char        *fgetline(FILE *fp, int size);
extern const char  *get_problem_number(const DList *dl);
extern void         initialize();
extern void         initial_listing(DList *dl);
extern void         leftshift_current_line(DList *dl);
extern int          lines_displayed(DList *dl);
extern void         lock_file(int fd);
extern void         message(const char *fmt, const char *str = 0);
extern char        *prompt(const char *msg, void (*redisplay)());
extern void         quit(int = 0);
extern int          read_file(FILE *, char** &, int, int, int = 0);
extern int          read_and_exec_perm(const char *file);
extern void         rightshift_current_line(DList *dl);
extern long         seconds_in_date(const char *date);
extern void         set_signals();
extern const char  *temporary_file();
extern const char **tokenize(const char *line, const char *separators);
extern void         unblock_tstp_and_winch();
extern void         unlock_file(int fd);
extern void         unset_signals();
extern void         update_modeline(const char *head=0, const char *tail=0);
extern void         update_screen_line(const char *oldl, const char *newl, int y);
extern const char  *username();
extern const char  *fullname();
extern const char  *mailname();
extern void         winch(int);
extern void         write_to_pipe(int fd, const char *data, int size);
extern int          yes_or_no(const char *msg,
                              void (*redisplay)(),
                              Response defResponse,
                              int standout);
extern int          get_key(char *key);

// has the window size changed?
extern int windowSizeChanged;

// is the message window dirty?
extern int message_window_dirty;

// the current modeline
extern char *current_modeline;

// max - the maximum of two integer arguments.
inline int max(int x, int y) { return x >= y ? x : y; }

#endif /*__UTILITIES_H*/
