/*
** external definitions needed for interfacing with regexp.C
**
** regexp.h regexp.h 1.3   Delta'd: 23:06:20 7/2/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _REGEXP_H
#define _REGEXP_H

#define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		// Internal use only.
	char reganch;		// Internal use only.
	char *regmust;		// Internal use only.
	int regmlen;		// Internal use only.
	char program[1];	// Unwarranted chumminess with compiler.
} regexp;

extern const char *REerror; // how we pass error messages around
extern regexp *regcomp(const char *exp);
extern int regexec(regexp *prog, char *string);

#endif
