/*
** problem.h - functions exported by problem.C
**
** problem.h 1.13   Delta'd: 17:54:07 11/9/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991, 1992 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef __PROBLEM_H
#define __PROBLEM_H

#include "classes.h"

extern "C" {
#include <gdbm.h>
extern gdbm_error gdbm_errno;
}

// our GDMB filehandle  -- only one open GDBM file at a time
extern GDBM_FILE GdbmFile;

// help message for the message window when displaying help
extern const char *const HELP_MSG[];

// the current area
extern String current_area;

extern int   append_to_problem(const char *number = 0);
extern int   close_problem(const char *number = 0);
extern int   database_exists();
extern int   delete_problem(const char *number = 0);
extern int   examine_problem(const char *number = 0);
extern int   is_area(const char *area);
extern int   modify_keywords(const char *number = 0);
extern int   modify_severity(const char *number = 0);
extern void  open_database(int mode);
extern int   reopen_problem(const char *number = 0);
extern void  reorganize_database(int dodelay = 1);
extern char *summary_info(datum &data);
extern int   transfer_problem(const char *number = 0, char *newArea = 0);

inline const char *CurrentArea() { return current_area; }

//
// We need this on i486 + ISC v3.2 3.0 Unix (SysVR3)
// pid_t is the type returned by fork(2).
//
#ifdef ISC
#define pid_t short
#endif

//
// Deal with old and new types of delete
//
#ifdef  OLDDELETE
#define DELETE delete
#else
#define DELETE delete []
#endif

#endif
