/*
** help.C - strings displayed for help while in the lister
**
** help.h 1.9   Delta'd: 19:27:08 10/30/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

const char *const help_file[] = {
    " CURSOR MOVEMENT COMMANDS:",
    "",
    "    ?  H               Display this help.",
    "    q                  quit.",
    "    j  n  ^N  SPC  CR  Forward  one line.",
    "    DOWN_ARROW_KEY             \"        .",
    "    k  p  ^P  ^Y       Backward one line.",
    "    UP_ARROW_KEY               \"        .",
    "    ^F  ^V             Forward  one window.",
    "    b  ^B  ESC-V       Backward one window.",
    "    ^D                 Forward  one half-window.",
    "    ^U                 Backward one half-window.",
    "    <                  Go to first line of listing.",
    "    >                  Go to last line of listing.",
    "",
    " COMMANDS WHICH OPERATE ON THE CURRENT PROBLEM:",
    "",
    "    a                  Append to current problem.",
    "    c                  Close current problem.",
    "    d                  Delete current problem.",
    "    e m v              Examine, View or \"more\" current problem.",
    "    r                  Reorganize the database.",
    "    M                  Modify keyword field.",
    "    P                  Modify priority (severity) field.",
    "    R                  Reopen a closed problem.",
    "    S                  Save problem listing to a file - prompts for filename.",
    "    T                  Transfer problem to another area.",
    "",
    " MISCELLANEOUS COMMANDS:",
    "",
    "    !                  starts up a shell.",
    "    ! cmd              executes a shell command - prompts for command.",
    "    !!                 reexecutes previous shell command.",
    "    ^L                 Repaint screen.",
    "    CR                 Signifies end-of-response when in a prompt.",
    "    V                  Print out version string."
};

// number of entries in help_file
const int HELP_FILE_DIM = int(sizeof(help_file) / sizeof(help_file[0]));
