/***********************************************************
project /PROJECT/ generated on /DATE/ by /USER/
************************************************************/

#define INCL_PM
#include "os2.h"

#include "resource.h"


MRESULT EXPENTRY stdcWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg )
  {
    case WM_CREATE:
      /*
       * Window initialization is performed here in WM_CREATE processing
       * WinLoadString loads strings from the resource file.
       */
    case WM_COMMAND:
      /*
       * When the user chooses option 1, 2, or 3 from the Options pull-
       * down, the text string is set to 1, 2, or 3, and
       * WinInvalidateRegion sends a WM_PAINT message.
       * When Exit is chosen, the application posts itself a WM_CLOSE
       * message.
       */
      {
      USHORT command;                   /* WM_COMMAND command value     */
      command = SHORT1FROMMP(mp1);      /* Extract the command value    */
      switch (command)
      {
      }

      break;
      }
    case WM_ERASEBACKGROUND:
      /*
       * Return TRUE to request PM to paint the window background
       * in SYSCLR_WINDOW.
       */
      return (MRESULT)( TRUE );
    case WM_PAINT:
      /*
       * Window contents are drawn here in WM_PAINT processing.
       */
      {
      HPS    hps;                       /* Presentation Space handle    */
      RECTL  rc;                        /* Rectangle coordinates        */
      POINTL pt;                        /* String screen coordinates    */
                                        /* Create a presentation space  */
      hps = WinBeginPaint( hwnd, 0L, &rc );
      WinFillRect( hps, &rc, SYSCLR_WINDOW);
      WinEndPaint( hps );                      /* Drawing is complete   */
      break;
      }
    case WM_CLOSE:
      /*
       * This is the place to put your termination routines
       */
      WinPostMsg( hwnd, WM_QUIT, (MPARAM)0,(MPARAM)0 );/* Cause termination*/
      break;
    default:
      /*
       * Everything else comes here.  This call MUST exist
       * in your window procedure.
       */

      return WinDefWindowProc( hwnd, msg, mp1, mp2 );
  }
  return (MRESULT) FALSE;
}


void main ( void)
{
   HMQ  hmq;                             /* Message queue */
   HWND hwndClient = NULLHANDLE;         /* Client area window handle    */
   HWND hwndFrame = NULLHANDLE;          /* Frame window handle          */
   QMSG qmsg;                            /* Message from message queue   */
   HAB hab;
   ULONG flCreate;                       /* creation control flags */

   /* create anchor block */
   hab = WinInitialize(0);

   /* Create a message queue */
   hmq = WinCreateMsgQueue( hab, 0 );

   /* register the window class */
   WinRegisterClass( hab, (PSZ)"stdcWindow",
     (PFNWP) stdcWindowProc, CS_SIZEREDRAW,
     0);

   /* style for the frame */
   flCreate = FCF_SIZEBORDER | FCF_SYSMENU /MENU | FCF_MENU MENU/ | FCF_TITLEBAR | FCF_MINMAX | FCF_TASKLIST & ~FCF_SHELLPOSITION;

   /* create a window */
   hwndFrame = WinCreateStdWindow(
               HWND_DESKTOP, 0, &flCreate,
               "stdcWindow", "", 0,
               (HMODULE) 0,
               WIN_MAIN, &hwndClient);

  WinSetWindowText(hwndFrame, "stdc Window");

  WinSetWindowPos( hwndFrame,
                   HWND_TOP, 100, 100, 200, 200,
                   SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW );

  while( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
    WinDispatchMsg( hab, &qmsg );

  /*clean*/
  WinDestroyWindow(hwndFrame);
  WinDestroyMsgQueue( hmq );
  WinTerminate( hab );
}
