#ifndef _QUEUE_LIST_CODE
#define _QUEUE_LIST_CODE

// Code written by Steven De Toni ACBC 11

// These class methods used to implement a object that holds other objects
// that are decendant of ANYOBJECT (i.e universal container).

#include "baseq.h"
#include <stdio.h>            // NULL CONSTANT


// ############################################################################
// #### QueueList Class ####
// #########################

// ############################ Protected Methods #############################

// Create new list item and place programmer's data within it,
// make new links with previous item if wished.
// returns a pointer to the new item, NULL if operation failed.
//
// Parameters:
//     pItem    : Pointer to the object to be stored.
//     LinkItem : Pointer to end of list where item to be added.
//
// Return Values:
//     LinkItem : returns pointer to newly added item in list,
//                NULL if operation failed. However items within list
//                before hand still exist.
LinkItem* QueueList::newItem (ANYOBJECT* pItem, LinkItem* pEndList)
{
	LinkItem*  pNewStruct = new LinkItem;

	if (pNewStruct != NULL)
		{
		pNewStruct->pLinkedItem    = pEndList;
		pNewStruct->pStoredItem    = pItem;
		}

	return pNewStruct;
}


// ############################## Public Methods ##############################
// ############################### Constructors ###############################
QueueList::QueueList       (void)
{
	itemCount      = 0;
	spaceAvailable = 0;
	pEndPos        = NULL;
}


// Parameters:
//     pItem    : Pointer to a object to be stored, must be decendant of
//                base class ANYOBJECT.
QueueList::QueueList       (ANYOBJECT* pItem)
{
	itemCount      = 0;
	spaceAvailable = 0;
	pEndPos        = NULL;
	putLast(pItem);
}


// ########################### User Methods ###################################

// Place programmers object into list
//
// Parameters:
//     pItem    : Pointer to a object to be stored, must be decendant of
//                base class ANYOBJECT.
//
// Return Values:
//     int      : Returns a error code indicating whether operation was
//                successful.
//                Values:
//                    0 = No Worries
//                   -1 = Arrgh ... No memory
//
int       QueueList::putLast   (ANYOBJECT* pItem)
{
	LinkItem*   pNewItem = newItem (pItem, pEndPos);
	if (pNewItem != NULL)
		{
		pEndPos = pNewItem;
		itemCount++;
		return 0;
		}
	spaceAvailable = -1;
	return -1;                // could not add item to list!
}


// Take first item placed in Queue, out and return it.
// Type casting is required to return object back to it's orginial
// state.
//
// Return Values:
//     ANYOBJECT* : Pointer to the object that was stored within queue.
//
ANYOBJECT*   QueueList::takeNext         (void)
{
	if (pEndPos != NULL)
		{
		LinkItem* pUpDateList = pEndPos;
		LinkItem* pStartPos   = pEndPos;

		// move down list until start has been reached
		while (pStartPos->pLinkedItem != NULL)
			pStartPos = pStartPos->pLinkedItem;

                              // if not the last item in list
		if (pStartPos != pUpDateList)
			{
			// retrieve data and delete item from list
			while (pUpDateList->pLinkedItem != pStartPos)
				pUpDateList = pUpDateList->pLinkedItem;
			}
		else
			{
			pEndPos = NULL;   // start new list after all items gone
			}

                              // copy value to user
		ANYOBJECT* pTemp = pStartPos->pStoredItem;
                              // make new start of list
		pUpDateList->pLinkedItem = NULL;
		delete pStartPos;     // delete object
		itemCount--;          // one less
		if (spaceAvailable)   // if no memory available before...
                              // there is now!
				spaceAvailable = 0;
		return pTemp;
		}
	else
		return NULL;
}


// Returns the number of items contained within the queue.
//
// Returns Values:
//     int :    Num of items within queue.
//
                              // return number of item in Queue
int      QueueList::status (void)
{
	return itemCount;
}


// Method returns whether last operation failed due to memory allocation
// failure.
//
// Return Values:
//     int  : Returns 1 of two values ...
//            Values:
//              0  =  memory available
//             -1  =  Last memory allocation failed.
//
                              // return Queue space left
int      QueueList::space  (void)
{
	return spaceAvailable;    // return -1 if no space available
}


// Methods is used to peek within the queue at objects, and return there
// pointer without taking them out of the queue.
//
// Parameters:
//     NumFromNext : The object number to look at from the start of the
//                   queue. The start of the queue is 1, not 0.
//
// Return Values:
//     ANYOBJECT* : Pointer to the object that is stored within queue,
//                  at said position. Returns NULL if operation failed.
//
ANYOBJECT*   QueueList::peek (int numFromNext)
{
	if (pEndPos != NULL)
		{
		//if (numFromNext > itemCount) //error checking !
		//   return NULL;

		int count = itemCount - numFromNext;
		LinkItem* pStartPos   = pEndPos;

		// move down list until start has been reached
		while (count > 0)
			{
			pStartPos = pStartPos->pLinkedItem;
			count--;
			}

		if (pStartPos != NULL)
			return pStartPos->pStoredItem;
		else
			return NULL;
		}
	else
		return NULL;
}


// ############################### Destructor ###############################
// Method will remove all list items from memory if they still exist,
// no garabage collection provided, or used.
//
QueueList::~QueueList      (void)
{
	LinkItem* pTemp = pEndPos;

	while (pEndPos != NULL)
		{
                              // advance to next item
		pEndPos = pEndPos->pLinkedItem;
                              // kill data contained
		delete    pTemp  ->pStoredItem;
		delete    pTemp;      // kill item
		pTemp   = pEndPos;
		}
}


#endif

