/*******************************************************************************
* FILE NAME: testmain.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     testmain- test for windowlist                                            *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _ILISTBOX_
#include <ilistbox.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _IBMPCTL_
#include <ibmpctl.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _WINLIST_
#include "winlist.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _TESTMAIN_
#include "testmain.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for testmainConn0
//*****************************************************************************
class testmainConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, winlist * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to winlist1(RetrievAllWindows))");
         try {target->retrievAllWindows();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   winlist * target;


};   //testmainConn0


//*****************************************************************************
// Class definition for testmainConn1
//*****************************************************************************
class testmainConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(winlist * aSource, IListBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == winlist::CurrWindowTitleId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : winlist1(CurrWindowTitle) to ListBox1(addAsLast))");
         try {target->addAsLast(source->CurrWindowTitle());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   winlist * source;
   IListBox * target;


};   //testmainConn1


//*****************************************************************************
// Class definition for testmainConn2
//*****************************************************************************
class testmainConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IListBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to ListBox1(removeAll))");
         try {target->removeAll();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IListBox * target;


};   //testmainConn2


//*****************************************************************************
// Class definition for testmainConn3
//*****************************************************************************
class testmainConn3 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IListBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to ListBox2(removeAll))");
         try {target->removeAll();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IListBox * target;


};   //testmainConn3


//*****************************************************************************
// Class definition for testmainConn4
//*****************************************************************************
class testmainConn4 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(winlist * aSource, IListBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == winlist::CurrNonWindowTitleId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : winlist1(CurrNonWindowTitle) to ListBox2(addAsLast))");
         try {target->addAsLast(source->CurrNonWindowTitle());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   winlist * source;
   IListBox * target;


};   //testmainConn4


#pragma export (testmain::readyId)
const INotificationId testmain::readyId = "testmain::readyId";

#pragma export (testmain::partWindowId)
unsigned long testmain::partWindowId = 0;

//------------------------------------------------------------------------------
// testmain :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (testmain::defaultFramingSpec())
const IRectangle testmain::defaultFramingSpec()
{
   return(IRectangle(IPoint(0, IWindow::desktopWindow()->size().height() - 0 - 643),ISize(598, 643)));
}


//------------------------------------------------------------------------------
// testmain :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (testmain::defaultTitle())
IString testmain::defaultTitle()
{
   return("Tels' Visual Window List Example");
}


//------------------------------------------------------------------------------
// testmain :: testmain
//------------------------------------------------------------------------------
#pragma export (testmain::testmain(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
testmain::testmain(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iListBox1 = new IListBox(
      partWindowId+WNDOFFSET_testmain_ListBox1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iListBox2 = new IListBox(
      partWindowId+WNDOFFSET_testmain_ListBox2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText11 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText11, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iMultiCellCanvas2 = new IMultiCellCanvas(
      partWindowId+WNDOFFSET_testmain_MultiCellCanvas2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPushButton2 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton2, 
      iMultiCellCanvas2, 
      iMultiCellCanvas2, 
      IRectangle());
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton1, 
      iMultiCellCanvas2, 
      iMultiCellCanvas2, 
      IRectangle());
   iMCC_Sign = new IMultiCellCanvas(
      partWindowId+WNDOFFSET_testmain_MCC_Sign, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iBitmapControl1 = new IBitmapControl(
      partWindowId+WNDOFFSET_testmain_BitmapControl1, 
      iMCC_Sign, 
      iMCC_Sign, 
      IResourceId(10001), 
      IRectangle ( ));
   iStaticText7 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText7, 
      iMCC_Sign, 
      iMCC_Sign, 
      IRectangle());
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText3, 
      iMCC_Sign, 
      iMCC_Sign, 
      IRectangle());
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText4, 
      iMCC_Sign, 
      iMCC_Sign, 
      IRectangle());
   iStaticText9 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText9, 
      iMCC_Sign, 
      iMCC_Sign, 
      IRectangle());
   iStaticText10 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText10, 
      iMCC_Sign, 
      iMCC_Sign, 
      IRectangle());
   iBitmapControl2 = new IBitmapControl(
      partWindowId+WNDOFFSET_testmain_BitmapControl2, 
      iMCC_Sign, 
      iMCC_Sign, 
      IResourceId(10001), 
      IRectangle ( ));
   iwinlist1 = new winlist();

   conn0 = new testmainConn0();
   conn1 = new testmainConn1();
   conn2 = new testmainConn2();
   conn3 = new testmainConn3();
   conn4 = new testmainConn4();

   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iMultiCellCanvas1->addToCell(iListBox1, 4, 2, 1, 1);
   iMultiCellCanvas1->addToCell(iListBox2, 4, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText1, 2, 2, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText11, 2, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iMultiCellCanvas2, 2, 6, 1, 1);
   iMultiCellCanvas1->addToCell(iMCC_Sign, 4, 6, 1, 1);
   iMultiCellCanvas1->setColumnWidth(4, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas1->setColumnWidth(5, IMultiCellCanvas::defaultCell().width(), false);
   iMultiCellCanvas1->setRowHeight(2, IMultiCellCanvas::defaultCell().height(), true);
   iMultiCellCanvas1->setRowHeight(4, IMultiCellCanvas::defaultCell().height(), true);
   iMultiCellCanvas1->setRowHeight(7, IMultiCellCanvas::defaultCell().height(), false);
   iStaticText1->setText("visible:");
   iStaticText1->setLimit(8);
   iStaticText11->setText("invisible:");
   iStaticText11->setLimit(10);
   iMultiCellCanvas2->addToCell(iPushButton2, 1, 3, 1, 1);
   iMultiCellCanvas2->addToCell(iPushButton1, 1, 1, 1, 1);
   iMultiCellCanvas2->setColumnWidth(2, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas2->setRowHeight(4, IMultiCellCanvas::defaultCell().height(), true);
   iPushButton2->setText("Clear");
   iPushButton2->setMinimumSize(ISize(54, 30));
   iPushButton1->setText("Update");
   iPushButton1->setMinimumSize(ISize(65, 30));
   iMCC_Sign->addToCell(iBitmapControl1, 3, 2, 1, 1);
   iMCC_Sign->addToCell(iStaticText7, 4, 2, 1, 1);
   iMCC_Sign->addToCell(iStaticText3, 2, 2, 3, 1);
   iMCC_Sign->addToCell(iStaticText4, 2, 5, 3, 1);
   iMCC_Sign->addToCell(iStaticText9, 2, 7, 3, 1);
   iMCC_Sign->addToCell(iStaticText10, 2, 9, 1, 1);
   iMCC_Sign->addToCell(iBitmapControl2, 3, 3, 1, 1);
   iMCC_Sign->setColumnWidth(5, IMultiCellCanvas::defaultCell().width(), false);
   iMCC_Sign->setRowHeight(10, IMultiCellCanvas::defaultCell().height(), false);
   iBitmapControl1->setMinimumSize(ISize(64, 64));
   iStaticText7->setText("1997.");
   iStaticText7->setForegroundColor(IColor(IColor::black));
   iStaticText3->setText("Visual Example #010  v1.1 (c) by ");
   iStaticText3->setForegroundColor(IColor(IColor::black));
   iStaticText3->setMinimumSize(ISize(310, 27));
   iStaticText4->setText("Use freely, but give me credit!");
   iStaticText4->setForegroundColor(IColor(IColor::red));
   iStaticText9->setText("Visit my Webpage and find more:");
   iStaticText9->setForegroundColor(IColor(IColor::black));
   iStaticText10->setText("http://www.pobox.com/~tels");
}     //end constructor


//------------------------------------------------------------------------------
// testmain :: ~testmain
//------------------------------------------------------------------------------
#pragma export (testmain::~testmain())
testmain::~testmain()
{
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn1->stopHandlingNotificationsFor(*iwinlist1);
   conn2->stopHandlingNotificationsFor(*iPushButton2);
   conn3->stopHandlingNotificationsFor(*iPushButton2);
   conn4->stopHandlingNotificationsFor(*iwinlist1);

   delete conn0;
   delete conn1;
   delete conn2;
   delete conn3;
   delete conn4;


   delete iMultiCellCanvas1;
   delete iListBox1;
   delete iListBox2;
   delete iStaticText1;
   delete iStaticText11;
   delete iMultiCellCanvas2;
   delete iPushButton2;
   delete iPushButton1;
   delete iMCC_Sign;
   delete iBitmapControl1;
   delete iStaticText7;
   delete iStaticText3;
   delete iStaticText4;
   delete iStaticText9;
   delete iStaticText10;
   delete iBitmapControl2;
   delete iwinlist1;
}

//------------------------------------------------------------------------------
// testmain :: initializePart
//------------------------------------------------------------------------------
#pragma export (testmain::initializePart())
testmain & testmain::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// testmain :: makeConnections
//------------------------------------------------------------------------------
#pragma export (testmain::makeConnections())
Boolean testmain::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iListBox1->enableNotification();
   iListBox2->enableNotification();
   iStaticText1->enableNotification();
   iStaticText11->enableNotification();
   iMultiCellCanvas2->enableNotification();
   iPushButton2->enableNotification();
   iPushButton1->enableNotification();
   iMCC_Sign->enableNotification();
   iBitmapControl1->enableNotification();
   iStaticText7->enableNotification();
   iStaticText3->enableNotification();
   iStaticText4->enableNotification();
   iStaticText9->enableNotification();
   iStaticText10->enableNotification();
   iBitmapControl2->enableNotification();
   iwinlist1->enableNotification();

   conn0->initialize(iPushButton1, iwinlist1);
   conn0->handleNotificationsFor(*iPushButton1);
   conn1->initialize(iwinlist1, iListBox1);
   conn1->handleNotificationsFor(*iwinlist1);
   conn2->initialize(iPushButton2, iListBox1);
   conn2->handleNotificationsFor(*iPushButton2);
   conn3->initialize(iPushButton2, iListBox2);
   conn3->handleNotificationsFor(*iPushButton2);
   conn4->initialize(iwinlist1, iListBox2);
   conn4->handleNotificationsFor(*iwinlist1);

   return true;
}



