/*******************************************************************************
* FILE NAME: testmain.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     testmain- testmain for testing the countchars class                      *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMENUBAR_
#include <imenubar.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _IMLE_
#include <imle.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _ISPINNUM_
#include <ispinnum.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _DRAWCANVAS_
#include "DrwCnvas.hpp"
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _TCOUNTCHARS_
#include "TCntChrs.hpp"
#endif

#ifndef _TDRAWCHART_
#include "TDrwChrt.hpp"
#endif

#ifndef _ABOUTDIALOG_
#include "btDialog.hpp"
#endif

#ifndef _IVBFILED_
#include <ivbfiled.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _TESTMAIN_
#include "testmain.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for testmainConn0
//*****************************************************************************
class testmainConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, TCountChars * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   testmainConn0 & setPisText(IMultiLineEdit * aSelf) {iPisText = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to TCountChars1(CountAll))");
         try {target->countAll(iPisText->text());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   TCountChars * target;
   IMultiLineEdit * iPisText;


};   //testmainConn0


//*****************************************************************************
// Class definition for testmainConn2
//*****************************************************************************
class testmainConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(TCountChars * aSource, TCountChars * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   unsigned long actionResult() const { return iActionResult; };
   testmainConn2 & setActionResult(unsigned long aSelf) {
      iActionResult = aSelf;
      notifyObservers(INotificationEvent(actionResultId, *this));
      return *this;
      };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId actionResultId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == TCountChars::countOKId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : TCountChars1(CountOK) to TCountChars1(GetCount))");
         try {setActionResult(target->getCount('a'));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   TCountChars * source;
   TCountChars * target;
   unsigned long iActionResult;


};   //testmainConn2

const INotificationId testmainConn2::actionResultId = "testmainConn2::actionResult";

//*****************************************************************************
// Class definition for testmainConn3
//*****************************************************************************
class testmainConn3 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainConn2 * aSource, INumericSpinButton * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn2(actionResult) to NumericSpinButton1(value))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setValue(source->actionResult());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == testmainConn2::actionResultId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == INumericSpinButton::valueId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainConn2 * source;
   INumericSpinButton * target;
   Boolean aligning;


};   //testmainConn3


//*****************************************************************************
// Class definition for testmainConn8
//*****************************************************************************
class testmainConn8 : public IObserver {
public:
   virtual  ~testmainConn8(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(TDrawChart * aSource, INumericSpinButton * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : TDrawChart1(MinY) to NumericSpinButton21(value))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setMinY(target->value());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : TDrawChart1(MinY) to NumericSpinButton21(value))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setValue(source->MinY());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == TDrawChart::MinYId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == INumericSpinButton::valueId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   TDrawChart * source;
   INumericSpinButton * target;
   Boolean aligning;


};   //testmainConn8


//*****************************************************************************
// Class definition for testmainConn18
//*****************************************************************************
class testmainConn18 : public IObserver {
public:
   virtual  ~testmainConn18(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(TDrawChart * aSource, INumericSpinButton * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : TDrawChart1(MaxY) to NumericSpinButton2(value))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setMaxY(target->value());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : TDrawChart1(MaxY) to NumericSpinButton2(value))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setValue(source->MaxY());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == TDrawChart::MaxYId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == INumericSpinButton::valueId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   TDrawChart * source;
   INumericSpinButton * target;
   Boolean aligning;


};   //testmainConn18


//*****************************************************************************
// Class definition for testmainConn19
//*****************************************************************************
class testmainConn19 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn19(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, TDrawChart * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   testmainConn19 & setPulValues(TCountChars * aSelf) {iPulValues = aSelf; return *this;};
   testmainConn19 & setDC(DrawCanvas * aSelf) {iDC = aSelf; return *this;};
   testmainConn19 & setIFlags(INumericSpinButton * aSelf) {iIFlags = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to TDrawChart1(DrawChart))");
         try {target->drawChart(iPulValues->Counts(), 256, iDC, iIFlags->value());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   TDrawChart * target;
   TCountChars * iPulValues;
   DrawCanvas * iDC;
   INumericSpinButton * iIFlags;


};   //testmainConn19


//*****************************************************************************
// Class definition for testmainConn13
//*****************************************************************************
class testmainConn13 : public IObserver, public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   testmainConn13(unsigned long tid) {partWindowId = tid;};

   virtual  ~testmainConn13(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMenuBar * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::commandId)
      if (((IEvent *) anEvent.eventData().asUnsignedLong())->parameter1().number1() == partWindowId+WNDOFFSET_testmain_MenuItem2)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : MenuItem2(commandEvent) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMenuBar * source;
   IFrameWindow * target;
   unsigned long partWindowId;


};   //testmainConn13


//*****************************************************************************
// Class definition for testmainConn14
//*****************************************************************************
class testmainConn14 : public IObserver, public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   testmainConn14(unsigned long tid) {partWindowId = tid;};

   virtual  ~testmainConn14(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMenuBar * aSource, testmainabout_fabFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::commandId)
      if (((IEvent *) anEvent.eventData().asUnsignedLong())->parameter1().number1() == partWindowId+WNDOFFSET_testmain_MenuItem1)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : MenuItem1(commandEvent) to about_fab(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMenuBar * source;
   testmainabout_fabFactory * target;
   unsigned long partWindowId;


};   //testmainConn14


//*****************************************************************************
// Class definition for testmainConn15
//*****************************************************************************
class testmainConn15 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn15(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainabout_fabFactory * aSource, IVBVariablePartPointer<AboutDialog *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target) return(*this);
      if (anEvent.notificationId() == testmainabout_fabFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : about_fab(newEvent) to about_dlg(this))");
         try {target->setTarget((AboutDialog *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainabout_fabFactory * source;
   IVBVariablePartPointer<AboutDialog *> * target;


};   //testmainConn15


//*****************************************************************************
// Class definition for testmainConn17
//*****************************************************************************
class testmainConn17 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn17(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainabout_fabFactory * aSource, IVBVariablePartPointer<AboutDialog *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target->target()) return(*this);
      if (anEvent.notificationId() == testmainabout_fabFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : about_fab(newEvent) to about_dlg(showModally))");
         try {target->target()->showModally();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainabout_fabFactory * source;
   IVBVariablePartPointer<AboutDialog *> * target;


};   //testmainConn17


//*****************************************************************************
// Class definition for testmainConn28
//*****************************************************************************
class testmainConn28 : public IObserver, public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   testmainConn28(unsigned long tid) {partWindowId = tid;};

   virtual  ~testmainConn28(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMenuBar * aSource, IVBFileDialog * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::commandId)
      if (((IEvent *) anEvent.eventData().asUnsignedLong())->parameter1().number1() == partWindowId+WNDOFFSET_testmain_MenuItem3)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : MenuItem3(commandEvent) to VBFileDialog1(showModally))");
         try {target->showModally();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMenuBar * source;
   IVBFileDialog * target;
   unsigned long partWindowId;


};   //testmainConn28


//*****************************************************************************
// Class definition for testmainConn39
//*****************************************************************************
class testmainConn39 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn39(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBFileDialog * aSource, IMultiLineEdit * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   testmainConn39 & setFileName(IVBFileDialog * aSelf) {iFileName = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IVBFileDialog::pressedOkId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : VBFileDialog1(pressedOkEvent) to MultiLineEdit1(importFromFile))");
         try {target->importFromFile(iFileName->fileName());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBFileDialog * source;
   IMultiLineEdit * target;
   IVBFileDialog * iFileName;


};   //testmainConn39


//*****************************************************************************
// Class definition for testmainConn40
//*****************************************************************************
class testmainConn40 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn40(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainabout_fabFactory * aSource, IVBVariablePartPointer<AboutDialog *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target->target()) return(*this);
      if (anEvent.notificationId() == testmainabout_fabFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : about_fab(newEvent) to about_dlg(setFocus))");
         try {target->target()->setFocus();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainabout_fabFactory * source;
   IVBVariablePartPointer<AboutDialog *> * target;


};   //testmainConn40


const INotificationId testmainabout_fabFactory::newObjectCreatedId = "testmainabout_fabFactory::newObjectCreatedId";

//------------------------------------------------------------------------------
// testmainabout_fabFactory :: testmainabout_fabFactory
//------------------------------------------------------------------------------
#pragma export (testmainabout_fabFactory::testmainabout_fabFactory(unsigned long))
testmainabout_fabFactory::testmainabout_fabFactory(unsigned long anId)
{
   enableNotification();
   partWindowId = anId;
}

//------------------------------------------------------------------------------
// testmainabout_fabFactory :: ~testmainabout_fabFactory
//------------------------------------------------------------------------------
#pragma export (testmainabout_fabFactory::~testmainabout_fabFactory())
testmainabout_fabFactory::~testmainabout_fabFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// testmainabout_fabFactory :: create
//------------------------------------------------------------------------------
#pragma export (testmainabout_fabFactory::create())
AboutDialog * testmainabout_fabFactory::create()
{
   AboutDialog *iabout_fab = new AboutDialog(
      partWindowId+WNDOFFSET_testmain_about_fab, 
      IWindow::desktopWindow(), 
      0, 
      AboutDialog::defaultFramingSpec());
   iabout_fab->setAutoDeleteObject(true);
   iabout_fab->enableNotification();
   iabout_fab->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iabout_fab)));
   return(iabout_fab);
}

#pragma export (testmain::readyId)
const INotificationId testmain::readyId = "testmain::readyId";

#pragma export (testmain::partWindowId)
unsigned long testmain::partWindowId = 0;

//------------------------------------------------------------------------------
// testmain :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (testmain::defaultFramingSpec())
const IRectangle testmain::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 659),ISize(776, 659)));
}


//------------------------------------------------------------------------------
// testmain :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (testmain::defaultTitle())
IString testmain::defaultTitle()
{
   return("Tels' visual example count chars");
}


//------------------------------------------------------------------------------
// testmain :: testmain
//------------------------------------------------------------------------------
#pragma export (testmain::testmain(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
testmain::testmain(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iFrameWindowMenu = new IMenuBar(this);
   iFrameWindowMenu->addText(partWindowId+WNDOFFSET_testmain_MenuCascade1, "File").addSubmenu(partWindowId+WNDOFFSET_testmain_MenuCascade1);
   iFrameWindowMenu->addText(partWindowId+WNDOFFSET_testmain_MenuItem3, "Open", partWindowId+WNDOFFSET_testmain_MenuCascade1);
   iFrameWindowMenu->addSeparator(partWindowId+WNDOFFSET_testmain_MenuSeparator1, partWindowId+WNDOFFSET_testmain_MenuCascade1);
   iFrameWindowMenu->addText(partWindowId+WNDOFFSET_testmain_MenuItem2, "Exit", partWindowId+WNDOFFSET_testmain_MenuCascade1);
   iFrameWindowMenu->addText(partWindowId+WNDOFFSET_testmain_MenuCascade2, "Help").addSubmenu(partWindowId+WNDOFFSET_testmain_MenuCascade2);
   iFrameWindowMenu->addText(partWindowId+WNDOFFSET_testmain_MenuItem1, "About", partWindowId+WNDOFFSET_testmain_MenuCascade2);
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iMultiLineEdit1 = new IMultiLineEdit(
      partWindowId+WNDOFFSET_testmain_MultiLineEdit1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(30,400),ISize(721, 164)), 
      IMultiLineEdit::defaultStyle() | IMultiLineEdit::wordWrap | IControl::tabStop);
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(30,351),ISize(80, 36)));
   iNumericSpinButton1 = new INumericSpinButton(
      partWindowId+WNDOFFSET_testmain_NumericSpinButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(497,352),ISize(254, 32)));
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(370,354),ISize(115, 27)));
   iDrawCanvas1 = new DrawCanvas(
      partWindowId+WNDOFFSET_testmain_DrawCanvas1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(125,21),ISize(512, 315)), 
      ICanvas::defaultStyle() | IWindow::saveBits | IWindow::synchPaint | IWindow::visible);
   iNumericSpinButton2 = new INumericSpinButton(
      partWindowId+WNDOFFSET_testmain_NumericSpinButton2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(16,295),ISize(99, 32)), 
      INumericSpinButton::defaultStyle() & ~IBaseSpinButton::master | IBaseSpinButton::readOnly);
   iNumericSpinButton21 = new INumericSpinButton(
      partWindowId+WNDOFFSET_testmain_NumericSpinButton21, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(16,23),ISize(99, 39)), 
      INumericSpinButton::defaultStyle() & ~IBaseSpinButton::master | IBaseSpinButton::readOnly);
   iPushButton2 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(648,22),ISize(73, 36)));
   iNumericSpinButton3 = new INumericSpinButton(
      partWindowId+WNDOFFSET_testmain_NumericSpinButton3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(646,188),ISize(65, 32)), 
      INumericSpinButton::defaultStyle() | IBaseSpinButton::master | IControl::tabStop);
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText4, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(648,226),ISize(108, 27)));
   iTCountChars1 = new TCountChars();
   iTDrawChart1 = new TDrawChart();
   iabout_fab = new testmainabout_fabFactory(partWindowId);
   iabout_dlg = new IVBVariablePartPointer<AboutDialog *>();
   iVBFileDialog1 = new IVBFileDialog(this);

   conn0 = new testmainConn0();
   conn2 = new testmainConn2();
   conn3 = new testmainConn3();
   conn8 = new testmainConn8();
   conn18 = new testmainConn18();
   conn19 = new testmainConn19();
   conn13 = new testmainConn13(partWindowId);
   conn14 = new testmainConn14(partWindowId);
   conn15 = new testmainConn15();
   conn17 = new testmainConn17();
   conn28 = new testmainConn28(partWindowId);
   conn39 = new testmainConn39();
   conn40 = new testmainConn40();

   this->setFocus();
   this->setClient(iCanvas);
   iMultiLineEdit1->setText("This is a sample text. ");
   iPushButton1->setText("Count");
   iStaticText3->setText("Count of 'a':");
   iDrawCanvas1->setMinimumSize(ISize(576, 432));
   iDrawCanvas1->setBackgroundColor(IColor(IColor::paleGray));
   iNumericSpinButton2->setLimit(8);
   iNumericSpinButton2->setValue(1);
   iNumericSpinButton21->setLimit(8);
   iNumericSpinButton21->setValue(1);
   iPushButton2->setText("Draw");
   iNumericSpinButton3->setLimit(1);
   iNumericSpinButton3->setRange(IRange(0, 1));
   iStaticText4->setText("Chart type:");
}     //end constructor


//------------------------------------------------------------------------------
// testmain :: ~testmain
//------------------------------------------------------------------------------
#pragma export (testmain::~testmain())
testmain::~testmain()
{
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn2->stopHandlingNotificationsFor(*iTCountChars1);
   conn3->stopHandlingNotificationsFor(*conn2);
   conn3->stopHandlingNotificationsFor(*iNumericSpinButton1);
   conn8->stopHandlingNotificationsFor(*iTDrawChart1);
   conn8->stopHandlingNotificationsFor(*iNumericSpinButton21);
   conn18->stopHandlingNotificationsFor(*iTDrawChart1);
   conn18->stopHandlingNotificationsFor(*iNumericSpinButton2);
   conn19->stopHandlingNotificationsFor(*iPushButton2);
   conn13->stopHandlingNotificationsFor(*this);
   conn14->stopHandlingNotificationsFor(*this);
   conn15->stopHandlingNotificationsFor(*iabout_fab);
   conn17->stopHandlingNotificationsFor(*iabout_fab);
   conn28->stopHandlingNotificationsFor(*this);
   conn39->stopHandlingNotificationsFor(*iVBFileDialog1);
   conn40->stopHandlingNotificationsFor(*iabout_fab);

   delete conn0;
   delete conn2;
   delete conn3;
   delete conn8;
   delete conn18;
   delete conn19;
   delete conn13;
   delete conn14;
   delete conn15;
   delete conn17;
   delete conn28;
   delete conn39;
   delete conn40;

   delete iFrameWindowMenu;

   delete iCanvas;
   delete iMultiLineEdit1;
   delete iPushButton1;
   delete iNumericSpinButton1;
   delete iStaticText3;
   delete iDrawCanvas1;
   delete iNumericSpinButton2;
   delete iNumericSpinButton21;
   delete iPushButton2;
   delete iNumericSpinButton3;
   delete iStaticText4;
   delete iTCountChars1;
   delete iTDrawChart1;
   delete iabout_fab;
   delete iabout_dlg;
   delete iVBFileDialog1;
}

//------------------------------------------------------------------------------
// testmain :: initializePart
//------------------------------------------------------------------------------
#pragma export (testmain::initializePart())
testmain & testmain::initializePart()
{
   iDrawCanvas1->initializePart();
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// testmain :: makeConnections
//------------------------------------------------------------------------------
#pragma export (testmain::makeConnections())
Boolean testmain::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iMultiLineEdit1->enableNotification();
   iPushButton1->enableNotification();
   iNumericSpinButton1->enableNotification();
   iStaticText3->enableNotification();
   iDrawCanvas1->enableNotification();
   iNumericSpinButton2->enableNotification();
   iNumericSpinButton21->enableNotification();
   iPushButton2->enableNotification();
   iNumericSpinButton3->enableNotification();
   iStaticText4->enableNotification();
   iTCountChars1->enableNotification();
   iTDrawChart1->enableNotification();
   iabout_fab->enableNotification();
   iabout_dlg->enableNotification();
   iVBFileDialog1->enableNotification();

   conn0->initialize(iPushButton1, iTCountChars1);
   conn0->handleNotificationsFor(*iPushButton1);
   conn0->setPisText(iMultiLineEdit1);
   conn2->initialize(iTCountChars1, iTCountChars1);
   conn2->handleNotificationsFor(*iTCountChars1);
   conn3->initialize(conn2, iNumericSpinButton1);
   conn3->handleNotificationsFor(*conn2);
   conn3->handleNotificationsFor(*iNumericSpinButton1);
   conn8->initialize(iTDrawChart1, iNumericSpinButton21);
   conn8->handleNotificationsFor(*iTDrawChart1);
   conn8->handleNotificationsFor(*iNumericSpinButton21);
   conn18->initialize(iTDrawChart1, iNumericSpinButton2);
   conn18->handleNotificationsFor(*iTDrawChart1);
   conn18->handleNotificationsFor(*iNumericSpinButton2);
   conn19->initialize(iPushButton2, iTDrawChart1);
   conn19->handleNotificationsFor(*iPushButton2);
   conn19->setDC(iDrawCanvas1);
   conn19->setPulValues(iTCountChars1);
   conn19->setIFlags(iNumericSpinButton3);
   conn13->initialize(iFrameWindowMenu, this);
   conn13->handleNotificationsFor(*this);
   conn14->initialize(iFrameWindowMenu, iabout_fab);
   conn14->handleNotificationsFor(*this);
   conn15->initialize(iabout_fab, iabout_dlg);
   conn15->handleNotificationsFor(*iabout_fab);
   conn17->initialize(iabout_fab, iabout_dlg);
   conn17->handleNotificationsFor(*iabout_fab);
   conn28->initialize(iFrameWindowMenu, iVBFileDialog1);
   conn28->handleNotificationsFor(*this);
   conn39->initialize(iVBFileDialog1, iMultiLineEdit1);
   conn39->handleNotificationsFor(*iVBFileDialog1);
   conn39->setFileName(iVBFileDialog1);
   conn40->initialize(iabout_fab, iabout_dlg);
   conn40->handleNotificationsFor(*iabout_fab);

   conn8->setTarget();
   conn18->setTarget();
   return true;
}



