/*******************************************************************************
* FILE NAME: tstcntmn.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     testcntmain- testcnmnt                                                   *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISPINNUM_
#include <ispinnum.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IBMPCTL_
#include <ibmpctl.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _TESTCNT_
#include "testcnt.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _TESTCNTMAIN_
#include "tstcntmn.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for testcntmainConn0
//*****************************************************************************
class testcntmainConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testcntmainConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, testcnt * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to testcnt1(StartCount))");
         try {target->startCount();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   testcnt * target;


};   //testcntmainConn0


//*****************************************************************************
// Class definition for testcntmainConn1
//*****************************************************************************
class testcntmainConn1 : public IObserver {
public:
   virtual  ~testcntmainConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testcnt * aSource, INumericSpinButton * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : testcnt1(counter) to NumericSpinButton1(value))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setCounter(target->value());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : testcnt1(counter) to NumericSpinButton1(value))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setValue(source->counter());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == testcnt::counterId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == INumericSpinButton::valueId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testcnt * source;
   INumericSpinButton * target;
   Boolean aligning;


};   //testcntmainConn1


//*****************************************************************************
// Class definition for testcntmainConn2
//*****************************************************************************
class testcntmainConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testcntmainConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, testcnt * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to testcnt1(StopCount))");
         try {target->stopCount();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   testcnt * target;


};   //testcntmainConn2


#pragma export (testcntmain::readyId)
const INotificationId testcntmain::readyId = "testcntmain::readyId";

#pragma export (testcntmain::partWindowId)
unsigned long testcntmain::partWindowId = 0;

//------------------------------------------------------------------------------
// testcntmain :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (testcntmain::defaultFramingSpec())
const IRectangle testcntmain::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 341),ISize(512, 341)));
}


//------------------------------------------------------------------------------
// testcntmain :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (testcntmain::defaultTitle())
IString testcntmain::defaultTitle()
{
   return("Tels' Visual MultiThreading Example");
}


//------------------------------------------------------------------------------
// testcntmain :: testcntmain
//------------------------------------------------------------------------------
#pragma export (testcntmain::testcntmain(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
testcntmain::testcntmain(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_testcntmain_PushButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(18,245),ISize(63, 34)));
   iNumericSpinButton1 = new INumericSpinButton(
      partWindowId+WNDOFFSET_testcntmain_NumericSpinButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(95,245),ISize(318, 32)));
   iPushButton2 = new IPushButton(
      partWindowId+WNDOFFSET_testcntmain_PushButton2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(431,243),ISize(67, 36)));
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_testcntmain_StaticText3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(30,145),ISize(310, 27)));
   iStaticText7 = new IStaticText(
      partWindowId+WNDOFFSET_testcntmain_StaticText7, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(413,145),ISize(55, 27)));
   iBitmapControl1 = new IBitmapControl(
      partWindowId+WNDOFFSET_testcntmain_BitmapControl1, 
      iCanvas, 
      iCanvas, 
      IResourceId(10001), 
      IRectangle(IPoint(343,127),ISize(64, 64)));
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_testcntmain_StaticText4, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(134,86),ISize(283, 27)));
   iStaticText9 = new IStaticText(
      partWindowId+WNDOFFSET_testcntmain_StaticText9, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(122,51),ISize(307, 27)));
   iStaticText10 = new IStaticText(
      partWindowId+WNDOFFSET_testcntmain_StaticText10, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(143,20),ISize(264, 27)));
   itestcnt1 = new testcnt();

   conn0 = new testcntmainConn0();
   conn1 = new testcntmainConn1();
   conn2 = new testcntmainConn2();

   this->setFocus();
   this->setClient(iCanvas);
   iPushButton1->setText("Start");
   iNumericSpinButton1->setRange(IRange(0, 200));
   iPushButton2->setText("Stop");
   iStaticText3->setText("Visual Example #008  v1.1 (c) by ");
   iStaticText3->setForegroundColor(IColor(IColor::black));
   iStaticText7->setText("1997.");
   iStaticText7->setForegroundColor(IColor(IColor::black));
   iBitmapControl1->setMinimumSize(ISize(64, 64));
   iStaticText4->setText("Use freely, but give me credit!");
   iStaticText4->setForegroundColor(IColor(IColor::red));
   iStaticText9->setText("Visit my Webpage and find more:");
   iStaticText9->setForegroundColor(IColor(IColor::black));
   iStaticText10->setText("http://www.pobox.com/~tels");
}     //end constructor


//------------------------------------------------------------------------------
// testcntmain :: ~testcntmain
//------------------------------------------------------------------------------
#pragma export (testcntmain::~testcntmain())
testcntmain::~testcntmain()
{
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn1->stopHandlingNotificationsFor(*itestcnt1);
   conn1->stopHandlingNotificationsFor(*iNumericSpinButton1);
   conn2->stopHandlingNotificationsFor(*iPushButton2);

   delete conn0;
   delete conn1;
   delete conn2;


   delete iCanvas;
   delete iPushButton1;
   delete iNumericSpinButton1;
   delete iPushButton2;
   delete iStaticText3;
   delete iStaticText7;
   delete iBitmapControl1;
   delete iStaticText4;
   delete iStaticText9;
   delete iStaticText10;
   delete itestcnt1;
}

//------------------------------------------------------------------------------
// testcntmain :: initializePart
//------------------------------------------------------------------------------
#pragma export (testcntmain::initializePart())
testcntmain & testcntmain::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// testcntmain :: makeConnections
//------------------------------------------------------------------------------
#pragma export (testcntmain::makeConnections())
Boolean testcntmain::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iPushButton1->enableNotification();
   iNumericSpinButton1->enableNotification();
   iPushButton2->enableNotification();
   iStaticText3->enableNotification();
   iStaticText7->enableNotification();
   iBitmapControl1->enableNotification();
   iStaticText4->enableNotification();
   iStaticText9->enableNotification();
   iStaticText10->enableNotification();
   itestcnt1->enableNotification();

   conn0->initialize(iPushButton1, itestcnt1);
   conn0->handleNotificationsFor(*iPushButton1);
   conn1->initialize(itestcnt1, iNumericSpinButton1);
   conn1->handleNotificationsFor(*itestcnt1);
   conn1->handleNotificationsFor(*iNumericSpinButton1);
   conn2->initialize(iPushButton2, itestcnt1);
   conn2->handleNotificationsFor(*iPushButton2);

   conn1->setTarget();
   return true;
}



