#ifndef _IOBSPTR2_
#define _IOBSPTR2_
/*******************************************************************************
* FILE NAME: iobsptr2.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IObserverPtr                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#include <ievtdata.hpp>

class IObserver;
class INotificationEvent;
class IObserverPtrData;

#pragma pack(4)

class IObserverPtr
{
public:
/*------------------------------- Constructors -------------------------------*/
  IObserverPtr ( IObserver*   observerIn = 0,
                 IEventData   observerDataIn = 0 )
       : fObserverData ( observerDataIn ),
         fObsrvr ( observerIn ),
         fObserverPtrData ( 0 ) {}
 ~IObserverPtr () {}

IEventData fObserverData;
IObserver* fObsrvr;

private:
/*--------------------------------- Private ----------------------------------*/
IObserverPtrData* fObserverPtrData;
}; // IObserverPtr

#pragma pack()

#endif /* _IOBSPTR2_ */
