#ifndef _IOBSLIS2_
#define _IOBSLIS2_
// Do not let the old one get included.
#define _IOBSLIST_
/*******************************************************************************
* FILE NAME: iobslis2.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IObserverList                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#include <ivbase.hpp>

class IObserver;
class IObserverPointers;
class INotificationEvent;
class IObserverPtr;
class IObserverListData;

#pragma pack(4)

class IObserverList : public IVBase {
typedef IVBase
  Inherited;

public:

/*---------------------------- Constructors ----------------------------------*/
  IObserverList   ( );

virtual
 ~IObserverList   ( );

/*------------------------- Observer Notification ----------------------------*/
IObserverList
 &notifyObservers ( const INotificationEvent& event );

/*---------------------- Observer Addition and Removal -----------------------*/
virtual Boolean
  add             ( IObserver&       observer,
                    void*            userData );

virtual IObserverList
 &remove          ( const IObserver& observer ),
 &removeAll       ( );

Boolean
 isEmpty          ( ) const;


private:
/*--------------------------------- Private ----------------------------------*/
IObserverPointers*         fObserverPointers;
unsigned long              fNotifyDepth;

IObserverListData* fObserverListData;
friend class IObserverListData;

/*----------------------------- Hidden Functions -----------------------------*/
IObserverList ( const IObserverList& obsList );
IObserverList
 &operator= (const IObserverList& obsList);
}; //IObserverList

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/

#endif /* _IOBSLIS2_ */
