#ifndef _IANOTEV_
#define _IANOTEV_
/*******************************************************************************
* FILE NAME: ianotev.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAsyncNotificationEvent                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#include <inotifev.hpp>

#pragma pack(4)

class IAsyncNotificationEvent : public INotificationEvent {
typedef INotificationEvent
  Inherited;

public:
/*----------------------------- Constructors ---------------------------------*/
  IAsyncNotificationEvent ( const INotificationId& identifier,
                            INotifier&             notifier,
                            Boolean                notifierAttrChanged=true,
                            const IEventData&      eventData=IEventData(),
                            const IEventData&      observerData=IEventData() );

  IAsyncNotificationEvent ( const IAsyncNotificationEvent& event );

IAsyncNotificationEvent
 &operator=               ( const IAsyncNotificationEvent& event );

virtual
 ~IAsyncNotificationEvent ( );

}; //IAsyncNotificationEvent

#pragma pack()

#endif /* _IANOTEV_ */
