/*******************************************************************************
* FILE NAME: testmain.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     testmain- main window to test msgbox                                     *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IBMPCTL_
#include <ibmpctl.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _EVALMSGBOXRESULT_
#include "MsgBoxR.hpp"
#endif

#ifndef _IMSGBOX_
#include <imsgbox.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _TESTMAIN_
#include "testmain.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for testmainConn0
//*****************************************************************************
class testmainConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IMessageBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   IMessageBox::Response actionResult() const { return iActionResult; };
   testmainConn0 & setActionResult(IMessageBox::Response aSelf) {
      iActionResult = aSelf;
      notifyObservers(INotificationEvent(actionResultId, *this));
      return *this;
      };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId actionResultId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to MessageBox1(showCustomized))");
         try {setActionResult(target->show("Do you want to exit? ", IMessageBox::yesNoButton | IMessageBox::warningIcon));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IMessageBox * target;
   IMessageBox::Response iActionResult;


};   //testmainConn0

const INotificationId testmainConn0::actionResultId = "testmainConn0::actionResult";

//*****************************************************************************
// Class definition for testmainConn1
//*****************************************************************************
class testmainConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IMessageBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   IMessageBox::Response actionResult() const { return iActionResult; };
   testmainConn1 & setActionResult(IMessageBox::Response aSelf) {
      iActionResult = aSelf;
      notifyObservers(INotificationEvent(actionResultId, *this));
      return *this;
      };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId actionResultId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to MessageBox1(showCustomized))");
         try {setActionResult(target->show("Do you want to exit?", IMessageBox::okCancelButton | IMessageBox::errorIcon));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IMessageBox * target;
   IMessageBox::Response iActionResult;


};   //testmainConn1

const INotificationId testmainConn1::actionResultId = "testmainConn1::actionResult";

//*****************************************************************************
// Class definition for testmainConn2
//*****************************************************************************
class testmainConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IMessageBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   IMessageBox::Response actionResult() const { return iActionResult; };
   testmainConn2 & setActionResult(IMessageBox::Response aSelf) {
      iActionResult = aSelf;
      notifyObservers(INotificationEvent(actionResultId, *this));
      return *this;
      };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId actionResultId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton3(buttonClickEvent) to MessageBox1(show))");
         try {setActionResult(target->show("exit?", IMessageBox::catastrophic));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IMessageBox * target;
   IMessageBox::Response iActionResult;


};   //testmainConn2

const INotificationId testmainConn2::actionResultId = "testmainConn2::actionResult";

//*****************************************************************************
// Class definition for testmainConn3
//*****************************************************************************
class testmainConn3 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainConn2 * aSource, EvalMsgBoxResult * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == testmainConn2::actionResultId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn2(actionResult) to EvalMsgBoxResult1(EvalResult))");
         try {target->EvalResult(source->actionResult());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainConn2 * source;
   EvalMsgBoxResult * target;


};   //testmainConn3


//*****************************************************************************
// Class definition for testmainConn4
//*****************************************************************************
class testmainConn4 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(EvalMsgBoxResult * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == EvalMsgBoxResult::OKPressedID)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EvalMsgBoxResult1(OKPressed) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   EvalMsgBoxResult * source;
   IFrameWindow * target;


};   //testmainConn4


//*****************************************************************************
// Class definition for testmainConn5
//*****************************************************************************
class testmainConn5 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn5(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainConn1 * aSource, EvalMsgBoxResult * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == testmainConn1::actionResultId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn1(actionResult) to EvalMsgBoxResult1(EvalResult))");
         try {target->EvalResult(source->actionResult());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainConn1 * source;
   EvalMsgBoxResult * target;


};   //testmainConn5


//*****************************************************************************
// Class definition for testmainConn6
//*****************************************************************************
class testmainConn6 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn6(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(EvalMsgBoxResult * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == EvalMsgBoxResult::YesPressedID)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : EvalMsgBoxResult1(YesPressed) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   EvalMsgBoxResult * source;
   IFrameWindow * target;


};   //testmainConn6


//*****************************************************************************
// Class definition for testmainConn7
//*****************************************************************************
class testmainConn7 : public IObserver, public IStandardNotifier {
public:
   virtual  ~testmainConn7(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(testmainConn0 * aSource, EvalMsgBoxResult * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == testmainConn0::actionResultId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn0(actionResult) to EvalMsgBoxResult1(EvalResult))");
         try {target->EvalResult(source->actionResult());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   testmainConn0 * source;
   EvalMsgBoxResult * target;


};   //testmainConn7


#pragma export (testmain::readyId)
const INotificationId testmain::readyId = "testmain::readyId";

#pragma export (testmain::partWindowId)
unsigned long testmain::partWindowId = 0;

//------------------------------------------------------------------------------
// testmain :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (testmain::defaultFramingSpec())
const IRectangle testmain::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 432),ISize(576, 432)));
}


//------------------------------------------------------------------------------
// testmain :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (testmain::defaultTitle())
IString testmain::defaultTitle()
{
   return("Tels' MessageBox example");
}


//------------------------------------------------------------------------------
// testmain :: testmain
//------------------------------------------------------------------------------
#pragma export (testmain::testmain(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
testmain::testmain(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iCanvas = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(48,324),ISize(95, 36)));
   iCanvas1 = new ICanvas(
      partWindowId+WNDOFFSET_testmain_Canvas1, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(37,84),ISize(474, 185)));
   iStaticText10 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText10, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(129,8),ISize(264, 27)));
   iStaticText9 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText9, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(108,39),ISize(307, 27)));
   iStaticText4 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText4, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(120,74),ISize(283, 27)));
   iStaticText7 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText7, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(399,133),ISize(55, 27)));
   iBitmapControl1 = new IBitmapControl(
      partWindowId+WNDOFFSET_testmain_BitmapControl1, 
      iCanvas1, 
      iCanvas1, 
      IResourceId(10001), 
      IRectangle(IPoint(329,115),ISize(64, 64)));
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_testmain_StaticText3, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(16,133),ISize(310, 27)));
   iPushButton2 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton2, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(168,324),ISize(122, 36)));
   iPushButton3 = new IPushButton(
      partWindowId+WNDOFFSET_testmain_PushButton3, 
      iCanvas, 
      iCanvas, 
      IRectangle(IPoint(339,324),ISize(57, 36)));
   iEvalMsgBoxResult1 = new EvalMsgBoxResult();
   iMessageBox1 = new IMessageBox(this);

   conn0 = new testmainConn0();
   conn1 = new testmainConn1();
   conn2 = new testmainConn2();
   conn3 = new testmainConn3();
   conn4 = new testmainConn4();
   conn5 = new testmainConn5();
   conn6 = new testmainConn6();
   conn7 = new testmainConn7();

   this->setFocus();
   this->setClient(iCanvas);
   iCanvas->setBackgroundColor(IColor(IColor::paleGray));
   iPushButton1->setText("Yes  No");
   iCanvas1->setBackgroundColor(IColor(IColor::white));
   iStaticText10->setText("http://www.pobox.com/~tels");
   iStaticText9->setText("Visit my Webpage and find more:");
   iStaticText9->setForegroundColor(IColor(IColor::black));
   iStaticText4->setText("Use freely, but give me credit!");
   iStaticText4->setForegroundColor(IColor(IColor::red));
   iStaticText7->setText("1997.");
   iStaticText7->setForegroundColor(IColor(IColor::black));
   iBitmapControl1->setMinimumSize(ISize(64, 64));
   iStaticText3->setText("Visual Example #004  v1.0 (c) by ");
   iStaticText3->setForegroundColor(IColor(IColor::black));
   iPushButton2->setText("OK Cancel");
   iPushButton3->setText("OK");
}     //end constructor


//------------------------------------------------------------------------------
// testmain :: ~testmain
//------------------------------------------------------------------------------
#pragma export (testmain::~testmain())
testmain::~testmain()
{
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn1->stopHandlingNotificationsFor(*iPushButton2);
   conn2->stopHandlingNotificationsFor(*iPushButton3);
   conn3->stopHandlingNotificationsFor(*conn2);
   conn4->stopHandlingNotificationsFor(*iEvalMsgBoxResult1);
   conn5->stopHandlingNotificationsFor(*conn1);
   conn6->stopHandlingNotificationsFor(*iEvalMsgBoxResult1);
   conn7->stopHandlingNotificationsFor(*conn0);

   delete conn0;
   delete conn1;
   delete conn2;
   delete conn3;
   delete conn4;
   delete conn5;
   delete conn6;
   delete conn7;


   delete iCanvas;
   delete iPushButton1;
   delete iCanvas1;
   delete iStaticText10;
   delete iStaticText9;
   delete iStaticText4;
   delete iStaticText7;
   delete iBitmapControl1;
   delete iStaticText3;
   delete iPushButton2;
   delete iPushButton3;
   delete iEvalMsgBoxResult1;
   delete iMessageBox1;
}

//------------------------------------------------------------------------------
// testmain :: initializePart
//------------------------------------------------------------------------------
#pragma export (testmain::initializePart())
testmain & testmain::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// testmain :: makeConnections
//------------------------------------------------------------------------------
#pragma export (testmain::makeConnections())
Boolean testmain::makeConnections()
{
   this->enableNotification();
   iCanvas->enableNotification();
   iPushButton1->enableNotification();
   iCanvas1->enableNotification();
   iStaticText10->enableNotification();
   iStaticText9->enableNotification();
   iStaticText4->enableNotification();
   iStaticText7->enableNotification();
   iBitmapControl1->enableNotification();
   iStaticText3->enableNotification();
   iPushButton2->enableNotification();
   iPushButton3->enableNotification();
   iEvalMsgBoxResult1->enableNotification();

   conn0->initialize(iPushButton1, iMessageBox1);
   conn0->handleNotificationsFor(*iPushButton1);
   conn1->initialize(iPushButton2, iMessageBox1);
   conn1->handleNotificationsFor(*iPushButton2);
   conn2->initialize(iPushButton3, iMessageBox1);
   conn2->handleNotificationsFor(*iPushButton3);
   conn3->initialize(conn2, iEvalMsgBoxResult1);
   conn3->handleNotificationsFor(*conn2);
   conn4->initialize(iEvalMsgBoxResult1, this);
   conn4->handleNotificationsFor(*iEvalMsgBoxResult1);
   conn5->initialize(conn1, iEvalMsgBoxResult1);
   conn5->handleNotificationsFor(*conn1);
   conn6->initialize(iEvalMsgBoxResult1, this);
   conn6->handleNotificationsFor(*iEvalMsgBoxResult1);
   conn7->initialize(conn0, iEvalMsgBoxResult1);
   conn7->handleNotificationsFor(*conn0);

   return true;
}



