/*
 * This file contains functions for the 2nd thread,  which reads
 * from the serial port.
 */

#include "pmterm.h"


static char **lines = NULL;
static int curline = 0;
static int curcol  = 0;

/*
 * PostMsg() -- just like WinPostMsg(),  but checks to see
 * if the queue was full
 */
static void PostMsg(HWND h, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    while(!WinPostMsg(h, msg, mp1, mp2)){
        DosSleep(1);
    }
}

char *format(long recnum, void *user)
{
    if(!lines)
	return NULL;
    return lines[recnum];
}


/* Scroll window so that current line will be visible */
static void Adjust(HWND hwnd, SCROLL *scrl, int line1, int line2)
{
    int y;
    int n;  // number of lines to scroll.

    y = scrl->yClient - scrl->yChar * (line2 + 1 - scrl->vScrollPos) + scrl->yDesc;
    if(y < 0){  // off bottom?
        n = y/scrl->yChar - 1;      // n will be negative
        WinSendMsg(hwnd,
                   WM_VSCROLL,
                   (MPARAM)FID_VERTSCROLL,
                   MPFROM2SHORT(scrl->vScrollPos - n,
                        SB_SLIDERPOSITION));
    }
    else{
        y = scrl->yClient - scrl->yChar * (line1 + 1 - scrl->vScrollPos) + scrl->yDesc;
        if(y > scrl->yClient){  // beyond top?
            n = 1 + (y - scrl->yClient)/scrl->yChar;

            WinSendMsg(hwnd,
		       WM_VSCROLL,
		       (MPARAM)FID_VERTSCROLL,
                       MPFROM2SHORT(scrl->vScrollPos - n,
			    SB_SLIDERPOSITION));

	}
    }
}

void PaintLines(HWND hwnd, int startline, int endline)
{
    int line;
    POINTL pt;				  /* String screen coordinates	  */
    HPS hps;
    int ofs;
    char *str;
    int cols;
    SCROLL *scrl = WinQueryWindowPtr(hwnd, 0);

    if(startline < 0)
        startline = 0;
    Adjust(hwnd, scrl, startline, endline);  // make sure new lines will be visible

    hps = WinGetPS(hwnd);
    pt.x = 0L;
    ofs = scrl->hScrollPos;
    for(line=startline; line<=endline; line++){
	pt.y = scrl->yClient - scrl->yChar * (line + 1 - scrl->vScrollPos) + scrl->yDesc;
	str = (*scrl->func)(line, scrl->user);
	if(str){
	    if(strlen(str) > ofs){
		cols = strlen(str + ofs);
		if(cols)
		    GpiCharStringAt( hps, &pt,
		    (ULONG) ((cols > (scrl->cols+5)) ? (scrl->cols+5) : cols),
		    str + ofs);
	    }
	}
    }
    WinReleasePS(hps);
}

void Cls(HWND hwnd)
{
    int j;
    for(j=0; j<MAXLINES; j++)
	lines[j][0] = 0;
    curline = curcol = 0;
    WinInvalidateRect(hwnd, NULL, FALSE);
}


/* shift1() -- scroll top line into the bit bucket */
static void shift1(void)
{
    int i;

    for(i=0; i<MAXLINES-1; i++)
        lines[i] = lines[i+1];
    lines[i] = lines[0];

}

static void print(PDATA *pdata, char *lbuf, ULONG len)
{
    int i;
    int startline = curline;
    int pre_scroll = 0;

    for(i=0; i<len; i++){
	switch(lbuf[i]){
	    case '\r':
		break;
	    case '\n':
                lines[curline][curcol] = 0;
		curcol = 0;
		curline++;
		if(curline == MAXLINES){
                    shift1();
                    curline--;
                    pre_scroll++;
		}
		break;
	    case '\f':      // page eject == ascii 12 == cls
                PostMsg(pdata->hwndClient, WMU_CLS, 0, 0);
		break;
	    default:
		lines[curline][curcol++] = lbuf[i];
		if(curcol == MAXLINELEN){
		    lines[curline][curcol] = 0;
		    curcol = 0;
		    curline++;
                    if(curline == MAXLINES){
                        shift1();
                        curline--;
                        pre_scroll++;
                    }
		}
		break;
	}
    }
    lines[curline][curcol  ] = 0;

    if(pre_scroll)
        PostMsg(pdata->hwndClient, WMU_PRESCROLL, (MPARAM)pre_scroll, 0);

    PostMsg(pdata->hwndClient,
            WMU_PAINTLINES,
            (MPARAM)(startline - pre_scroll),
            (MPARAM)curline);
}

void AsyncReadThread(void *arg)
{
    PDATA *pdata = arg;
    APIRET rc;
    char buf[256];
    ULONG br;	    // bytes read
    int i;

    if(!lines){
        lines = (char **)calloc(MAXLINES , sizeof(char *));
        for(i=0; i<MAXLINES; i++){
            lines[i] = (char *)malloc(MAXLINELEN+1);
            *lines[i] = 0;
        }
    }

    for(;;){
	rc = DosRead(pdata->hf, buf, sizeof(buf), &br);
	if(rc)
	    break;
	if(br){
	    print(pdata, buf, br);
	}
	else { // else, no bytes were read (5 second time out).
	    // nice place for a carrier check
            DosSleep(1L);
	}
    }
    printf("Unexpected error %d from DosRead()\n", rc);
    _endthread();
}

