
#include "pmterm.h"

/*
 * This file manages the "Settings" dialog
 */

static MRESULT EXPENTRY DlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    PDATA *pdata = WinQueryWindowPtr(hwnd, QWL_USER);
    switch (msg) {
	case WM_INITDLG:
	    WinSetWindowPtr(hwnd, QWL_USER, mp2);
	    return 0;
	case WM_COMMAND:
	    switch (SHORT1FROMMP(mp1)) {
		case DID_OK:
		    WinDismissDlg(hwnd, TRUE);
		    return 0L;
		case DID_CANCEL:
		    WinDismissDlg(hwnd, FALSE);
		    return 0L;
	    }
	    break;
    }
    return (WinDefDlgProc(hwnd, msg, mp1, mp2));
}



void Settings(PDATA *pdata)
{
    HWND hwndDlg, h;
    long maxbps;
    static int rates[] = {110, 300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 67200, 115200, 0};
    int i;
    char str[20];
    USHORT id;

    hwndDlg = WinLoadDlg(HWND_DESKTOP, pdata->hwndClient, DlgProc, 0, DLG_SETTINGS, pdata);
    if(!hwndDlg)
	return;

    WinSetDlgItemText(hwndDlg, IDEF_INITSTRING, pdata->ini.InitString);

    h = WinWindowFromID(hwndDlg, IDEF_SPEED);
    maxbps = QueryMaxRate(pdata->hf);
    for(i=0; rates[i] && rates[i] <= maxbps; i++){
	sprintf(str, "%d", rates[i]);
	WinInsertLboxItem(h, LIT_END, str);
    }
    sprintf(str, "%d", pdata->ini.bps);
    WinSetWindowText(h, str);


    h = WinWindowFromID(hwndDlg, IDCB_DEVICENAME);
    for(i=0; i<4; i++){
	sprintf(str, "COM%d", i+1);
	WinInsertLboxItem(h, LIT_END, str);
    }
    WinSetWindowText(h, pdata->ini.DevName);

    switch(pdata->ini.databits){
	case 5: id = IDRB_5; break;
	case 6: id = IDRB_6; break;
	case 7: id = IDRB_7; break;
	case 8: id = IDRB_8; break;
       default: id = IDRB_8; break;
    }
    WinSendDlgItemMsg(hwndDlg, id, BM_SETCHECK, (MPARAM)TRUE, 0);

    switch(pdata->ini.stopbits){
	case 0: id = IDRB_1 ; break;
	case 1: id = IDRB_15; break;
	case 2: id = IDRB_2 ; break;
       default: id = IDRB_1; break;
    }
    WinSendDlgItemMsg(hwndDlg, id, BM_SETCHECK, (MPARAM)TRUE, 0);

    switch(pdata->ini.parity){
	case 0: id = IDRB_NONE ; break;
	case 1: id = IDR_ODD   ; break;
	case 2: id = IDRB_EVEN ; break;
	case 3: id = IDPB_MARK ; break;
	case 4: id = IDRB_SPACE; break;
       default: id = IDRB_NONE; break;
    }
    WinSendDlgItemMsg(hwndDlg, id, BM_SETCHECK, (MPARAM)TRUE, 0);

    if(pdata->ini.CtsRts  )  WinSendDlgItemMsg(hwndDlg, IDCHK_CTS   , BM_SETCHECK, (MPARAM)TRUE, 0);
    if(pdata->ini.XonXoff )  WinSendDlgItemMsg(hwndDlg, IDCHK_XON   , BM_SETCHECK, (MPARAM)TRUE, 0);
    if(pdata->ini.ExtBuf  )  WinSendDlgItemMsg(hwndDlg, IDCHK_EXTBUF, BM_SETCHECK, (MPARAM)TRUE, 0);

    if(WinProcessDlg(hwndDlg)){
	WinQueryDlgItemText(hwndDlg, IDEF_INITSTRING, sizeof(pdata->ini.InitString), pdata->ini.InitString);
	WinQueryDlgItemText(hwndDlg, IDCB_DEVICENAME, sizeof(pdata->ini.DevName), pdata->ini.DevName);
	WinQueryDlgItemText(hwndDlg, IDEF_SPEED, sizeof(str), str);
	pdata->ini.bps = atol(str);

	     if(WinSendDlgItemMsg(hwndDlg, IDRB_5, BM_QUERYCHECK, 0, 0)) pdata->ini.databits = 5;
	else if(WinSendDlgItemMsg(hwndDlg, IDRB_6, BM_QUERYCHECK, 0, 0)) pdata->ini.databits = 6;
	else if(WinSendDlgItemMsg(hwndDlg, IDRB_7, BM_QUERYCHECK, 0, 0)) pdata->ini.databits = 7;
	else pdata->ini.databits = 8;

	     if(WinSendDlgItemMsg(hwndDlg, IDRB_1 , BM_QUERYCHECK, 0, 0)) pdata->ini.stopbits = 0;
	else if(WinSendDlgItemMsg(hwndDlg, IDRB_15, BM_QUERYCHECK, 0, 0)) pdata->ini.stopbits = 1;
	else pdata->ini.stopbits = 2;

	     if(WinSendDlgItemMsg(hwndDlg, IDRB_NONE , BM_QUERYCHECK, 0, 0)) pdata->ini.parity = 0;
	else if(WinSendDlgItemMsg(hwndDlg, IDR_ODD   , BM_QUERYCHECK, 0, 0)) pdata->ini.parity = 1;
	else if(WinSendDlgItemMsg(hwndDlg, IDRB_EVEN , BM_QUERYCHECK, 0, 0)) pdata->ini.parity = 2;
	else if(WinSendDlgItemMsg(hwndDlg, IDPB_MARK , BM_QUERYCHECK, 0, 0)) pdata->ini.parity = 3;
	else pdata->ini.parity = 4;

	pdata->ini.CtsRts  =  (BOOL)WinSendDlgItemMsg(hwndDlg, IDCHK_CTS   , BM_QUERYCHECK, 0, 0);
	pdata->ini.XonXoff =  (BOOL)WinSendDlgItemMsg(hwndDlg, IDCHK_XON   , BM_QUERYCHECK, 0, 0);
	pdata->ini.ExtBuf  =  (BOOL)WinSendDlgItemMsg(hwndDlg, IDCHK_EXTBUF, BM_QUERYCHECK, 0, 0);
        if(SetupPort(pdata)){
            HINI hini;
            hini = PrfOpenProfile(pdata->hab, "pmterm.ini");
            if(!hini){
                ErrMesg(pdata, "Couldn't open ini file 'PMTERM.INI'");
                exit(1);
            }
            PrfWriteProfileData(hini, "pmterm", "settings", &pdata->ini, sizeof(INI_STUFF));
            PrfCloseProfile(hini);
        }
    }
    WinDestroyWindow(hwndDlg);
}
