/*------------------------------------------------------------------------
         FILE HEADER FOR pipesrv.cpp
         HEADER LAST UDPATED : August 29, 1995
         PURPOSE :
              This is the code for the server side of the named pipe
         server.

----------------------------------------------------------------------*/

#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <malloc.h>
#include <process.h>
#include <dos.h>
#include <stdlib.h>
#include "const.h"


/*--- STRUCTURE FOR EXCHANGING DATA ---*/
typedef struct
        {
        short usCmd;
        char acData[_MIN_PIPE_BUFFER];
        } PIPEDATA;

char szServerData[_MIN_PIPE_BUFFER];
ULONG ulInstanceCount;
void ClientThread(void *pParam);
void ServeClient(HEV hev);
void ProcessPipeRequest(PIPESEMSTATE *pSemState);

void ServerRead(PIPESEMSTATE *pSemState,PIPEDATA *pPipeData);
void ServerWrite(PIPESEMSTATE *pSemState,PIPEDATA *pPipeData);
void ServerSystem(PIPESEMSTATE *pSemState,PIPEDATA *pPipeData);



#pragma argsused
void main()
{
APIRET rc;
HPIPE hpipe;
HEV hev;

strcpy(szServerData,"NO DATA HERE!!!!");

/*-----------------------------------------------------------------------
              Create an event semaphore for the pipe.

   -----------------------------------------------------------------*/

hev = NULLHANDLE;
rc = DosCreateEventSem(NULL,
                       &hev,
                       DC_SEM_SHARED,
                       FALSE);
if (rc != 0)
   {
   printf("DosCreateEventSem returned %d\n",rc);
   DosExit(EXIT_PROCESS,1);
   }


/*-----------------------------------------------------------------------
              Start a thread which blocks on the pipe.

   -----------------------------------------------------------------*/

if (_beginthread(&ClientThread,8198,(PVOID)hev) == -1)
   {
   printf("Could not create thread, error %d \n",errno);
   DosExit(EXIT_PROCESS,1);
   }

ulInstanceCount = 0;
while (1)
    {
    rc = DosCreateNPipe("\\PIPE\\TEST",
                        &hpipe,
                        NP_ACCESS_DUPLEX,
                        NP_TYPE_BYTE | NP_WAIT | NP_READMODE_BYTE | 0xFF,
                        0xFFFF,
                        0xFFFF,
                        SEM_INDEFINITE_WAIT);
    if (rc != 0)
       {
       printf("DosCreateNamedPipe returned %d\n",rc);
       DosExit(EXIT_PROCESS,1);
       }

    rc = DosSetNPipeSem(hpipe,(HSEM)hev,hpipe);
    if (rc != 0)
       {
       printf("DosSetNPipeSem returned %d\n",rc);
       DosExit(EXIT_PROCESS,1);
       }


    printf("Waiting for connection .... \n");
    rc = DosConnectNPipe(hpipe);
    if (rc != 0)
       {
       printf("DosConnectNPipe returned %d\n",rc);
       DosExit(EXIT_PROCESS,1);
       }


    ulInstanceCount++;

    ULONG ulBytesWritten;
    PIPEDATA PipeData;
    strcpy(PipeData.acData,"STARTED");
    PipeData.usCmd = RESPONSE_STARTED;
    rc = DosWrite(hpipe,&PipeData,
                 sizeof(PipeData.usCmd)+strlen(PipeData.acData),
                 &ulBytesWritten);
    if (rc != 0)
       {
       printf("DosWrite returned %d\n",rc);
       DosExit(EXIT_PROCESS,1);
       }
    }




}


#pragma argsused
void ClientThread(void *pParam)
{
while (TRUE)
     ServeClient((HEV)pParam);
}

void ServeClient(HEV hev)
{
ULONG ulPostCount;

APIRET rc;
rc = DosWaitEventSem(hev,SEM_INDEFINITE_WAIT);
if (rc != 0)
   {
   printf("DosWaitEventSem returned %d\n",rc);
   DosExit(EXIT_PROCESS,1);
   }
rc = DosResetEventSem(hev,&ulPostCount);
if (rc != 0)
   {
   printf("DosResetEventSem returned %d\n",rc);
   DosExit(EXIT_PROCESS,1);
   }


PIPESEMSTATE *pSemState;  /* ALLOCATED INPUT TO DosQueryNPipeState */
ULONG cbSemState;         /* BYTE COUNT ALLOCATED FOR pSemState */
ULONG ulCount;            /* SAVED COUNT OF INSTANCES */

/*------------------------------------------------------------------
              Allocate memory for querying PIPESEMSTATE for all pipe
         instances via DosQueryNPipeSemState.

-----------------------------------------------------------------------*/

ulCount = ulInstanceCount;
cbSemState = (ulCount+2)*sizeof(PIPESEMSTATE);
pSemState = (PIPESEMSTATE *)malloc(cbSemState);
if (pSemState == NULL)
   {
   perror("malloc");
   DosExit(EXIT_PROCESS,1);
   }

/*------------------------------------------------------------------
              Get the PIPESEMSTATE instance data for each pipe instance.

-----------------------------------------------------------------------*/


rc = DosQueryNPipeSemState((HSEM)hev,pSemState,cbSemState);
if (rc != 0)
   {
   printf("DosQueryNPipeSemState returned %d\n",rc);
   DosExit(EXIT_PROCESS,1);
   }


/*------------------------------------------------------------------
              Execute "ProcessPipeRequest" for each instance.

-----------------------------------------------------------------------*/

for (ULONG ul = 0; ul <= ulCount; ul++)
    {  /*--- FOR EACH INSTANCE, PROCESS THE PIPE ---*/
    if (pSemState[ul].fStatus == 0) break;
    ProcessPipeRequest(&pSemState[ul]);
    }

free(pSemState);
}



void ProcessPipeThread(void *pThreadParam)
{
PIPEDATA *pPipeData;
APIRET rc;
ULONG ulBytesRead;
ULONG ulBytesWritten;
ULONG cbPipeBuf;
PIPESEMSTATE *pSemState;

pSemState = (PIPESEMSTATE *)pThreadParam;
switch (pSemState->fStatus)
       {
       case NPSS_EOI:
            break;
       case NPSS_WSPACE:
            break;
       case NPSS_RDATA:
               /*--- ALLOCATE A BUFFER LARGE ENOUGH FOR READ ---*/
            cbPipeBuf = max(pSemState->usAvail,(USHORT)_MIN_PIPE_BUFFER);
            pPipeData = (PIPEDATA *)malloc(cbPipeBuf);
            if (pPipeData == NULL)
               {
               perror("malloc");
               DosExit(EXIT_PROCESS,1);
               }

                /*--- READ THE PIPE DATAINTO THE ALLOCATED BUFFER ---*/
            rc = DosRead((HFILE)pSemState->usKey,pPipeData,
                         pSemState->usAvail,&ulBytesRead);
            if (rc != 0)
               {
               printf("DosRead returned %d.\n",rc);
               DosExit(EXIT_PROCESS,1);
               }

                /*--- EXECUTE COMMAND BASED ON THE DATA READ ---*/
             printf("Data read : %s\n",pPipeData->acData);
             switch (pPipeData->usCmd)
                    {
                    case CMD_WRITE:
                         /*--- EXECUTE -w OPTION FROM CLIENT ---*/
                         ServerWrite(pSemState,pPipeData);
                         break;
                    case CMD_READ:
                         /*--- EXECUTE -r OPTION FROM CLIENT ---*/
                         ServerRead(pSemState,pPipeData);
                         break;
                    case CMD_SYSTEM:
                         /*--- EXECUTE -c OPTION FROM CLIENT ---*/
                         ServerSystem(pSemState,pPipeData);
                         break;
                    default:
                         /*-- EXECUTION SHOULD NEVER REACH THIS POINT ---*/
                         printf("\aIllegal command %d!!!",pPipeData->usCmd);
                    }

               /*--- WRITE THE RETURN CODE BACK TO THE CLIENT ---*/
            if (pPipeData->usCmd == CMD_SYSTEM)
                cbPipeBuf = sizeof(pPipeData->usCmd) + sizeof(int);
            else
                cbPipeBuf = strlen(pPipeData->acData) + 1 +
                            sizeof(pPipeData->usCmd);
            rc = DosWrite((HFILE)pSemState->usKey,pPipeData,
                          cbPipeBuf,
                          &ulBytesWritten);
            if (rc != 0)
               {
               printf("DosWrite failed, rc = %d\n",rc);
               DosExit(EXIT_PROCESS,1);
               }

               /*--- FREE THE BUFFER USED FOR READING ---*/
            free(pPipeData);
            break;

       case NPSS_CLOSE:
            DosDisConnectNPipe((HFILE)pSemState->usKey);
            DosClose((HFILE)pSemState->usKey);
            ulInstanceCount--;
            break;
       default:
            printf("unknown state %d\n",pSemState->fStatus);
       }


   /*--- THE COMMON EXIT POINT FOR THIS ROUTINE IS HERE ----*/
free(pSemState);  /*-- pSemState WAS ALLOCATED IN ProcessPipeRequest() ----*/
}


#pragma argsused
void ServerRead(PIPESEMSTATE *pSemState,PIPEDATA *pPipeData)
{   /*--- EXECUTE A "READ" REQUEST ----*/
strcpy(pPipeData->acData,szServerData);
pPipeData->usCmd = RESPONSE_SUCCESS;
}

#pragma argsused
void ServerWrite(PIPESEMSTATE *pSemState,PIPEDATA *pPipeData)
{   /*--- EXECUTE A "WRITE" REQUEST ---*/
strcpy(szServerData,pPipeData->acData);
pPipeData->usCmd = RESPONSE_SUCCESS;
}

#pragma argsused
void ServerSystem(PIPESEMSTATE *pSemState,PIPEDATA *pPipeData)
{    /*--- EXECUTE A "system" CALL REQUEST ----*/
int iError = 0;
pPipeData->usCmd = RESPONSE_SUCCESS;
if (system(pPipeData->acData) == -1)
   {
   pPipeData->usCmd = RESPONSE_FAILED;
   iError = errno;
   }
memcpy(pPipeData->acData,&iError,sizeof(iError));
}


void ProcessPipeRequest(PIPESEMSTATE *pSemState)
{  /*--- PROCESS ONE REQUEST FROM A PIPE INSTANCE ---*/

   /*---- COPY PIPESEMSTATE INSTANCE DATA TO DYNAMIC MEMORY ---*/
PIPESEMSTATE *pThreadSemState;
pThreadSemState = (PIPESEMSTATE *)malloc(sizeof(PIPESEMSTATE));
if (pThreadSemState == NULL)
   {
   perror("malloc");
   DosExit(EXIT_PROCESS,1);
   }
memcpy(pThreadSemState,pSemState,sizeof(PIPESEMSTATE));

   /*--- START THE THREAD TO PROCESS THE CLIENT PIPE REQUEST ---*/
int tid;
if ((tid = _beginthread(&ProcessPipeThread,8198,pThreadSemState)) == -1)
   {
   printf("Could not create thread, error %d \n",errno);
   DosExit(EXIT_PROCESS,1);
   }
DosSetPriority(PRTYS_THREAD,PRTYC_FOREGROUNDSERVER,31,tid);

}

