/* ODxEyes OpenDoc part - Install via REXX */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
say '-------------------------------'
say '---- ODxEyes part - install ---'
say '-------------------------------'
say ''
Result = SysFileTree( 'ODXEYES.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: ODXEYES.DLL not found! Installation aborted.'
  Signal DONE
  End
Result = SysFileTree( 'EDBSENC.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: EDBSENC.DLL not found! Installation aborted.'
  Signal DONE
  End
Result = SysFileTree( 'EDBSEINF.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: EDBSEINF.DLL not found! Installation aborted.'
  Signal DONE
  End
Result = SysFileTree( 'EDBSELIS.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: EDBSELIS.DLL not found! Installation aborted.'
  Signal DONE
  End
Result = SysFileTree( 'ODXINST.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: ODXINST.EXE not found! Installion aborted.'
  Signal DONE
  End
Result = SysFileTree( 'ODXEYES.INF', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: ODXEYES.INF not found! Installation aborted.'
  Signal DONE
  End
Result = SysFileTree( 'README.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: README.TXT not found! Installation aborted.'
  Signal DONE
  End
Say 'Please insert the complete path to the directory the'
Say 'ODxEyes files shall be installed to (default C:\ODxEyes): '
Pull Directory
If Directory = "" Then Directory = 'C:\ODxEyes'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'Fehler: Cannot create the directory 'Directory'. Installation aborted.'
    Signal DONE
    End
  End
Say ''
Say 'Copy the ODxEyes files...'

Say ''
Say 'Copy ODXEYES.DLL to ' Directory '...'
Copy ODXEYES.DLL Directory                  '1>NUL'
Say 'Copy EDBSENC.DLL to ' Directory '...'
Copy EDBSENC.DLL Directory                  '1>NUL'
Say 'Copy EDBSEINF.DLL to ' Directory '...'
Copy EDBSEINF.DLL Directory                  '1>NUL'
Say 'Copy EDBSELIS.DLL to ' Directory '...'
Copy EDBSELIS.DLL Directory                  '1>NUL'
Say 'Copy ODXEYES.INF to' Directory '...'
Copy ODXEYES.INF Directory                  '1>NUL'
Say 'Copy ODXINST.EXE to' Directory '...'
Copy ODXINST.EXE Directory                  '1>NUL'
Say 'Copy INSTALL.CMD to' Directory '...'
Copy INSTALL.CMD Directory                  '1>NUL'
Say 'Copy README.TXT to' Directory '...'
Copy README.TXT Directory                  '1>NUL'
Say ''
Say 'Create shadow of ODxEyes.inf on desktop...'
Say ''

Type = 'WPShadow'
Title = 'ODxEyes Online-Manual'
Parms = 'SHADOWID='Directory'\ODxEyes.inf'
Folder="<WP_DESKTOP>"

Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

Say 'Set the directory 'Directory
Say 'into the CONFIG.SYS LIBPATH statement if not already set.'
Say ''
Call UpdateConfigSys
Say 'Register the ODxEyes part to OpenDoc'
Say 'If an error occures, restart OS/2, change to directory'
Say Directory' and start the program ODxInst.exe.'

'@'Directory'\ODxInst'

If Result=0 then
   Say 'The ODxEyes OpenDoc part has been successfully installed.'
else
   Do
      Say 'The ODxEyes OpenDoc part has not been successfully installed.'
      Say 'Restart OS/2, change to directory 'Directory
      Say 'and start the program ODxInst.exe.'
   End

Exit

FAILURE:
Say 'Install error.'
Signal DONE
HALT:
Say 'Install error.'
Signal DONE
SYNTAX:
Say 'Install error.'
Signal DONE
DONE:
Exit

/***************************/
/* Change the CONFIG.SYS   */
/***************************/

UpdateConfigSys:

'@cls'
response=''

Say '    Do you want to update 'bootdrive'\CONFIG.SYS?(Y/N)'
  Parse Upper Pull response
  If response <> 'N' Then Do
     Say '    The old 'bootdrive'\CONFIG.SYS will be created called 'bootdrive'\CONFIG.IW'
     Say ' '
     Say '    Shutdown and restart your system for these changes to take affect.'
     Say ' '
  End
  Else
     return 0



bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)

oldconfig=bootdrive'\CONFIG.SYS'
newconfig=bootdrive'\CONFIG.ED'
tmpconfig=bootdrive'\ODx.SYS'

os2somir='LIBPATH'

iniflag=0

/*
 * read the file one line at a time, and write it all out, making
 * changes accordingly - need to change path, libpath, help, IBMWORKS_INI
 */

'@del 'newconfig ' 2>nul >nul'

Do while lines(oldconfig)
    inline=linein(oldconfig)

    /******************************************/
    /* parse the line into variable and value */
    /******************************************/

    parse value inline with os2var '=' os2value

    /********************************************************/
    /* translate the variable into uppercase for comparison */
    /********************************************************/

    os2var=translate(os2var)
    Select

        /********************************************************/
        /*          For SOMIR                                   */
        /********************************************************/
        when os2var=os2somir Then Do
            ibmwline=inline

            /* see if path is already set */
            k = pos(Directory, translate(ibmwline))
            If k = 0 Then Do
               /*
                * see if there is a ; at the end of the value
                */
               position=lastpos(';',os2value)
               lenvalue=length(os2value)

               If position=lenvalue Then do
                   /* ; at end of value */
                   ibmwline=os2var'='os2value''Directory';'
               End
               Else Do
                   /* ; NOT at end of value */
                   ibmwline=os2var'='os2value';'Directory';'
               End
            End
            /*
             * write the line out to the new config file
             */

            result=lineout(newconfig, ibmwline)

            If result=1 Then Do
                writeerror()
                return 1
            End
        End

        otherwise Do
            /*
             * write the line out to the new config file
             */

            result=lineout(newconfig, inline)
            If result=1 Then Do
                writeerror()
                return 1
            End
        End

    End  /* select */

End /* Do */

/*********************/
/* close the files   */
/*********************/

result=lineout(newconfig)
result=lineout(oldconfig)

/********************************************************************/
/* Copy created file(CONFIG.IW) to temporary file(IWTMP.SYS),       */
/* copy original file(CONFIG.SYS) to new file(CONFIG.IW),           */
/* and copy temporary file(IWTMP.SYS) to original file(CONFIG.SYS). */
/********************************************************************/

'@copy 'oldconfig' 'tmpconfig' 2>nul >nul'

'@copy 'newconfig' 'oldconfig' 2>nul >nul'

'@copy 'tmpconfig' 'newconfig' 2>nul >nul'

'@del 'tmpconfig' 2>nul >nul'

/******************************************************************/
/*  Finished the Update                                           */
/******************************************************************/

Say ' '
Say '               'bootdrive'\CONFIG.SYS successfully updated.'
Say ' '

return 0


