/*********************************************************************
 *                                                                   *
 * MODULE NAME :  drgthrnd.h             AUTHOR:  Rick Fishman       *
 * DATE WRITTEN:  07-15-93                                           *
 *                                                                   *
 * DESCRIPTION:                                                      *
 *                                                                   *
 *  Common definitions and function prototypes for DRGTHRND.EXE      *
 *                                                                   *
 * HISTORY:                                                          *
 *                                                                   *
 *  07-15-93 - Coding started.                                       *
 *                                                                   *
 *  Rick Fishman                                                     *
 *  Code Blazers, Inc.                                               *
 *  4113 Apricot                                                     *
 *  Irvine, CA. 92720                                                *
 *  CIS ID: 72251,750                                                *
 *                                                                   *
 *********************************************************************/

/*********************************************************************/
/*------------------- APPLICATION DEFINITIONS -----------------------*/
/*********************************************************************/

#define ID_DRAGCNR             1
#define ID_DROPCNR             2

#define INSTDATA(hwnd) ((PINSTANCE)WinQueryWindowPtr( hwnd, QWL_USER ))
#define ANCHOR(hwnd)   (WinQueryAnchorBlock( hwnd ))
#define HWNDERR(hwnd)  (ERRORIDERROR(WinGetLastError( ANCHOR( hwnd ))))
#define HABERR(hab)    (ERRORIDERROR(WinGetLastError( hab )))

#define DEBUG_FILENAME        "drgthrnd.dbg"

#define BASE_TEMPFILE_NAME    "TEMP"

#define DRAG_RMF  "<DRM_FISHMAN,DRF_UNKNOWN>" // Rendering Mechanism/Format

#define UM_WINDOW_CREATED     WM_USER
#define UM_DO_THE_RENDERING   WM_USER + 1
#define UM_DO_THE_DROP        WM_USER + 2

#define RECATTR_DRAGGABLE     0x00000001
#define RECATTR_OPENABLE      0x00000002

#ifndef CRA_SOURCE            // As of 07/30/93, CRA_SOURCE not in toolkit hdrs
#  define CRA_SOURCE          0x00004000L
#endif

#define IDM_EXIT              100

/**********************************************************************/
/*---------------------------- STRUCTURES ----------------------------*/
/**********************************************************************/

typedef struct _CNRREC               // Container record structure
{
  MINIRECORDCORE mrc;
  ULONG          flAttr;
  char           szTableName[ 100 ];
  char           szRenderedFileName[ CCHMAXPATH ];
  HWND           hwndDisplay;
} CNRREC, *PCNRREC;

#define EXTRA_BYTES (sizeof( CNRREC ) - sizeof( MINIRECORDCORE ))

typedef struct _ENUMSTRUCT
{
  HDIR hdir;
  FILE *stream;
  char szFileName[ CCHMAXPATH ];
} ENUMSTRUCT, *HENUMTABLES;

typedef struct _INSTANCE
{
  PDRAGINFO pSavedDragInfo;
  int       cDragItems;
  HWND      hwndRender;
} INSTANCE, *PINSTANCE;

/**********************************************************************/
/*----------------------- FUNCTION PROTOTYPES ------------------------*/
/**********************************************************************/

// In drag.c

MRESULT dragMessage( HWND hwndFrame, ULONG msg, MPARAM mp1 );
void    dragInit( HWND hwndFrame, PCNRDRAGINIT pcdi );
MRESULT dragOver( HWND hwndFrame, PCNRDRAGINFO pcdi );
void    dragDrop( HWND hwndFrame, PCNRDRAGINFO pcdi );
void    dragTargetCleanup( HWND hwndFrame );
void    dragSourceCleanup( HWND hwndFrame );

// In drgthrnd.c

void Msg( PSZ szFormat, ... );

// In dbaccess.c

HENUMTABLES dbBeginEnumTables( void );
BOOL        dbGetNextTable( HENUMTABLES henum, PSZ szBuffer, INT cbBuf );
void        dbEndEnumTables( HENUMTABLES henum );
BOOL        dbRenderToFile( PSZ pszTableName, PSZ pszFileName );

// In srcrendr.c

MRESULT srcRenderPrepare( HWND hwndFrame, PDRAGTRANSFER pDragXfer );
HWND    srcCreateWindow( HWND hwndFrame );

// In trgrendr.c

HWND targCreateWindow( HWND hwndFrame );

/**********************************************************************/
/*------------------------ GLOBAL VARIABLES --------------------------*/
/**********************************************************************/

#ifdef GLOBALS_DEFINED
#   define DATADEF
#else
#   define DATADEF extern
#endif

DATADEF char szCurrentPath[ CCHMAXPATH ];

DATADEF HPOINTER hptrDragMe;
DATADEF HPOINTER hptrOpenMe;

/***************************************************************************
 *                         E N D   O F   S O U R C E                       *
 ***************************************************************************/
