

!ifndef %YACLPATH
!error Please define the environment variable YACLPATH.
!endif



!include $(%YACLPATH)\control\watcomc.ctl



FLAGS = YACLPLATFORM=$(YACLPLATFORM)

!ifdef DEBUG
FLAGS = YACLPLATFORM=$(YACLPLATFORM) DEBUG=1
!endif


!ifdef DOS
# No UI stuff under DOS
yacl:  libdir base io .SYMBOLIC
!else
yacl:  libdir base io ui .SYMBOLIC
!endif

libdir: .SYMBOLIC
	-md $(YACLPATH)\lib
	-md $(YACLPATH)\lib\$(YACLPLATFORM)

base: .SYMBOLIC
	cd base
	-$(MAKE) /f watcomc.mak $(FLAGS)
	-cd ..

io:  .SYMBOLIC
        cd io
	-$(MAKE) /f watcomc.mak $(FLAGS)
        -cd ..


ui:   .SYMBOLIC
	cd ui
	-$(MAKE) /f watcomc.mak $(FLAGS)
        -cd ..



# -------------------- Targets below are for my use only ---------------

    
basedemo:  .SYMBOLIC
    cd basedemo
    $(MAKE) /f watcomc.mak
    cd ..

uidemos:  .SYMBOLIC
    cd uidemo
    $(MAKE) /f watcomc.mak
    cd ..

apps: .SYMBOLIC
    cd apps\bmpview
    $(MAKE) -f watcomc.mak
    cd ..\dlged
    $(MAKE) -f watcomc.mak
    cd ..\..
    
    


everything: yacl basedemo uidemos apps .SYMBOLIC



clean:  .SYMBOLIC
	cd base
	-$(MAKE) /f watcomc.mak clean
	cd ..\io
	-$(MAKE) /f watcomc.mak clean
	cd ..\ui
	-$(MAKE) /f watcomc.mak clean
	cd ..
	cd basedemo
	-rm -f */*.obj */*.exe */*.map
	cd ..\uidemo
	wmake -f watcomc.mak clean
	cd $(YACLLIB)
	-del base.*
	-del io.*
	-del ui.*
	-del memory.*
	-del *.bak
	cd ..\..






