

// A window demo using YACL


#include "ui/composit.h"
#include "ui/applic.h"
#include "ui/label.h"
#include "ui/pushbtn.h"
#include "ui/stddlg.h"


// ======================== Class AppWindow ===========================


#define ID_LABEL1 11
#define ID_LABEL2 12
#define ID_LABEL3 13
#define ID_LABEL4 14
#define ID_LABEL5 15
#define ID_BUTTON 16


UI_ViewDescriptor desc[] = {
    {View_Label,      ID_LABEL1, 15,  15, 320, 20, FALSE,  ""},
    {View_Label,      ID_LABEL2, 15,  40, 320, 20, FALSE,  ""},
    {View_Label,      ID_LABEL3, 15,  65, 320, 20, FALSE,  ""},
    {View_Label,      ID_LABEL4, 15,  90, 320, 20, FALSE,  ""},
    {View_Label,      ID_LABEL5, 15, 120, 320, 20, FALSE,  ""},
    {View_PushButton, ID_BUTTON,125, 170,  80, 40, FALSE,  ""},
    {View_None, 0}
};

class AppWindow: public UI_CompositeVObject {

public:
    AppWindow ();

protected:

    void Initialize  ();

    bool Iconify ();

    bool Deiconify ();
    
    bool Reconfigure (const UI_Rectangle& r);

    bool HandleChildEvent (const UI_Event& e);

private:
    void SetLabels ();
    long _xInc, _yInc;
    short _count;
};

    
AppWindow::AppWindow()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (200, 200, 350, 230))
{
    _xInc = _yInc = 32;
    _title = "YACL Window Demo";
    (*this)[ID_LABEL1]->Title() = "I am a window.";
    (*this)[ID_BUTTON]->Title() = "Move!";
    _count = 0;
}

void AppWindow::Initialize ()
{
    SetLabels ();
}



bool AppWindow::Reconfigure (const UI_Rectangle& r)
{
    UI_CompositeVObject::Reconfigure (r);
    SetLabels();
    return TRUE;
}

void AppWindow::SetLabels ()
{
    UI_Rectangle r = Shape();
    (*this)[ID_LABEL2]->Title() =
        "My client area is at (" + CL_String (r.Left())
        + ", " + CL_String (r.Top()) + ").";
    (*this)[ID_LABEL3]->Title() =
        "My client area size is " + CL_String (r.Width ())
        + " x " + CL_String (r.Height ()) + ".";
    UI_Rectangle rect = WindowShape ();
    (*this)[ID_LABEL4]->Title() =
        "My window area size is " + CL_String (rect.Width ())
        + " x " + CL_String (rect.Height ()) + ".";
    (*this)[ID_LABEL5]->Title() = "I had been iconified " + CL_String
        (_count) + " times.";
}



bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin()->ViewID() != ID_BUTTON || e.Type() != Event_Select)
        return FALSE;

    UI_Rectangle screen_rect = _Application->ScreenRect();
    UI_Rectangle& client_area = Shape();
    long x = client_area.Origin().XCoord();
    long y = client_area.Origin().YCoord();
    if (x >= screen_rect.Width() - client_area.Width() || x < 0)
        _xInc = -_xInc;
    if (y >= screen_rect.Height() - client_area.Height() || y <= 20)
        _yInc = -_yInc;
    client_area += UI_Point (_xInc, _yInc); // Move the window
    return TRUE;
}

bool AppWindow::Iconify ()
{
    _count++;
    return TRUE;
}


bool AppWindow::Deiconify ()
{
    (*this)[ID_LABEL5]->Title() = "I have been iconified " + CL_String
        (_count) + " times.";
    return TRUE;
}



// ======================== Main program ===========================


int UI_Application::Main (int, char* []) 
{
    MakeTopWindow (new AppWindow);
    Run();
    return 0;
}


