
#include "appwin.h"
#include "ui/cntroler.h"
#include "ui/dialog.h"
#include "ui/pushbtn.h"
#include "ui/stddlg.h"

#include <fstream.h>

#define ID_LABEL   10
#define ID_BUTTON1 11
#define ID_BUTTON2 12
#define ID_BUTTON3 13
#define ID_BUTTON4 14
#define ID_BUTTON5 15



UI_ViewDescriptor desc[] = {
    {View_PushButton, ID_BUTTON1,  50,  15, 200, 40, TRUE, ""},
    {View_PushButton, ID_BUTTON2,  50,  75, 200, 40, TRUE, ""},
    {View_PushButton, ID_BUTTON3,  50, 135, 200, 40, TRUE, ""},
    {View_PushButton, ID_BUTTON4,  50, 195, 200, 40, TRUE, ""},
    {View_PushButton, ID_BUTTON5,  50, 245, 200, 40, TRUE, ""},
    {View_Label,      ID_LABEL,    50, 285, 200, 40, TRUE, ""},
    {View_None, 0}
};
    
AppWindow::AppWindow()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (50, 50, 300, 350))
{
    (*this)[ID_BUTTON1]->Title() = "Information";
    (*this)[ID_BUTTON2]->Title() = "Warning";
    (*this)[ID_BUTTON3]->Title() = "Error";
    (*this)[ID_BUTTON4]->Title() = "Confirm";
    (*this)[ID_BUTTON5]->Title() = "Select file";
    _title                       = "YACL Standard Dialogs Demo";
}


bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    UI_ViewID btn_id = e.Origin()->ViewID();
    if (btn_id == ID_BUTTON5) {
        CL_String initialDir = _Application->Environment()["YACLPATH"];
        CL_String s = UI_FileSelectDialog (this, initialDir,
                                           "Choose a file");
        UI_StandardDialog (CL_String ("File name: ") + s);
        return TRUE;
    }
    (*this)[ID_LABEL]->Title() = "";
    char* msg;
    UI_StandardDialogStyle style;
    UI_StandardDialogIconStyle icon;
    switch (btn_id) {
    case ID_BUTTON1:
        style = UIS_Ok;
        icon  = UIS_Information;
        msg   = "Hello from YACL.";
        break;

    case ID_BUTTON2:
        icon  = UIS_Warning;
        style = UIS_YesNo;
        msg   = "Format the hard drive?";
        break;
        
    case ID_BUTTON3:
        icon  = UIS_Error;
        style = UIS_OkCancel;
        msg   = "Remove the home directory?";
        break;
        
    case ID_BUTTON4:
        icon  = UIS_Question;
        style = UIS_YesNoCancel;
        msg   = "Rename the file?";
        break;

    };

    UI_ViewID id = UI_StandardDialog (msg, e.Origin()->Title(), this,
                                      style, icon);
    char* btnName = "";
    switch (id) {
    case UI_IDOK:
        btnName = "'Ok'";
        break;
        
    case UI_IDCANCEL:
        btnName = "'Cancel'";
        break;
        
    case UI_IDYES:
        btnName = "'Yes'";
        break;
        
    case UI_IDNO:
        btnName = "'No'";
        break;
    };
        
    (*this)[ID_LABEL]->Title() = "Returned " + CL_String (btnName);
    return TRUE;
}




