
#include "appwin.h"
#include "ui/cntroler.h"

#define ID_BAR    10
#define ID_LABEL  11
#define ID_BTN    12

typedef CL_Binding0<AppWindow> Bind;

#if defined(__GNUC__)
template class CL_Binding0<AppWindow>;
#endif

AppWindow::AppWindow()
: UI_Dialog (NULL, NULL, UI_Rectangle (100, 100, 270, 260))
{
    _btn   = new UI_ToggleButton (this, UI_Rectangle (10, 10, 150, 25),
                                  ID_BTN);
    _msg   = new UI_Label (this, UI_Rectangle (10, 90, 120, 20), ID_LABEL);
    _bar   = new UI_VScrollBar (this, UI_Rectangle (150, 35, 16, 180), ID_BAR);
    _bar->Range() = CL_Interval (0, 255);
    Bind bind (this, &AppWindow::_DoScroll);
    _bar->ClientSet().Add (bind);
    CL_Interval init (26, 50); // Initial setting
    _bar->Model() = init;
    _msg->Model() = init.AsString();
    _btn->Model() = CL_Integer ((short) TRUE);
    _btn->Title() = "Smooth scroll";
}

bool AppWindow::_DoScroll ()
{
    CL_String& s = (CL_String&) _msg->Model();
    s = _bar->Model().AsString();
    _Controller->GiveFocusTo (_bar);
    return TRUE;
}


bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin()->ViewID() !=  ID_BTN || e.Type() != Event_Select)
        return FALSE;
    CL_Integer& v = (CL_Integer&) (e.Origin()->Model());
    _bar->SmoothScroll() = v.Value();
    return TRUE;
}
