



!include $(%YACLPATH)/control/watcomc.ctl

APPNAME = resource
OBJECTS = main.obj menudrv.obj
RESFILE = $(YACLPLATFORM).res



!ifdef __OS2__
WTCLIB  = $(WTCPATH)\lib386\os2;$(WTCPATH)\lib386
SYSLIBS = os2386,  plib3r, clib3r
SYSTEM  = os2v2_pm
!else ifdef __NT__
WTCLIB  = $(WTCPATH)\lib386\nt;$(WTCPATH)\lib386
SYSLIBS = ctl3d32, plib3r, clib3r
SYSTEM  = nt_win
!else
WTCLIB  = $(WTCPATH)\lib286\win;$(WTCPATH)\lib286
# Note: Watcom seems very sensitive to the ordering of these libraries!
SYSLIBS = plibl, clibl, ctl3d, commdlg
SYSTEM  = windows
!endif



$(APPNAME): $(OBJECTS) $(RESFILE) tmp.lnk $(UILIB) $(WINBASELIB) .SYMBOLIC
  wlink @tmp.lnk
!ifeq YACLPLATFORM WINDOWS
  $(RC) $(RCFLAGS) $(YACLPLATFORM).RES $(APPNAME).EXE
!else ifeq YACLPLATFORM WIN32
  $(RC) $(RCFLAGS) $(YACLPLATFORM).RES $(APPNAME).EXE
!endif
  -del tmp.lnk

tmp.lnk : $(__MAKEFILES__)
    %create $^@
    @%append $^@ system $(SYSTEM)
    @%append $^@ option eliminate
    @%append $^@ LIBPATH $(YACLLIB);$(WTCLIB)
!ifdef MAKE_MAPFILE
    @%append $^@ option MAP
!endif
!ifdef DEBUG
    @%append $^@ debug all
!endif
!ifdef __OS2__
    @%append $^@ file $(YACLPATH)\ui\mainprog.obj
!else ifdef __NT__
    @%append $^@ file $(YACLPATH)\ui\mainprog.obj
!endif
    @for %i in ( $(OBJECTS) ) do @%append $^@ file %i
    @%append $^@ library $(UI), $(IO), $(BASE), $(MEMORY), $(SYSLIBS)
    @%append $^@ NAME $(APPNAME).exe
!ifdef __OS2__
    @%append $^@ option modname=$(APPNAME)
    @%append $^@ option manyautodata
    @%append $^@ option stack=64000
    @%append $^@ option heapsize=64000
    @%append $^@ option protmode
!else ifdef __NT__
    @%append $^@ option stack=64000
# Now this is a stupid hack to get the Watcom linker to recognize the CTL3D
# functions under NT:
    @%append $^@ ALIAS _Ctl3dRegister=Ctl3dRegister
    @%append $^@ ALIAS _Ctl3dUnregister=Ctl3dUnregister
    @%append $^@ ALIAS _Ctl3dAutoSubclass=Ctl3dAutoSubclass
    @%append $^@ ALIAS _Ctl3dDlgFramePaint=Ctl3dDlgFramePaint
    @%append $^@ ALIAS _Ctl3dCtlColorEx=Ctl3dCtlColorEx
    @%append $^@ ALIAS _Ctl3dSubclassCtl=Ctl3dSubclassCtl
    @%append $^@ ALIAS _Ctl3dSubclassDlgEx=Ctl3dSubclassDlgEx
!endif




.cxx.obj:
	$(CC) $(CCOPTS) $*.cxx

clean: .SYMBOLIC
    -del *.obj
    -del *.map
    -del *.exe
    -del tmp.lnk


!ifeq YACLPLATFORM WINDOWS
$(YACLPLATFORM).res: $(YACLPLATFORM).rc
    $(RC) -r $(INCPATH) $(HDRPATH) $(YACLPLATFORM).rc
!else ifeq YACLPLATFORM WIN32
$(YACLPLATFORM).res: $(YACLPLATFORM).rc
    $(RC) -r $(INCPATH) $(HDRPATH) $(YACLPLATFORM).rc
!endif

