

#include "appwin.h"
#include "ids.h"

#include "ui/composit.h"
#include "ui/applic.h"
#include "ui/stddlg.h"
#include "ui/label.h"
#include "ui/menu.h"
#include "ui/font.h"



// ---------------------- The main menu descriptors ------------------

UI_MenuItemDescriptor App1Submenu [] = {
  {"A one",     ID_SUBMENU1, NULL}
, {"A two",     ID_SUBMENU2, NULL}
, {NULL,        0, NULL}
};

UI_MenuItemDescriptor App1Menu [] = {
  {"&Jan",      ID_JAN,    NULL}
, {"&Feb",      ID_FEB,    NULL}
, {"&Mar",      ID_MAR,    App1Submenu}
, {"---",       NULL,      NULL} // Separator
, {"&Apr",      ID_APR,    NULL}
, {"Ma&y",      ID_MAY,    NULL}
, {NULL,        0,         NULL}
};

UI_MenuItemDescriptor App2Menu [] = {
  {"Monday",      ID_MON,  NULL}
, {"Tuesday",     ID_TUE,  NULL}
, {"Wednesday",   ID_WED,  NULL}
, {0,             0,   NULL}
};


UI_MenuItemDescriptor MainMenuDesc [] = {
    {"&One",   ID_APP1, App1Menu}
  , {"&Two",   ID_APP2, App2Menu}
  , {NULL,     0, NULL}
};



// --------------------  The popup menu descriptors ------------------

UI_MenuItemDescriptor PopupSubmenu [] = {
  {"Sub1",     ID_POPUP_SUBMENU1, NULL}
, {"Sub2",     ID_POPUP_SUBMENU2, NULL}
, {NULL,       0, NULL}
};

UI_MenuItemDescriptor PopupMenuDesc [] = {
    {"&Add",    ID_ADD,    PopupSubmenu}
  , {"&Remove", ID_REMOVE, NULL}
  , {NULL,      0,         NULL}
};


typedef UI_EventBinding2<AppWindow> AppBind;
typedef UI_EventBinding0<AppWindow> AppBind0;

#if defined(__GNUC__)
template class UI_EventBinding2<AppWindow>;
template class UI_EventBinding0<AppWindow>;
#endif




UI_ViewID   PopupIds[] = {
    ID_POPUP_SUBMENU1, ID_POPUP_SUBMENU2, ID_ADD, ID_REMOVE, 0
};

UI_ViewID MenuBarIds [] = {
ID_APP1, ID_APP2, ID_SUBMENU1, ID_SUBMENU2, ID_JAN, ID_FEB, ID_MAR,
ID_APR, ID_MAY, ID_MON, ID_TUE, ID_WED, 0
};

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (100, 100, 350, 200))
{
    Title() = "YACL Popup Menu Demo";
    UI_MenuBar*     mainMenu =  new UI_MenuBar (this, MainMenuDesc);
    _driver.Setup (mainMenu);

    _popupMenu = new UI_PopupMenu (this, PopupMenuDesc);
    AppBind bind1 (this, &AppWindow::Selected, ID_ADD);
    (*_popupMenu)[ID_ADD]->AddEventDependent (Event_Select, bind1);
    AppBind bind2 (this, &AppWindow::Selected, ID_REMOVE);
    (*_popupMenu)[ID_REMOVE]->AddEventDependent (Event_Select, bind2);
    _lbl = new UI_Label (this, UI_Rectangle (5, 130, 290, 30));
    _lbl->Title() = "Right mouse btn gives popup menu";

    short i;
    for (i = 0; PopupIds[i] != 0; i++) {
        UI_ViewID id = PopupIds[i];
        (*_popupMenu)[id]->AddEventDependent
            (Event_GetFocus,  AppBind (this, &AppWindow::Help, id));
        (*_popupMenu)[id]->AddEventDependent
            (Event_LoseFocus, AppBind (this, &AppWindow::ClearHelp, id));
    }

    for (i = 0; MenuBarIds[i] != 0; i++) {
        UI_ViewID id = MenuBarIds[i];
        (*mainMenu)[id]->AddEventDependent
            (Event_GetFocus,  AppBind (this, &AppWindow::Help, id));
        (*mainMenu)[id]->AddEventDependent
            (Event_LoseFocus, AppBind (this, &AppWindow::ClearHelp, id));
    }
}


bool AppWindow::Selected (UI_Event&, long id)
{
    UI_StandardDialog (CL_String ("Selected: ") + CL_String (id));
    return TRUE;
}


bool AppWindow::Help     (UI_Event& e, long)
{
    CL_String s = e.Origin()->Title();
    s.Replace ("&", "");
    _lbl->Title() = "'" + s + "' has focus";
    _focusId = e.Origin()->ViewID();
    return TRUE;
}

bool AppWindow::ClearHelp (UI_Event& e, long)
{
    if (e.Origin()->ViewID() == _focusId)
        _lbl->Title() = "Right mouse btn gives popup menu";
    return TRUE;
}

bool AppWindow::ButtonDown (const UI_Point& curPos, UI_MouseButton btn,
                            bool, bool)
{
    if (btn == UIM_Right || btn == UIM_Middle)
        _popupMenu->ShowAt (curPos);
    return FALSE;
}

