

#include "menudrv.h"
#include "ids.h"
#include "ui/applic.h"


typedef UI_EventBinding0<MenuDriver> Bind;

#if defined(__GNUC__)
template class UI_EventBinding0<MenuDriver>;
#endif

MenuDriver::MenuDriver (UI_MenuBar* bar)
{
    _menu = bar;
    (*bar)[ID_QUIT]->AddEventDependent
        (Event_Select, Bind (this, &MenuDriver::Quit));
    (*bar)[ID_TILE]->AddEventDependent
        (Event_Select, Bind (this, &MenuDriver::Tile));
    (*bar)[ID_CASC]->AddEventDependent
        (Event_Select, Bind (this, &MenuDriver::Cascade));
    (*bar)[ID_ARR ]->AddEventDependent
        (Event_Select, Bind (this, &MenuDriver::Arrange));
    (*bar)[ID_NEW ]->AddEventDependent
        (Event_Select, Bind (this, &MenuDriver::NewWindow));
    _count = 0;
}


bool MenuDriver::Tile ()
{
    UI_MDIMainWindow* w =  (UI_MDIMainWindow*) _menu->Parent();
    w->TileChildren();
    return TRUE;
}

bool MenuDriver::Cascade ()
{
    UI_MDIMainWindow* w =  (UI_MDIMainWindow*) _menu->Parent();
    w->CascadeChildren();
    return TRUE;
}

bool MenuDriver::Arrange ()
{
    UI_MDIMainWindow* w =  (UI_MDIMainWindow*) _menu->Parent();
    w->ArrangeChildIcons();
    return TRUE;
}


bool MenuDriver::NewWindow ()
{
    UI_MDIMainWindow* w =  (UI_MDIMainWindow*) _menu->Parent();
    UI_ViewID id = _count + 1000;
    (new UI_MDIChild (w, UI_Rectangle (0, 0, 200, 100), id))->Title() =
        "Child #" + CL_String (++_count);
    return TRUE;
}

    

bool MenuDriver::Quit ()
{
    YACLApp()->End();
    return TRUE;
}
