
// ------------------------------ appwin.cxx -----------------------------

#include "ui/orbtngrp.h"
#include "ui/strseq.h"
#include "ui/strview.h"
#include "ui/xrbtngrp.h"
#include "ui/pushbtn.h"
#include "ui/label.h"
#include "ui/stred.h"
#include "ui/dialog.h"
#include "ui/applic.h"
#include "ui/interval.h"


#include "appwin.h"
#include "dlgs.h"
#include "subdlg.h"

UI_ViewDescriptor MainGroup [] = {
{View_ExOrToggleButton, ID_BASE,   10,  25, 120, 24, TRUE, "Cars", NULL},
{View_ExOrToggleButton, ID_BASE+1, 10,  55, 120, 24, TRUE, "Coffee", NULL},
{View_ExOrToggleButton, ID_BASE+2, 10,  85, 120, 24, TRUE, "Sandwiches", NULL},
{View_None, 0, 0}                                         
};                                                        
                                                          
UI_ViewDescriptor MainDesc [] = {                         
{View_ExOrButtonGroup,  ID_CHOICES, 10, 20,  140, 140, FALSE, "Choice",
     MainGroup},
{View_None, 0, 0}
};

extern UI_ViewDescriptor DLG_CarOptions_Item[];
extern UI_ViewDescriptor DLG_Sandwich_Item[];
extern UI_ViewDescriptor DLG_Coffee_Item[];

UI_ViewDescriptor* AllDialogs[] = {
     DLG_CarOptions_Item,
     DLG_Coffee_Item,
     DLG_Sandwich_Item,
     0
};


static char* fixings[] = {
  "Lettuce",      "Tomatoes",     "Onions",          "Cream cheese",
  "Black olives", "Pimentos",     "Alfalfa sprouts", "Cucumber",
  "Mushrooms",    "Green olives", "Jalapenos",
  0
};

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, MainDesc, FALSE, UI_Rectangle (50, 50, 650, 300))
{
    _current = NULL;
    short i;
    for (i = 0; AllDialogs[i] != 0; i++) {
        _comp[i] = new SubDialog (this, AllDialogs[i], UI_Point (150, 10));
        _comp[i]->MakeInvisible();
    }
    UI_StringView* l = (UI_StringView*) (*this)[ID_FIXINGS_LIST];
    UI_StringSequence& s = (UI_StringSequence&) l->Model();
    for (i = 0; fixings[i] != 0; i++)
        s.Add (fixings[i]);
}

void AppWindow::Initialize ()
{
    _title = "Dynamic Dialog Demo";
}

void AppWindow::ShowDialog (short index)
{
    if (index < 0 || index > 2)
        return; // Should never happen
    if (_current == _comp[index])
        return; // Same as what's being shown
    if (_current)
        _current->MakeInvisible();
    _current = _comp[index];
    _current->MakeVisible();
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    UI_ExOrButtonGroup* grp =  (UI_ExOrButtonGroup*) (*this)[ID_CHOICES];
    if (e.Origin() == grp) 
        ShowDialog (grp->Selection().Value() - ID_BASE);
    // Take advantage of the fact that view id's of the buttons are
    // consecutive beginning at ID_BASE.
    return TRUE;
}
