
// --------------------------- evtproc.cxx -------------------------------

#include "ui/evtbind.h"
#include "ui/strseq.h"
#include "ui/strview.h"
#include "ui/applic.h"

#include "evtproc.h"
#include "ids.h"

#if defined(__GNUC__)
template class UI_EventBinding1<EventProcessor>; // Instantiate the template
#endif

typedef UI_EventBinding1<EventProcessor> Bind;

const char* data[] = {
    "newdata",     "database.sdf",    "reports.dat",    "memo1.doc",
    "memo2.doc",   "sales.xls",       "proposal.tex",   "secret.rpt",
    "eastern.xls", "western.xls",     "odyssey.prj",    "data.vis",
    "hiring.doc",  "asia.pic",        "mickey.gif",     "einstein.jpg",
    "gcc-2.7.2.tar.gz", 0
};

EventProcessor::EventProcessor (UI_Dialog& root)
{
    UI_StringSequence& seq = (UI_StringSequence&) root[ID_LEFT]->Model();
    for (short i = 0; data[i] != 0; i++)
        seq.Add (data[i]);
    root[ID_R_TO_L]->Disable();
    Bind b (this, &EventProcessor::HandleSelectEvent);
    root.AddEventDependent (Event_Select, b);
}


static void MoveData (UI_StringViewMultiSel* from, UI_StringViewMultiSel* to)
{
    CL_IntegerSet& s = from->Selection ();
    UI_StringSequence& fromSeq = (UI_StringSequence&) from->Model();
    UI_StringSequence& toSeq   = (UI_StringSequence&) to  ->Model();
    fromSeq.Move (s, toSeq);
}

bool EventProcessor::HandleSelectEvent (UI_Event& e)
{
    UI_ViewID id = e.Origin()->ViewID();
    if (id == ID_DONE)
        YACLApp()->End();
    if (id != ID_L_TO_R && id != ID_R_TO_L)
        return FALSE;
    UI_Dialog& dlg = *(UI_Dialog*) e.Destination();
    UI_StringViewMultiSel* lbox = (UI_StringViewMultiSel*) dlg[ID_LEFT];
    UI_StringViewMultiSel* rbox = (UI_StringViewMultiSel*) dlg[ID_RIGHT];
    if (id == ID_L_TO_R)
        MoveData (lbox, rbox);
    else
        MoveData (rbox, lbox);
    long lSize = ((UI_StringSequence&) lbox->Model()).Size();
    long rSize = ((UI_StringSequence&) rbox->Model()).Size();
    dlg[ID_L_TO_R]->SetEnabledState (lSize > 0);
    dlg[ID_R_TO_L]->SetEnabledState (rSize > 0);
    return TRUE;
}
