
// A demo of cursor changes using YACL
//
// M. A. Sridhar
// April 3, 1994

#include "ui/composit.h"
#include "ui/applic.h"
#include "ui/pushbtn.h"
#include "ui/cursor.h"

int UI_Application::Main (int, char*[])
{
    // This program demonstrates that, under MS-Windows, message objects
    // (i.e., "static" objects) will not be sent mouse move events!
    UI_CompositeVObject* root = new UI_CompositeVObject
        (NULL, NULL, FALSE, UI_Rectangle (50, 50, 230, 400));
    MakeTopWindow (root);
    root->Title () = "YACL Cursor demo";
    
    UI_PushButton* m1 = new UI_PushButton
        (root, UI_Rectangle (10, 10, 200, 50));
    (m1->Model()) = CL_String ("I use an i-beam cursor");
    m1->Cursor() = UICursor_IBeam;
    
    UI_PushButton* m2 = new UI_PushButton
        (root, UI_Rectangle (10, 100, 200, 50));
    (m2->Model()) = CL_String ("I use a wait cursor");
    m2->Cursor() = UICursor_Wait;
    
    UI_PushButton* m3 = new UI_PushButton
        (root, UI_Rectangle (10, 200, 200, 50));
    (m3->Model()) = CL_String ("I use a cross-hair cursor");
    m3->Cursor() = UICursor_CrossHairs;
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_PushButton* m4 = new UI_PushButton
        (root, UI_Rectangle (10, 300, 200, 50));
    (m4->Model()) = CL_String ("I use a custom cursor");
    m4->Cursor() = "SampleCursor";
#endif
    
    Run();
    return 0;
}


