
#include "appwin.h"
#include "ui/stddlg.h"
#include "ui/applic.h"



enum {
    ID_BUTTON0 = 10,
    ID_BUTTON1,
    ID_LABEL0,
    ID_LABEL1,
    ID_BOX0,
    ID_BOX1
};



static void AddModelStrings (UI_ComboBox* box)
{
    UI_StringSequence& model = (UI_StringSequence&) box->Model();
    model.Add ("Word for Windows");
    model.Add ("WordPerfect");
    model.Add ("Freelance");
    model.Add ("PowerPoint");
    model.Add ("CorelDraw!");
    model.Add ("PC Anywhere");
    model.Add ("Carbon Copy");
    model.Add ("Paradox");
    model.Add ("Eudora");
    model.Add ("Pegasus Mail");
}


AppWindow::AppWindow()
: UI_Dialog (NULL, NULL, UI_Rectangle (40, 40, 510, 200))
{
    _btn0  = new UI_PushButton (this, UI_Rectangle (240, 150, 130, 30),
                                ID_BUTTON0);
//     _btn1  = new UI_PushButton (this, UI_Rectangle (245, 150, 130, 30),
//                                 ID_BUTTON1);
    _lbl0  = new UI_Label    (this, UI_Rectangle (15, 50, 235, 20),
                              ID_LABEL0);
    _lbl1  = new UI_Label    (this, UI_Rectangle (260, 50, 235, 20),
                              ID_LABEL1);
    _box0  = new UI_ComboBox (this, UI_Rectangle (15, 90, 235, 40), ID_BOX0,
                              100, FALSE);
    _box1  = new UI_ComboBox (this, UI_Rectangle (260, 90, 235, 40), ID_BOX1,
                              100, TRUE);

    AddModelStrings (_box0);
    AddModelStrings (_box1);
    _btn0->Title() = "Select next";
//    _btn1->Title() = "Select next";
    _title = "YACL ComboBox Demo";
    _box0->Selection () = 3; // Select PowerPoint
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    switch (e.Origin()->ViewID()) {
    case ID_BUTTON0: {
        {
        CL_Integer& sel0 = _box0->Selection();
        UI_StringSequence& model = (UI_StringSequence&) _box0->Model();
        sel0 = (sel0 + 1) % (model.Size());

        CL_Integer& sel1 = _box1->Selection();
        UI_StringSequence& model1 = (UI_StringSequence&) _box1->Model();
        sel1 = (sel1 + 1) % (model1.Size());
        // No break: Fall through....
        }
        
    case ID_BOX0:
    case ID_BOX1:
        _lbl0->Title() = "Selection: '" + _box0->EditString() + "'";
        _lbl1->Title() = "Selection: '" + _box1->EditString() + "'";
        break;

    }

    default:
        break;
    }
    return FALSE;
}


