

// A simple digital clock program using YACL

#include "ui/dialog.h"
#include "ui/timer.h"
#include "ui/cntroler.h"
#include "ui/label.h"
#include "base/date.h"
#include "base/timeofda.h"


// The main window:

class ClockWindow: public UI_Dialog {
public:
    ClockWindow ();

    bool Update ();

protected:
    void Initialize ();

    UI_Label*                _date;
    UI_Label*                _time;
    CL_Binding0<ClockWindow> _bind;
    UI_Timer                 _timer;
};



typedef CL_Binding0 <ClockWindow> Bind;

#if defined(__GNUC__)
template class CL_Binding0 <ClockWindow>; // Instantiate the template
#endif


ClockWindow::ClockWindow ()
: UI_Dialog (NULL, NULL, UI_Rectangle (300, 300, 140, 80)),
  _bind  (this, &ClockWindow::Update),
  _timer (_bind)
{
    _date = new UI_Label (this, UI_Rectangle (20,  5, 100, 30));
    _time = new UI_Label (this, UI_Rectangle (20, 40, 100, 30));
}

void ClockWindow::Initialize()
{
    _date->Title() = CL_Date::Today().AsString();
    _time->Title() = CL_TimeOfDay::Now().AsString();
    _timer.Start (1000); // Call Update every 1000 millseconds
}

bool ClockWindow::Update ()
{
    CL_TimeOfDay now = CL_TimeOfDay::Now();
    if (now == CL_TimeOfDay (0, 0, 1))
        _date->Title() = CL_Date::Today().AsString();
    _time->Title() = now.AsString();
    _Controller->DispatchPendingEvents (); // Flush the event queue so that
                                           // the update shows on the screen
    return TRUE;
}



// The main program:

int UI_Application::Main (int, char* [])
{
    UI_CompositeVObject* root = new ClockWindow;
    MakeTopWindow (root);
    root->Title()  = "YACL clock";
    Run();
    return 0;
}

