

// A small calendar program using YACL
//
// M. A. Sridhar
// Dec 25, 1993

#include "ui/monthcal.h"
#include "ui/dialog.h"
#include "ui/stddlg.h"
#include "ui/pushbtn.h"
#include "ui/applic.h"
#include "ui/font.h"


// ======================== Class AppWindow ===========================

enum {
    ID_NEXT = 10,
    ID_PREV = 11,
    ID_CAL  = 12,
    ID_MAIN = 20
};


class CalendarView: public UI_MonthCalendar {
public:
    CalendarView (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                  UI_ViewID id)
    : UI_MonthCalendar (parent, shape, id) {};

    void ClickOnDay (short day); // Override inherited method
};


void CalendarView::ClickOnDay (short day)
{
    CL_String msg;
    msg.AssignWithFormat ("You clicked on %d", day);
    UI_StandardDialog (msg.AsPtr(), "Calendar", YACLApp()->MainWindow());
}



class AppWindow: public UI_Dialog {

public:
    AppWindow ();

    // Override the Composite's virtual method:
    bool HandleChildEvent (const UI_Event& e);

protected:
    CalendarView* cal;
    UI_PushButton* prev, *next;

};

    
AppWindow::AppWindow()
: UI_Dialog (NULL, NULL, UI_Rectangle (50, 50, 270, 320))
{
    _id  = ID_MAIN;
    cal  = new CalendarView  (this, UI_Rectangle (0,0, 270, 230), ID_CAL);
    prev = new UI_PushButton (this, UI_Rectangle (50, 250, 40, 30), ID_PREV);
    (prev->Title()) = "<";
    next = new UI_PushButton (this, UI_Rectangle (120, 250, 40, 30), ID_NEXT);
    (next->Title()) = ">";
    Background (UIColor_MediumGray);

    cal->Font() = UI_FontDesc (UIFont_Helvetica, 10, UIFont_BoldFace);
}


bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() == Event_Select) {
        if (e.Origin()->ViewID() == ID_NEXT)
            cal->AdvanceMonth();
        else if (e.Origin()->ViewID() == ID_PREV)
            cal->PreviousMonth();
	return TRUE;
    }
    return FALSE;
}


class CalendarApp: public UI_Application {
    
public:
    CL_String InstanceName (UI_VisualObject* v);
};


CL_String CalendarApp::InstanceName (UI_VisualObject* v)
{
    if (!v)
        return "";
    switch (v->ViewID()) {
    case ID_MAIN:
        return "CalendarMain";

    case ID_CAL:
        return "Calendar";

    default:
        return UI_Application::InstanceName (v);
    }
}
        



// ========================== Main program ==========================

// Create the instance of the calendar application:
CalendarApp theApp;



// Provide the main program:

int UI_Application::Main (int, char* [])
{
    MakeTopWindow (new AppWindow);
    MainWindow()->Title() = "YACL Calendar Demo";
    Run();
    return 0;
}
