

#ifndef _appwin_h_ 
#define _appwin_h_


#include "base/integer.h"

#include "ui/dialog.h"
#include "ui/label.h"

// ------------------------ Class AppWindow ---------------------------


class AppWindow: public UI_Dialog {

public:
    AppWindow ();
    bool HandleChildEvent (const UI_Event& e);


protected:
    void           MakeDigitButtons(const UI_Rectangle& r);
    void           MakeOpButtons   (const UI_Rectangle& r);
    void           MakeRadixPanel  (const UI_Rectangle& r);
    bool           DoOp (char op);
    void           DoRadix (short radix);
    void           DoClear ();
    bool           DoDigit (short digit);
    
    UI_Label*      _label;
    short          _radix;
    char           _op;
    long           _stack[2];
    short          _top;
};

#endif /* _appwin_h_ */
