
// --------------------------- appwin.cxx --------------------------------

#include "appwin.h"
#include "ui/applic.h"
#include "cusbtn.h"
#include "ui/bmtglbtn.h"

enum {
    ID_BUTTON0 = 10
  , ID_BUTTON1 = 11
  , ID_BUTTON2 = 12
  , ID_BUTTON3 = 13
  , ID_BUTTON4 = 14
  , ID_ENABLE
  , ID_DISABLE
  , ID_LABEL   = 20
};


UI_BitmapData::ColorInfo colors[256] = {
{128, 128, 128},
{192, 192, 192},
{255, 255, 255},
{96,    0,   0},
{ 0,  255,   0},
{0, 0, 0}
};

ulong pixels [] = {
    1, 1, 1, 1, 1,    1, 1, 4, 4, 4,  4, 4, 4, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 4, 4,  4, 4, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 4,  4, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  4, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    
    1, 1, 1, 1, 1,    2, 2, 2, 2, 2,  2, 2, 2, 2, 2,  3, 3, 3, 3, 3,
    1, 1, 1, 1, 1,    2, 2, 2, 2, 2,  2, 2, 2, 2, 1,  1, 3, 3, 3, 3,
    1, 1, 1, 1, 1,    2, 2, 2, 2, 2,  2, 2, 2, 1, 1,  1, 1, 3, 3, 3,
    1, 1, 1, 1, 1,    2, 2, 2, 2, 2,  2, 2, 1, 1, 1,  1, 1, 1, 3, 3,
    1, 1, 1, 1, 1,    2, 2, 2, 2, 2,  2, 1, 1, 1, 1,  1, 1, 1, 1, 3,
    
    1, 1, 1, 1, 1,    2, 2, 2, 2, 2,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    2, 2, 2, 2, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    2, 2, 2, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    2, 2, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    2, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1,
    1, 1, 1, 1, 1,    1, 1, 1, 1, 1,  1, 1, 1, 1, 1,  1, 1, 1, 1, 1
    
};




AppWindow::AppWindow()
: UI_CompositeVObject (NULL, UI_Rectangle (40, 40, 360, 200))
{
    UI_BitmapData data (20, 20, UI_BitmapData::Color_4Bits, 5, colors, pixels);
    _msg   = new UI_Label (this, UI_Rectangle (15, 15, 365, 20), ID_LABEL);

    _btn0  = new UI_BitmapPushButton (this, UI_Rectangle (15,  45, 40, 40),
                                     ID_BUTTON0, &data);
    _btn1  = new CustomBitmapButton (this, UI_Rectangle (75,  45, 40, 40),
                                      ID_BUTTON1,  "help.bmp",
                                     "help-dis.bmp");
    _btn2  = new UI_BitmapToggleButton (this, UI_Rectangle (135, 45, 40, 40),
                                      ID_BUTTON2);
    _btn3  = new UI_BitmapPushButton (this, UI_Rectangle (195, 45, 40, 40),
                                      ID_BUTTON3);
    _btn4  = new CustomBitmapButton (this, UI_Rectangle (255, 45, 40, 40),
                                     ID_BUTTON4, "undo.bmp", "undo-dis.bmp");
    _btn1->EnabledBitmap().BuildFrom ("help.bmp");
    _btn2->EnabledBitmap().BuildFrom ("scissors.bmp");
    _btn3->EnabledBitmap().BuildFrom ("text.bmp");
    _btn4->EnabledBitmap().BuildFrom ("undo.bmp");

    _enableBtn  = new UI_PushButton (this, UI_Rectangle (60, 150, 110, 30),
                                     ID_ENABLE);
    _disableBtn = new UI_PushButton (this, UI_Rectangle (190, 150, 110, 30),
                                     ID_DISABLE);
    _enableBtn->Title()  = "Enable all";
    _disableBtn->Title() = "Disable all";
    
    Title()       = "YACL Bitmap Button Demo";
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    CL_String s = "Select event from id " + CL_String
        (e.Origin()->ViewID());
    if (e.Origin() == _btn2)
        s += " model is now " + e.Origin()->Model().AsString();
    _msg->Title() = s;

    if (e.Origin() == _enableBtn) {
        _btn0->Enable ();
        _btn1->Enable ();
        _btn2->Enable ();
        _btn3->Enable ();
        _btn4->Enable ();
        return FALSE;
    }
    if (e.Origin() == _disableBtn) {
        _btn0->Disable ();
        _btn1->Disable ();
        _btn2->Disable ();
        _btn3->Disable ();
        _btn4->Disable ();
        return FALSE;
    }
    return FALSE;
}

