
#include "ui/dsplsurf.h"
#include "appwin.h"

#if defined(__GNUC__)
template class CL_Binding0 <AppWindow>;
#endif

typedef CL_Binding0<AppWindow> Bind;
const short _BallDiameter = 20;

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (10, 50, 250, 150)),
  _timer (Bind (this, &AppWindow::_Draw))
{
    Title () = "YACL Bouncing Ball";
    _xInc = _yInc = 5;
}

AppWindow::~AppWindow ()
{
    _timer.Stop ();
}

void AppWindow::Initialize ()
{
    _bgColor = UI_Color (UIColor_White);
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    sfc.ClearDisplay ();
    UI_Rectangle bgRect (1, 1, _BallDiameter+4, _BallDiameter+4);
    _bgMap.CopyFrom (sfc, bgRect);
    sfc.Pen().Color     (UIColor_Black);
    sfc.Brush().Color   (UIColor_Red);
    sfc.Brush().Pattern (UIBrush_Solid);
    sfc.DrawEllipse (UI_Rectangle (3, 3, _BallDiameter, _BallDiameter),
                     UID_Outline | UID_Fill);
    _ballMap.CopyFrom (sfc, bgRect);
    _position = UI_Point (1, 1);
    _timer.Start (25);
}


bool AppWindow::_Draw ()
{
    UI_DisplaySurface& sfc = *DisplaySurface ();
    sfc.DrawBitmap (_bgMap, _position);
    _position += UI_Vector (_xInc, _yInc);
    long x = _position.XCoord(), y = _position.YCoord();
    if (x < 0 || x > Shape().Width() - _BallDiameter)
        _xInc = -_xInc;
    if (y < 0 || y > Shape().Height() - _BallDiameter)
        _yInc = -_yInc;
    sfc.DrawBitmap (_ballMap, _position);
    return TRUE;
}


bool AppWindow::Reconfigure (const UI_Rectangle&)
{
    _position = UI_Point (1, 1);
    UI_DisplaySurface* sfc = DisplaySurface ();
    if (sfc)
        sfc->ClearDisplay();
    return TRUE;
}

