

#ifndef _xrtglbtn_h_ /* Fri Mar 11 08:38:02 1994 */
#define _xrtglbtn_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// ExOrToggleButton is a SimpleVObject that represents an ``exclusive-or''
// version of the toggle 
// button, also  called a {\it radio button}. Its model is a {\tt
// CL_Integer} whose value is either 0 or 1 according to whether the button
// is currently on or off.


#if defined(__GNUC__)
#pragma interface
#endif


#include "base/integer.h"
#include "ui/simple.h"

class YACL_UI UI_ExOrButtonGroup;
class YACL_UI UI_CompositeVObject;

class YACL_UI UI_ExOrToggleButton: public UI_SimpleVObject {

public:

    UI_ExOrToggleButton (UI_VisualObject* parent, const UI_Rectangle& shape,
                         UI_ViewID id = -1);
    // Constructor: create an ExOrToggleButton as a child of {\tt parent},
    // with the given shape and view id.
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ExOrToggleButton (UI_CompositeVObject* parent,
                         UI_ViewID id, UI_ViewHandle h);
    // [MS-Windows-specific] For resource-based construction.

#endif

    CL_Object& Model ();
    // Return a reference to the model, which is actually an Integer.

    virtual UI_WindowClass WindowClass () const;
    // Overrides the inherited method.
    
    const char* ClassName () const {return "UI_ExOrToggleButton";};


protected:

    void _PrivateInitialize ();
    // Override the inherited method. The implementation sets up resources
    // and callbacks under X windows.

    bool _ModelChanged ();
    // Tell this object that its model's content was changed by the
    // application.

    ~UI_ExOrToggleButton(){;};
     
    
#if defined (__X_MOTIF__)
    static void SelectionCallback (struct _WidgetRec*, void *, void *);
    // [X-windows-specific, YACL internal use only] The callback executed
    // when the button is selected.
    
#elif defined(__X_YACL__)
    bool MakeVisualElement ();
    
    void DrawVisualElement ();
    // Draw the visual representation of this button.

    bool HandleEvent (UI_Event*);
    // Override the inherited method.

    bool _TitleChanged ();
    // Override the inherited method.
    
#endif
    
};




#endif /* _xrtglbtn_h_ */
