




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/xrtglbtn.h"
#include "ui/xrbtngrp.h"
#include "ui/cntroler.h"


#include "base/integer.h"
#include "base/intset.h"

#if defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/ToggleB.h>
#elif defined(__X_YACL__)
#    include "ui/dsplsurf.h"
#    include "ui/pen.h"
#    include "ui/support/x_yacl/window.h"
#endif


//------------------------------------------------------------------
//                     CLASS ExOrToggleButton
//------------------------------------------------------------------

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#include <windows.h>
#define EXOR_TOGGLE_BUTTON_STYLE \
    BS_AUTORADIOBUTTON | WS_CHILD | WS_VISIBLE
#elif defined(__OS2__)
#define EXOR_TOGGLE_BUTTON_STYLE BS_AUTORADIOBUTTON | WS_VISIBLE
#endif



UI_ExOrToggleButton::UI_ExOrToggleButton
    (UI_VisualObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_SimpleVObject (parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _style = EXOR_TOGGLE_BUTTON_STYLE;
#elif defined(__X_YACL__)
    _visualElement = NULL;
#endif
    _model = new CL_Integer;
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_ExOrToggleButton::UI_ExOrToggleButton
    (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle handle) 
: UI_SimpleVObject (parent, id, handle)
{
    _model = new CL_Integer; 
    _borderShown = FALSE;
}
#endif




void UI_ExOrToggleButton::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
    _ModelChanged (); // Dummy call to force initial setting

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _Controller->SubclassControl (_handle, (FARPROC) YACLBtnProc);
#elif defined (__X_MOTIF__)
    XtAddCallback (_xwidget, XmNvalueChangedCallback, 
                   &UI_ExOrToggleButton::SelectionCallback, (XtPointer)
                   this);
    XtVaSetValues (_xwidget, XmNmarginWidth, 0, XmNmarginHeight, 0, NULL);
    XtVaSetValues (_xwidget, XmNalignment, XmALIGNMENT_BEGINNING, NULL);
    // If we try to set the alignment at creation time (i.e., in
    // _SetupStyle), Motif complains!
    Arg  args [2];
    XtSetArg    (args [0], XmNindicatorType , XmONE_OF_MANY);
    XtSetArg    (args [1], XmNvisibleWhenOff, TRUE);
    XtSetValues   (_xwidget, args, 2);
#endif
}



CL_Object& UI_ExOrToggleButton::Model ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0)
        _SetModelValue (CL_Integer (SendMessage (_handle, BM_GETCHECK, 0,
                                                 0L)));
#elif defined(__OS2__)
    if (_handle) {
        long val = (long) WinSendMsg (_handle, BM_QUERYCHECK, 0, 0L);
        _SetModelValue (CL_Integer (val));
    }
#elif defined (__X_MOTIF__)
    if (_xwidget)
        _SetModelValue (CL_Integer ((short)XmToggleButtonGetState (_xwidget)));
#endif
    return *_model;
}



#if defined (__X_MOTIF__)

void UI_ExOrToggleButton::SelectionCallback (Widget , void* client,
                                             void* call)
{
    UI_ExOrToggleButton* btn = (UI_ExOrToggleButton *) client;
    int value = ((XmToggleButtonCallbackStruct*) call)->set;
    btn->_SetModelValue (CL_Integer(value));
    _Controller->AddEvent (new UI_Event (Event_Select, btn, btn));

    // Now ensure that at most one of the buttons is on:
    CL_ObjectSequence siblings = _Controller->ChildrenOf (btn->Parent());
    short n = siblings.Size();
    for (short i = 0; i < n; i++) {
        UI_VisualObject* v = (UI_VisualObject*) siblings[i];
        if (v != btn && v->WindowClass() == btn->WindowClass()) {
            // ------- ^^^^^^^^^^^^^^^^^^^ --------------
            // We're using type identification here, unfortunately
            v->Model() = CL_Integer(0);
        }
    }
}

#endif



bool UI_ExOrToggleButton::_ModelChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if(_handle > 0) {
        SendMessage (_handle, BM_SETCHECK,
                     ((CL_Integer*) _model)->Value () > 0 ? 1 : 0, 0
                    );
    }

#elif defined(__OS2__)
    if (_handle) {
        MPARAM val = MPFROM2SHORT (((CL_Integer *) _model)->Value () > 0
                                   ? TRUE : FALSE, 0);
        WinSendMsg (_handle, BM_SETCHECK, val, NULL);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget) {
        bool state = (((CL_Integer *) _model)->Value () > 0 ? TRUE : FALSE);
        Arg arg[1];
        XtSetArg    (arg [0], XmNset, state);
        XtSetValues (_xwidget, arg, 1);
    }
#elif defined(__X_YACL__)
    if (_visible && _enabled)
        DrawVisualElement ();
#endif
    return TRUE;
}



UI_WindowClass UI_ExOrToggleButton::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "button";
#elif defined(__OS2__)
    return WC_BUTTON;
#elif defined(__X_MOTIF__)
    return xmToggleButtonWidgetClass;
#endif
}



#if defined(__X_YACL__)

static void _DrawDiamond (UI_DrawingSurface& sfc, short n,
                          const UI_Point& p, bool raised)
{
    // Draw a diamond with center at p, within a square of side n
    // pixels. The diamond is drawn raised if "raised" is TRUE, and recessed
    // otherwise. This code uses a 2-pixel shadow. The parameter n must be
    // even and positive.
    UI_Pen& pen = sfc.Pen();
    UI_Color topColor, bottomColor;
    if (raised) {
        topColor    = UI_Color (UIColor_MediumGray).LightShadow();
        bottomColor = UI_Color (UIColor_MediumGray).DarkShadow();
    }
    else {
        topColor    = UI_Color (UIColor_MediumGray).DarkShadow();
        bottomColor = UI_Color (UIColor_MediumGray).LightShadow();
    }
    long x = p.XCoord(), y = p.YCoord();
    UI_Point west  = p - UI_Vector (n/2, 0);
    UI_Point north = p - UI_Vector (0, n/2);
    UI_Point south = north + UI_Vector (0, n);
    UI_Point east  = west  + UI_Vector (n, 0);

    // Draw the top shadow
    pen.Color (topColor);
    sfc.DrawLine (west, north);
    sfc.DrawLine (north, east);
    sfc.DrawLine (west + UI_Vector(1, 0), north + UI_Vector(0,1));
    sfc.DrawLine (north + UI_Vector(0,1), east - UI_Vector(1, 0));
    
    // Draw the bottom shadow
    pen.Color (bottomColor);
    sfc.DrawLine (west, south);
    sfc.DrawLine (south, east);
    sfc.DrawLine (west + UI_Vector(1, 0), south - UI_Vector(0,1));
    sfc.DrawLine (south - UI_Vector(0,1), east - UI_Vector(1, 0));
}
    
void UI_ExOrToggleButton::DrawVisualElement ()
{
    if (!_visible || !_window)
        return;
    CL_Integer value = *(CL_Integer*) _model;
    UI_DisplaySurface& sfc = CreateDisplaySurface();

    // Draw the red inside
    if (value != 0) {
        sfc.ColorRectangle (UI_Rectangle (6, 6, 6, 6),
                            UI_Color (0.804, 0.361, 0.361));
        // Fill with Indian Red
    }
    else {
        sfc.ColorRectangle (UI_Rectangle (6, 6, 6, 6), _bgColor);
    }
    _DrawDiamond (sfc, 12, UI_Point (9, 9), value ? FALSE : TRUE);
    short ht = Font().Height();
    sfc.Pen().Color (UIColor_Black);
    sfc.WriteString
        (_title, UI_Rectangle (20, maxl (1, 10 - ht/2),
                               _shape.Width() - 20, ht));
    DestroyDisplaySurface();
}

bool UI_ExOrToggleButton::HandleEvent (UI_Event* e)
{
    if (!e)
        return FALSE;
    if (!_enabled)
        return FALSE;
    UI_EventType type = e->Type();
    switch (type) {
    case Event_LButtonPress: {
        _SetModelValue (CL_Integer (1));
        DrawVisualElement();
        UI_Event e (Event_Select, this, this);
        _Controller->DispatchEvent (&e);
        break;
    }
    
    case Event_Paint:
        DrawVisualElement();
        break;

    default:
        break;
    }
    return ProcessEvent (e);
}

bool UI_ExOrToggleButton::MakeVisualElement ()
{
    _visualElement = new YVE_Window (this);
    if (_visualElement)
        _window = _visualElement->Handle();
    return _visualElement && _visualElement->Handle() ? TRUE : FALSE;
}

bool UI_ExOrToggleButton::_TitleChanged ()
{
    if (_visible && _enabled && _window)
        DrawVisualElement();
}

#endif
