

#ifndef _xrbtngrp_h_ /* Tue Nov 22 09:36:40 1994 */
#define _xrbtngrp_h_




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// An ExOrButtonGroup is a SimpleVObject that has an Integer as model. The
// visual representation of the ExOrButtonGroup is a group of toggle buttons
// (``radio buttons'' under MS-Windows), at most one of which may be
// selected at any given time. The Integer model contains the view id of the
// button currently selected, and the {\tt Selection} method returns this
// view id.


#if defined(__GNUC__)
#pragma interface
#endif


#include "base/integer.h"
#include "ui/composit.h"
#include "ui/btngroup.h"


class YACL_UI UI_ExOrToggleButton;

class YACL_UI UI_ExOrButtonGroup: public UI_ButtonGroup {

public:

    UI_ExOrButtonGroup (UI_VObjCollection* parent, 
                        const UI_Rectangle& shape,
                        UI_ViewID id = -1, UI_ViewDescriptor* vd = NULL);
    // Constructor: creates a ButtonGroup as a child of {\tt
    // parent}, with the given shape and view ID. The {\tt vd} parameter, if
    // specified, must point to an array of ViewDescriptors (see {\tt
    // ui/viewdesc.h}) that must all describe ExOrToggleButtons. The last
    // entry in this array must have a view type {\tt View_None}.
    
    virtual CL_Integer& Selection ();
    // Return the view ID of the currently selected toggle button, as a {\tt
    // CL_Integer}.  The return value may be
    // modified via the Integer methods, and this results in modification of
    // the display.

    CL_Object& Model () {return Selection();};
    // This is a synonym for the {\tt Selection} method, so the returned
    // reference is to the Integer representing the selection. This method
    // overrides the inherited method.
    


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ExOrButtonGroup (UI_CompositeVObject* parent,  UI_ViewID id,
                        UI_ViewHandle h);
    // Resource-based construction (only under MS-Windows). This assumes
    // that (1) all (and only) the buttons in the group are geometrically
    // contained within the button group box's rectangle,  (2) the
    // contained buttons occur immediately after the group box in the
    // resource file ordering, and (3) the group box has a valid id.
    // Therefore, this does not allow (in particular) for groups within groups.

#endif

    
protected:

    bool _ModelChanged ();
    // Called to notify this object that its model has changed.

    bool HandleChildEvent (const UI_Event& e);
    // Overrides the method inherited from VObjCollection. The
    // implementation updates the current selection.
    
    CL_Integer _selection;

private:
    void _Init ();
    // [YACL internal use only]

    void _UpdateSelection ();
    // [YACL internal use only] Update the current selection.

#if defined(__X_YACL__)
    UI_ExOrToggleButton* _selected;

#endif
     
};




#endif /* _xrbtngrp_h_ */
