


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// Support for event translation and handling under X windows, with and
// without Motif.

#if defined(__GNUC__)
#pragma implementation
#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#    include <string.h>  // Without this, the X includes barf
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>

#if defined(__X_MOTIF__)
#    include <Xm/BulletinB.h>
#    include <Xm/DrawingA.h>
#    include <Xm/Xm.h>
#    include <Xm/Label.h>
#    include <Xm/MainW.h>
#    include <Xm/ScrolledW.h>
#    include <X11/StringDefs.h>
#    include <X11/Intrinsic.h>
#    include <X11/Shell.h>
#    ifndef NO_EDITRES_COMPAT
#        include <X11/Xmu/Editres.h>
#    endif
#else // X_YACL
#    include <sys/types.h>
#    include <sys/time.h>
#    if defined(__SGI_DELTA_CC__)
#        include <unistd.h>
#    endif
#endif

#include <iostream.h> // DEBUG

#include "base/genseq.h"

#include "ui/cntroler.h"
#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/timer.h"

#if defined(__X_MOTIF__)
#include "ui/support/x_motif/ycomp.h"
#endif

typedef int (*OurXErrorHandler) (Display*, XErrorEvent*);


#if defined(__X_MOTIF__)
extern XtAppContext _YACLXAppContext; // Declared in cntroler.cxx
#endif


// -------------------- STATIC OBJECTS ---------------------------

static OurXErrorHandler _DefaultErrorHandler = 0;

static struct {
    int          message  ;
    UI_EventType yaclEvent;
} TransTable [] = {
    ButtonPress    , Event_LButtonPress  ,
    ButtonRelease  , Event_LButtonRelease,
    MotionNotify   , Event_MouseMove     ,
    KeyPress       , Event_KeyTyped      ,
    KeyRelease     , Event_KeyUp         ,
    EnterNotify    , Event_ViewEnter     ,
    LeaveNotify    , Event_ViewLeave     ,
    FocusIn        , Event_GetFocus      ,
    FocusOut       , Event_LoseFocus     , 
    Expose         , Event_Paint         ,
    GraphicsExpose , Event_GraphicsExpose,
    ConfigureNotify, Event_Reconfigure   ,
    MapNotify,       Event_Deiconify     ,
    UnmapNotify,     Event_Iconify       ,
    0              , Event_Other         
};




bool UI_Controller::_DoOneEvent (NativeEventStruct& xevent)
{
    UI_Event e (Event_None, 0);
#if defined(__X_MOTIF__)
    if (TranslateNativeEvent (xevent, e)) {
        if (!_eventFilter || _eventFilter->Execute (e)) {
            XtDispatchEvent (&xevent);
            DispatchNativeEvent (e);
        }
        else if (e.Type() == Event_Paint)
            XtDispatchEvent (&xevent);
    }
    else
        XtDispatchEvent (&xevent);
#else // X_YACL
    if (TranslateNativeEvent (xevent, e) &&
        (!_eventFilter || _eventFilter->Execute (e))) {
        DispatchNativeEvent (e);
    }
#endif
    if (_termination && _termination->Execute (e))
        return FALSE;
    return TRUE;
}



bool UI_Controller::ProcessNativeEvents ()
{
#if defined(__X_YACL__)
    XEvent xevent;
    while (_root) {
        DispatchSoftEvents ();
        while (XEventsQueued (_display, QueuedAfterFlush)) {
            XNextEvent (_display, &xevent);
            bool b = _DoOneEvent (xevent);
            DispatchSoftEvents ();
            if (!b)
                return FALSE;
        }
        if (_WaitForNextEvent ()) {
            // The event added a timer request, so we see
            // if the timer expired
            _DispatchTimerEvents ();
        }
    }
    return TRUE;
#else // X_MOTIF
    DispatchSoftEvents ();
    XEvent xevent;
    while (_root) {
        XtAppNextEvent  (_YACLXAppContext, &xevent);
        bool b = _DoOneEvent (xevent);
        DispatchSoftEvents ();
        if (!b)
            return FALSE;
    }
    return TRUE;
#endif
}


void UI_Controller::FlushEventQueue ()
{
    XEvent           xevent;
#if defined(__X_MOTIF__)
    while ( XtAppPending (_YACLXAppContext) != 0 ) {
        XtAppNextEvent  (_YACLXAppContext, &xevent);
    }
#else // X_YACL
    while ( XEventsQueued (_display, QueuedAlready) > 0 ) {
        XNextEvent  (_display, &xevent);
    }
#endif
}



void UI_Controller::DispatchPendingEvents ()
{
    XEvent           xevent;
#if defined(__X_YACL__)
    DispatchSoftEvents ();
    while (XEventsQueued (_display, QueuedAfterFlush)) {
        XNextEvent (_display, &xevent);
        _DoOneEvent (xevent);
        DispatchSoftEvents ();
    }
#else
    while ( XtAppPending (_YACLXAppContext) != 0 ) {
        XtAppNextEvent  (_YACLXAppContext, &xevent);
        _DoOneEvent (xevent);
    }
#endif
}


void UI_Controller::XEventHandler (struct _WidgetRec* , void* ,
                                   XEvent* xevent, char *)
{
    if (!xevent)
        return;
    UI_Event e (Event_None, 0);
    UI_Controller& controller = YACLApp()->Controller();
    if (controller.TranslateNativeEvent (*xevent, e)) {
        if (!controller._eventFilter ||
            controller._eventFilter->Execute (e))
            controller.DispatchNativeEvent (e);
    }
}




bool UI_Controller::DispatchNativeEvent ( UI_Event& e )
{
    if (!_root)
        return TRUE;
//    cout << e.AsString() << endl; // DEBUG
    bool ret_val = TRUE;
    UI_VisualObject* view = e.Origin();
    switch (e.Type ()) {
    case Event_MouseMove:
        if (!_inWaitState)
            SetCurrentCursor (e.Destination()->Cursor());
        ret_val = DispatchEvent (&e);
        break;

    case Event_Paint:
        if (view && !view->_hasBeenInited) {
            view->_hasBeenInited = TRUE;
            view->Initialize ();
//             if (XtClass (view->_xwidget) == xmBulletinBoardWidgetClass)
//                 XtAugmentTranslations (view->_xwidget, defaultTrans);
        }
        ret_val = DispatchEvent (&e);
        break;   

    case Event_ViewEnter:
        ret_val = DispatchEvent (&e);
        break;

        
    default:
        ret_val = DispatchEvent (&e);
        break;
    }
    return ret_val;
}



class OneShotTimer: public UI_Timer {


public:
    OneShotTimer ();

private:
    bool Expired ();
};

#if defined(__GNUC__)
template class CL_Binding0<OneShotTimer>;
#endif

typedef CL_Binding0<OneShotTimer> TimerBinding;

OneShotTimer::OneShotTimer ()
: UI_Timer (TimerBinding (this, &OneShotTimer::Expired))
{
}

bool OneShotTimer::Expired ()
{
    return Stop ();
}

    

static OneShotTimer doubleClickTimer;

bool UI_Controller::TranslateNativeEvent (NativeEventStruct& msg, UI_Event& e)
{
    char keystring [31];
    XComposeStatus composestat;
    KeySym         keysym     ; 

    UI_VisualObject *view = 0;
    e._nativeEvent = new NativeEventStruct;
    *(NativeEventStruct*) (e._nativeEvent) = msg;

    XLookupString (&msg.xkey, keystring, 30, &keysym, &composestat);
    e.key = keysym;
 
    e.curPos = UI_Rectangle (msg.xbutton.x, msg.xbutton.y, 0, 0);
    short i;
    for (i = 0; TransTable[i].message != 0; i++) {
        if ( TransTable [i].message == msg.type ) {
            break;
	}
    }
    e._type = TransTable [i].yaclEvent;

#if defined(__X_MOTIF__)
    // Now set the destination of the event
    Widget visElt = XtWindowToWidget (msg.xany.display, msg.xany.window);
    if (!visElt)
        return FALSE;
    // ----------- Begin fixes due to Ulrich Ring (ur@daveg.com)
    if (msg.type == KeyPress || msg.type == KeyRelease) {
        // visElt = XmGetFocusWidget (visElt);
        Widget f =  XmGetFocusWidget (visElt);
        if (f) {
            visElt = f;
            Widget p = XtParent (visElt);
            if (p && XtClass (p) == xmScrolledWindowWidgetClass) {
                visElt = p; 
            }
        }
    }
    // ----------- End fixes due to Ulrich Ring (ur@daveg.com)
#else
    Window visElt = msg.xany.window;
#endif

    view = ( UI_VisualObject* ) _visualObjMap [(long) visElt];
#if defined(__X_YACL__)
    if (!view)
        return FALSE;
#else
    if (!view) {
        view = (UI_CompositeVObject*) _shellMap [(long) visElt];
        if (!view) {
            if (_focus)
                view = _focus;
            else
                return FALSE;
        }
    }
#endif
    e._origin = e._dest = view;
    switch (msg.type) {
#if defined(__X_YACL__)
    case ClientMessage: {
        Atom deleteAtom = XInternAtom (_display, "WM_DELETE_WINDOW", False);
        if (msg.xclient.data.l[0] == deleteAtom)
            e._type = Event_CloseDown;
        break;
    }
#endif
    
    case Expose: {
        if (msg.xexpose.count > 0)
            return FALSE;
        XEvent* xevt = (XEvent*) e.NativeEvent();
        if (xevt)
            e.curPos = UI_Rectangle (xevt->xexpose.x, xevt->xexpose.y,
                                     xevt->xexpose.width,
                                     xevt->xexpose.height);
        else if (view) {
            e.curPos = UI_Rectangle (0, 0, view->_shape.Width(),
                                     view->_shape.Height());
        }
        else
            e.curPos = UI_Rectangle (0, 0, 0, 0);
        break;
    }
        
    case ButtonPress: {
        if (doubleClickTimer.IsRunning()) {
            doubleClickTimer.Stop ();
            switch (msg.xbutton.button) {
            case Button1:
                e._type = Event_LButtonDblClk;
                break;
            case Button2:
                e._type = Event_MButtonDblClk;
                break;
            case Button3:
                e._type = Event_RButtonDblClk;
                break;
            }
        }
        else {
            switch (msg.xbutton.button) {
            case Button1:
                e._type = Event_LButtonPress;
                break;
            case Button2:
                e._type = Event_MButtonPress;
                break;
            case Button3:
                e._type = Event_RButtonPress;
                break;
            }
            e._shiftKey = (msg.xbutton.state & ShiftMask) ? TRUE : FALSE;
            e._ctrlKey  = (msg.xbutton.state & ControlMask) ? TRUE : FALSE;
            e._metaKey  = (msg.xbutton.state & Mod1Mask) ? TRUE : FALSE;

            // Start the double-click timer
#if defined(__X_MOTIF__)
            short doubleClickInterval = XtGetMultiClickTime
                (XtDisplay (_rootshell));
            // We get the multiclick time every time, rather than getting it
            // once at initialization and storing it, just in case the user
            // modifies it via the resource mechanism.
            doubleClickTimer.Start (doubleClickInterval);
#else
            short doubleClickInterval = 400; // For now
            // Don't support double-clicks yet
#endif
        }
        break;
    }
        
    case ButtonRelease:
        switch (msg.xbutton.button) {
          case Button1: e._type = Event_LButtonRelease; break;
          case Button2: e._type = Event_MButtonRelease; break;
          case Button3: e._type = Event_RButtonRelease; break;
        }
        break;

    case ConfigureNotify:
    {
#   if defined(__X_YACL__)
        e.curPos = UI_Rectangle (msg.xconfigure.x, msg.xconfigure.y,
                                 msg.xconfigure.width, msg.xconfigure.height);
#   else
        Widget wd = visElt;
        if (view)
            wd = view->_xwidget;
        // We have to resort to the Xt stuff here, because the event
        // structure always gives us (0, 0) for x and y when the window is
        // reshaped.
        Position  x = msg.xconfigure.x, y = msg.xconfigure.y;
        Dimension w = msg.xconfigure.width, h = msg.xconfigure.height;
        long oldw = view->Shape().Width(), oldh = view->Shape().Height();
        if (w == oldw && h == oldh) {
            // it's a move operation
            e.curPos = UI_Rectangle (x, y, oldw, oldh);
        }
        else {
            // It's a resize, possibly coupled with a move
            if (wd && XtClass (wd) == xmMainWindowWidgetClass) {
                Widget shell = ((UI_CompositeVObject*) view)->ShellHandle();
                Position newx, newy;
                XtVaGetValues (shell, XtNx, &newx, XtNy, &newy, NULL);
                x = newx;
                y = newy;
            }
            e.curPos = UI_Rectangle (x, y, w, h);
        }
            
//         if (wd) {
//             Position oldx, oldy;
//             Dimension width, ht;
//             XtVaGetValues (wd, XtNx, &oldx, XtNy, &oldy,
//                            XtNwidth, &width, XtNheight, &ht, NULL);
//         }
//         e.curPos = UI_Rectangle (x, y, w, h);
// //         cout << "ConfigureNotify " << e.curPos << " for " <<
// //             e._origin->InstanceName() << endl;
        
#   endif
        break;
    }


    }
    return TRUE;
}




#if defined(__X_MOTIF__)
// RegisterTimeOut: register a timeout function with Xt. The return value is
// a handle to the registered function.
ulong UI_Controller::RegisterTimeOut
    (long msec, void (*function) (void*, ulong*), void* client_data)
{
    if (function && msec > 0) // Guard against errors
        return XtAppAddTimeOut (_YACLXAppContext, msec, (XtTimerCallbackProc)
                                function, client_data);
    else
        return 0;
}

void UI_Controller::UnregisterTimeOut (ulong handle)
{
    XtRemoveTimeOut (handle);
}



#elif defined(__X_YACL__)

static timeval TimeAtStart;

class TimerRequest: public CL_Object {

public:
    TimerRequest (ulong id, ulong mSec, UI_Timer* timer);

    ulong      _id;        // Timer id
    UI_Timer*  _timer;     // Corresponding Timer object
    timeval    _expTime; // Time at which this timer will expire
};


ostream& operator<< (ostream& s, const timeval& t)
{  /// DEBUG only
    s << t.tv_sec << " " << t.tv_usec;
    return s;
}

TimerRequest::TimerRequest (ulong id, ulong mSec, UI_Timer* timer)
: _id (id), _timer (timer)
{
    gettimeofday (&_expTime, NULL);
    _expTime.tv_usec += mSec * 1000;
    _expTime.tv_sec += _expTime.tv_usec / 1000000;
    _expTime.tv_usec %= 1000000;
}


static timeval _Subtract (const timeval& t1, const timeval& t2)
{
    // Return the result of subtracting t2 from t1
    timeval r = {t1.tv_sec - t2.tv_sec, t1.tv_usec - t2.tv_usec};
    if (r.tv_usec < 0) {
        r.tv_usec += 1000000;
        r.tv_sec --;
    }
    return r;
}

bool UI_Controller::_WaitForNextEvent ()
{
    fd_set fds;
    int fd = ConnectionNumber (_display);
    FD_SET (fd, &fds);
    long timerQSize = _timerQueue.Size();
    if (timerQSize <= 0) {
        // No timer requests pending
        // static timeval zeroTime = {0};
        select (fd + 1, &fds, NULL, NULL, NULL);
        return FALSE;
    }
    timeval now;
    gettimeofday (&now, NULL);
    timeval tval;
    TimerRequest* rq = (TimerRequest*) _timerQueue (0);
    tval = _Subtract (rq->_expTime, now);
    if (tval.tv_sec < 0 || tval.tv_sec == 0 && tval.tv_usec <= 0)
        return TRUE;
    int result = select (fd + 1, &fds, NULL, NULL, &tval);
    return result == 0;
}

ulong UI_Controller::RegisterTimeOut (long msec,  UI_Timer* timer)
{
    if (msec > 0) {
        ulong id = _nextTimerId++;
        _timerQueue.Add (new TimerRequest (id, msec, timer));
        return id;
    }
    return 0;
}

void UI_Controller::UnregisterTimeOut (ulong id)
{
    long i;
    TimerRequest* rq = NULL;
    for (i = _timerQueue.Size() - 1; i >= 0; i--) {
        rq = (TimerRequest*) _timerQueue(i);
        if (rq->_id == id)
            break;
    }
    if (i >= 0) {
        _timerQueue.Remove (i);
        delete rq;
    }
}


void UI_Controller::_DispatchTimerEvents ()
{
    timeval now;
    gettimeofday (&now, NULL);
    timeval tval;
    while (_timerQueue.Size()) {
        TimerRequest* rq = (TimerRequest*) _timerQueue (0);
        tval = _Subtract (rq->_expTime, now);
        if (tval.tv_sec < 0 || tval.tv_sec == 0 && tval.tv_usec <= 0) {
            _timerQueue.ShiftLeftAt (1);
            UI_Timer::DoAlarm (rq->_timer);
            delete rq;
        }
        else
            break;
    }
}
#endif // X_YACL





static int YACLErrHandler (Display* d, XErrorEvent* e)
{
#if defined(DEBUG)
    cout << "YACLErrHandler called" << endl;
#endif
    if (_DefaultErrorHandler)
        (*_DefaultErrorHandler) (d, e);
    return 0;
}

short UI_Controller::Initialize ( int& argc, char *argv[] )
{
    _DefaultErrorHandler = XSetErrorHandler (&YACLErrHandler);
#if defined(__X_MOTIF__)
    _rootshell = XtVaAppInitialize
        (&_YACLXAppContext, YACLApp()->AppClass(), NULL, 0,
         &argc, argv, NULL, NULL);
    _display = XtDisplay (_rootshell);
    Arg args [1];
    short argn = 0;
    XtSetArg (args [argn], XmNdeleteResponse, XmDO_NOTHING); argn++;
    XtSetValues (_rootshell, args, argn);
        // Do not destroy the shell widget in response to user
        // requests; the library will take care of it.
#endif
    
//     defaultTrans = XtParseTranslationTable (_defaultTranslations);
//     XtAppAddActions (_YACLXAppContext, actionsTable, XtNumber
//                      (actionsTable));
#ifdef DEBUG
    XSynchronize (AppDisplay (), TRUE); // DEBUG only!!
#endif

#if defined(__X_MOTIF__) && !defined(NO_EDITRES_COMPAT)
    XtAddEventHandler (_rootshell, (EventMask) 0, True,
                       (XtEventHandler) _XEditResCheckMessages,
                       NULL);
#endif

#if defined(__X_YACL__)
    _nextTimerId = 0;
    gettimeofday (&TimeAtStart, NULL);
#endif
    return 1;
}



#if defined(__X_YACL__)

void UI_Controller::_MakeXInterface (const UI_Event& e)
{
    UI_VisualObject* origin = e.Origin ();
    if (!origin)
        return;
//     cout << "Making interface for " << origin->InstanceName() << " shape "
//          << origin->Shape() << endl; // DEBUG
    bool b = origin->MakeVisualElement ();
    if (!b) {
        origin->_PrivateInitialize ();
        origin->Initialize ();
        return;
    }
    Register (origin);
    origin->_created = TRUE; // Another hack to force the initial paint event
    origin->_PrivateInitialize ();

    UI_WindowClass wClass  = origin->WindowClass();
    if (wClass == YACLComposite) {
        origin->_hasBeenInited = FALSE;
        // The reason for using  _hasBeenInited is to ensure that
        // a Composite's Initialize is called only after it is visible
        // on the screen, so that graphics operations on it are
        // permissible in the Initialize method.
    }
    else
        origin->Initialize ();
}

#endif






#if defined(__X_MOTIF__)
void UI_Controller::RealizeWidget (UI_ViewHandle w)
{
    CL_GenericSequence widgets;
    Widget x = w;
    while (w && !XtIsRealized (w)) {
        widgets.Add (w);
        x = w;
        w = XtParent(w);
    }
    if (x && !XtIsRealized (x)) {
        XtRealizeWidget (x);
        for (long i = 0; i < widgets.Size(); i++) {
            UI_CompositeVObject* v =  (UI_CompositeVObject*)
                _shellMap[(long) widgets(i)];
            if (v)
                v->Realized();
        }
    }
}


bool UI_Controller::_ChildToBeCreated (UI_VisualObject* obj)
{
    for (long ii = _eventQueue.Size()-1; ii >= 0; ii--) {
        UI_Event* evt = (UI_Event*) _eventQueue[ii];
        if (evt && evt->Type() == Event_MakeInterface) {
            UI_VisualObject* v = evt->Origin();
            if (v && (v->Parent() == obj || v->Parent() == obj->Parent())
                  && (v->WindowClass() != xmMainWindowWidgetClass))
                return TRUE;
        }
    }
    return FALSE;
}



void UI_Controller::_InitializeUninitedObjs ()
{
    CL_ObjectSetIterator itr (_uninitedObjs);
    while (itr.More()) {
        UI_VisualObject* v = (UI_VisualObject*) itr.Next();
        v->_created = TRUE; 
        v->_PrivateInitialize ();
        // The following hack is needed because I don't get expose
        // events for  button groups. Don't know why I don't get them.
        // ------------ BEGIN HACK -----------------
        Widget w = v->_xwidget;
    if (!w) continue; // Perhaps some VisualObjects have no widgets
        WidgetClass wClass  = XtClass (w);
        Widget      parentW = XtParent (w);
        if (wClass == yCompositeWidgetClass &&
            XtClass (parentW) == xmMainWindowWidgetClass) {
            v->_hasBeenInited = FALSE;
            // The reason for using  _hasBeenInited is to ensure that
            // a Composite's Initialize is called only after it is visible
            // on the screen, so that graphics operations on it are
            // permissible in the Initialize method.
        }
        else
            v->Initialize ();
        // ------------- END HACK -----------------
//        cout << "Initializing " << v->InstanceName() << " shape "
//             << v->Shape() << endl; // DEBUG
    }
    _uninitedObjs.MakeEmpty();
}


void UI_Controller::_MakeXInterface (const UI_Event& e)
{
    UI_VisualObject* origin = e.Origin ();
    if (!origin)
        return;
//    cout << "Making interface for " << origin->InstanceName() << " shape "
//         << origin->Shape() << endl; // DEBUG
    bool b = origin->MakeVisualElement ();
    if (!b) {
        origin->_PrivateInitialize ();
        origin->Initialize ();
        // The following hack is needed to take care of cases where all
        // children of a VObjCollection have a null visual element, e.g., if
        // all children are 3dLabel objects.
        UI_VisualObject* parent = origin->Parent();
        if (parent && !_ChildToBeCreated (parent)) {
//            cout << "Realizing1 " << parent->InstanceName() << endl; // DEBUG
            RealizeWidget (parent->_xwidget);
            _InitializeUninitedObjs();
        }
        return;
    }
    Register (origin);

    // If it's a main window (Composite or Dialog), then add its shell to
    // the shellMap, and give it  an event handler for editres
    if (origin->WindowClass() == xmMainWindowWidgetClass) {
        UI_CompositeVObject* comp = (UI_CompositeVObject*) origin;
        Widget shell = comp->ShellHandle();
        _shellMap.Add ((ulong) shell, origin);
//             XtAddEventHandler (shell, StructureNotifyMask, FALSE,
//                                evtHandler, this);
//             XtAddEventHandler (comp->MainWindowHandle(),
//                                StructureNotifyMask, FALSE,
//                                evtHandler, this);
#ifndef NO_EDITRES_COMPAT
        XtAddEventHandler (shell, (EventMask) 0, True,
                           (XtEventHandler) _XEditResCheckMessages,
                           NULL);
#endif
    }

    // Now we must realize the widget, but only if it doesn't have any
    // children whose MakeInterface events are pending. So we look
    // in the event queue:
    Widget w = origin->_xwidget;
    if (!_ChildToBeCreated (origin)) {
        // Go up the widget tree to the deepest unrealized widget, and
        // realize it
//       cout << "Realizing2 " << origin->InstanceName() << " (title '" <<
//           origin->Title() << "')" << endl; // DEBUG
        RealizeWidget (origin->ViewHandle());
        _uninitedObjs.Add (origin); // Just to make the loop below run thru
                                    // all uninited objects
        _InitializeUninitedObjs();
    }
    else
        _uninitedObjs.Add (origin);
    if (!w)
        return;
    XtEventHandler evtHandler = &UI_Controller::XEventHandler;
    WidgetClass wClass  = XtClass (w);
    if (wClass != xmLabelWidgetClass) {
        ulong mask = PointerMotionMask | FocusChangeMask /* | ExposureMask */;
        if (wClass == yCompositeWidgetClass && XtParent (w) != NULL)
            mask |= ExposureMask;
        // Without ExposureMask, the initial expose event is not sent to a
//         // widget that is a child of a composite.
//         if (_IsTopWindow (w))
//             mask |= StructureNotifyMask;
        XtAddEventHandler (w, mask, FALSE, evtHandler, this);
    }
}

#endif // __X_MOTIF__





// void UI_Controller::LButtonDouble (struct _WidgetRec* w,
//                                    XEvent* xevt, String*, unsigned int*)
// {
//     cout << "LbuttonDouble called\n";
// }
// 
// 
// void UI_Controller::MButtonDouble (struct _WidgetRec* w,
//                                    XEvent* xevt, String*, unsigned int*)
// {
//     cout << "MbuttonDouble called\n";
// }
// 
// void UI_Controller::RButtonDouble (struct _WidgetRec* w,
//                                    XEvent* xevt, String*, unsigned int*)
// {
//     cout << "RbuttonDouble called\n";
// }

