
!include ../control/watcomc.ctl


.BEFORE:
    set WATCOM_CPPOPTS=$(CCOPTS) $(USE_CTL3D)
    set WATCOM_CCOPTS=$(CCOPTS)

    
LIBRARY = $(UI)

# ------------------------ Names of files --------------------------

OBJ01  = 3dlabel.obj  applic.obj   arc.obj      bitmap.obj    bmpbtn.obj
OBJ02  = bmpushbn.obj bmtglbtn.obj brush.obj    btngroup.obj
OBJ03  = canvas.obj   chord.obj    cntroler.obj color.obj
OBJ04  = combobox.obj composit.obj containr.obj cursor.obj
OBJ05  = dateedit.obj dialog.obj   dsinmem.obj  dsplrsrc.obj
OBJ06  = dsplsurf.obj dwgsurf.obj  ellipse.obj  event.obj
OBJ07  = font.obj     fontdesc.obj graphic.obj  grutils.obj
OBJ08  = interval.obj label.obj    lineseg.obj  mainprog.obj
OBJ09  = menu.obj     monthcal.obj numedit.obj  orbtngrp.obj
OBJ10  = pen.obj      piewedge.obj point.obj    pswdedit.obj
OBJ11  = pushbtn.obj  rectangl.obj scrolbar.obj scrolwin.obj  shadolin.obj
OBJ12  = shadorec.obj shadotrg.obj simple.obj   statui.obj    stddlg.obj
OBJ13  = stencil.obj  stred.obj    strseq.obj   strview.obj
OBJ14  = textedit.obj timer.obj    toglbtn.obj  vector.obj
OBJ15  = visualob.obj vobjcoll.obj xrbtngrp.obj xrtglbtn.obj


!ifeq YACLPLATFORM OS2
PLATFORM_OBJS = os2evt.obj  printjob.obj
!else ifeq YACLPLATFORM WINDOWS
PLATFORM_OBJ1 = copy.obj dibutil.obj errors.obj
PLATFORM_OBJ2 = file.obj mdi.obj     printjob.obj winevt.obj
PLATFORM_OBJS = $(PLATFORM_OBJ1) $(PLATFORM_OBJ2)
!else ifeq YACLPLATFORM WIN32
PLATFORM_OBJ1 = copy.obj dibutil.obj errors.obj
PLATFORM_OBJ2 = file.obj mdi.obj     printjob.obj winevt.obj
PLATFORM_OBJS = $(PLATFORM_OBJ1) $(PLATFORM_OBJ2)
!endif

OBJECTS1 = $(OBJ01) $(OBJ02) $(OBJ03) $(OBJ04) $(OBJ05) $(OBJ06) $(OBJ07)
OBJECTS2 = $(OBJ08) $(OBJ09) $(OBJ10) $(OBJ11) $(OBJ12) $(OBJ13) $(OBJ14)
OBJECTS3 = $(OBJ15)

OBJECTS  = $(OBJECTS1) $(OBJECTS2) $(OBJECTS3) $(PLATFORM_OBJS)



        
all: $(YACLLIB)\$(LIBRARY).lib .SYMBOLIC



$(YACLLIB)\$(LIBRARY).lib:  $(OBJECTS)  libfile.tmp  .SYMBOLIC
	$(LIBR) /b /p=96 $(YACLLIB)\$(LIBRARY) @libfile.tmp
	$(COPY) mainprog.obj $(YACLLIB)
        -del libfile.tmp


libfile.tmp: .SYMBOLIC
  %create libfile.tmp
  @for %i in ($(OBJECTS)) do @%append libfile.tmp -+%i

  

# ---------------------- Compilation rules -----------------------


!ifeq YACLPLATFORM OS2
stddlg.obj: support/os2/stddlg.cxx
  $(CC) @WATCOM_CPPOPTS support\os2\$*.cxx


os2evt.obj: support/os2/os2evt.cxx
  $(CC) @WATCOM_CPPOPTS support\os2\$*.cxx


!else

stddlg.obj: support/windows/stddlg.cxx
  $(CC) @WATCOM_CPPOPTS support\windows\$*.cxx


winevt.obj: support/windows/winevt.cxx
  $(CC) @WATCOM_CPPOPTS support\windows\$*.cxx

copy.obj: support/windows/copy.c
  $(CCOMP) @WATCOM_CCOPTS support\windows\$*.c


errors.obj: support/windows/errors.c
  $(CCOMP) @WATCOM_CCOPTS support\windows\$*.c


dibutil.obj: support/windows/dibutil.c
  $(CCOMP) @WATCOM_CCOPTS support\windows\$*.c


file.obj: support/windows/file.c
  $(CCOMP) @WATCOM_CCOPTS support\windows\$*.c


!endif




.cxx.obj: .SYMBOLIC
	$(CC) @WATCOM_CPPOPTS $*.cxx

                
.c.obj: .SYMBOLIC
	$(CCOMP) @WATCOM_CCOPTS $*.c

        
# ------------------ Other targets ---------------------------




clean: .SYMBOLIC
	-del *.obj
	-del $(YACLLIB)\$(LIBRARY).lib
	-del $(YACLLIB)\$(LIBRARY).bak

