



#ifndef _vobjcoll_h_ /* Fri Nov 25 12:49:45 1994 */
#define _vobjcoll_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/visualob.h"
#include "ui/viewdesc.h"

#include "base/iterator.h"

// VObjCollection is an abstract class representing a collection of
// VisualObjects. Its {\tt MakeVisualElement} method creates a default
// window, and other VisualObjects may be created as its children. Any
// VisualObject that has VisualObjects as children must be a VObjCollection
// (or derived from it).
//
// The primary purpose of this class is the  ability to manage children. It
// provides the {\tt operator[\,]} for accessing children by view id. The
// VObjCollIterator class allows iteration over all the children of a
// VObjCollection.
//
// The model of the VObjCollection is an IntPtrMap that maps view id's to
// Object pointers. Each entry in this Map contains the view id of a
// child as key and a pointer to the child's model as the corresponding
// value. The VObjCollection does not own the models of the children; model
// ownership of the children is determined by the classes of the individual
// children and how they were created.

class YACL_UI UI_VObjCollection: public UI_VisualObject {

public:
    // ------------------- View-related methods ---------------
    
    virtual bool Enable ();
    // Allow view to capture events. This overrides the inherited method;
    // the overriding code enables all descendants.

    virtual bool Disable ();
    // Prevent view from capturing events. This overrides the inherited
    // method; the overriding code disables all descendants.

    virtual void MakeInvisible ();
    // This overrides the inherited method with code that makes all
    // descendants invisible.
    
    virtual void MakeVisible ();
    // This overrides the inherited method with code that makes all
    // descendants visible.

    virtual UI_VisualObject* operator [] (UI_ViewID id);
    // Return a pointer to the child with the given view id. The return value
    // is NULL if there is no such child.
    
    long ChildCount ();
    // Return the number of children of this collection.

    bool Contains (UI_ViewID id);
    // Test whether the object with view id {\tt id} is a child of this
    // collection.

    virtual bool CompressPaintEvents () {return FALSE;};
    // The Controller uses this method to ask this VisualObject whether
    // Paint events to it should be compressed. Ordinarily, under Windows
    // and OS/2, every time a child is created for this VObjCollection, the
    // latter is sent a Paint event. If {\tt CompressPaintEvents} returns
    // TRUE, the Controller inhibits sending all but the last of these
    // events.
    
    virtual UI_WindowClass WindowClass () const;
    // [For YACL internal use only] return the platform-specific window
    // class for the visual element of this object.

    const char* ClassName() const { return "UI_VObjCollection";};



protected:
    
    // ---------------------- Construction ----------------------------

    UI_VObjCollection (UI_VObjCollection* parent,
                       const UI_Rectangle& shape, UI_ViewID id = -1);
    // Constructor: Create a VObjCollection with the given parent, shape and
    // view id. The constructor is protected, since this is an abstract
    // class anyway  and cannot be instantiated directly.

    ~UI_VObjCollection ();
    // Destructor.

    virtual bool MakeVisualElement () = 0;
    // This method is pure virtual, but has a default implementation.


    virtual bool HandleChildEvent (const UI_Event&) {return FALSE;};
    // This is a hook for inspecting and processing events originating
    // in any of the children and passed up to this
    // VObjCollection. The default implementation simply returns
    // FALSE. It may be overridden in derived classes for custom event
    // handling.
    
    bool DestroyVisualElement ();

    bool _ModelChanged ();

    void _PrivateInitialize();


    friend class YACL_UI UI_Controller;
    friend class YACL_UI UI_VObjCollIterator;

    // 
    // Instance Variables:
    // 

    CL_IntPtrMap       _objMap;


    virtual void AddChild    (UI_VisualObject* child);
    // [YACL internal use only] Called when a new child has been created.

    virtual UI_VisualObject* RemoveChild (UI_VisualObject* view);
    // [YACL internal use only] Called when a child is being destroyed.

public:
    bool PropagateFontChange(UI_VisualObject* initiator);
    // [YACL internal use only] Used for propagating the Font down the view
    // tree.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    virtual long WindowProcHook (HWND h, UINT msg, WPARAM wParam, LPARAM
                                 lParam);
    // [MS Windows specific, YACL internal use only] Used for processing MS
    // Windows messages that don't directly correspond to YACL events.

    virtual LRESULT DefaultProc (HWND h, UINT msg, WPARAM wParam,
                                 LPARAM lParam);
    // [MS Windows specific, YACL internal use only] Default processing.
    
#endif
    
private:
    bool _PrivateHandleChildEvent (UI_Event& e);
    // The real child event gateway.
    
};






// VObjCollIterator is a means of iterating over all the children of a
// VObjCollection. This object can only be created on a VObjCollection
// {\it after\/} the latter is initialized and ready for display.
//
// Warning: do not add or remove children from a VObjCollection while an
// iterator is active.


class YACL_UI UI_VObjCollIterator {

public:
    UI_VObjCollIterator (UI_VObjCollection& v);
    // Construct an iterator on the VObjCollection v.

    void Reset ();
    // Reset the iterator to the beginning.

    UI_VisualObject* Next ();
    // Return a pointer to the next child of our collection. Return NULL if
    // there are no more children.

    bool More ();
    
protected:
    CL_IntPtrMapIterator _itr;

};


#endif /* _vobjcoll_h_ */
