




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif


#include "base/binding.h"
#include "base/clntset.h"

#include "ui/vobjcoll.h"
#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/composit.h"


#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#elif defined (__X_MOTIF__)  || defined(__X_YACL__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    if defined(__X_MOTIF__)
#        include <Xm/Xm.h>
#        include <Xm/BulletinB.h>
#    endif
#endif



UI_VObjCollection::UI_VObjCollection (UI_VObjCollection* parent,
                                      const UI_Rectangle& shape,
                                      UI_ViewID id)
: UI_VisualObject(parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = WS_CHILD | WS_CLIPCHILDREN;
#elif defined(__OS2__)
    _style = WS_VISIBLE;
#endif
}


bool UI_VObjCollection::Enable ()
{
    if (!UI_VisualObject::Enable())
        return FALSE;
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->Enable();
    return TRUE; 
}



bool UI_VObjCollection::Disable ()
{
    UI_VisualObject::Disable();
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->Disable();
    return TRUE; // ??
}



void UI_VObjCollection::MakeInvisible ()
{
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->MakeInvisible();
    UI_VisualObject::MakeInvisible ();
}



void UI_VObjCollection::MakeVisible ()
{
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->MakeVisible();
    UI_VisualObject::MakeVisible ();
}



UI_VisualObject* UI_VObjCollection::operator [] (UI_ViewID id)
{
    return (UI_VisualObject*) _objMap[id];
}



long UI_VObjCollection::ChildCount ()
{
    return _objMap.Size();
}




bool UI_VObjCollection::Contains (UI_ViewID id)
{
    return _objMap.IncludesKey (id);
}






UI_VObjCollection::~UI_VObjCollection ()
{
}

    

UI_WindowClass UI_VObjCollection::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_YACL__)
    return YACLComposite;
#elif defined(__X_MOTIF__)
    return xmBulletinBoardWidgetClass;
#endif
}


bool UI_VObjCollection::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) 
    return UI_VisualObject::MakeVisualElement ();

#elif defined(__OS2__) 
    return UI_VisualObject::MakeVisualElement ();
#elif  defined(__X_YACL__)
    return UI_VisualObject::MakeVisualElement ();
#elif defined(__X_MOTIF__)

    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources

    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString,  title); argn++;
    XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
    XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    // XtManageChild (_xwidget);
    // XtSetValues (_xwidget, arg, argn);

    XmStringFree (title);
    return TRUE;
#endif
}



bool UI_VObjCollection::_PrivateHandleChildEvent (UI_Event& e)
{
    bool b = HandleChildEvent (e);
    bool p = TRUE;
    if (_eventDependents) {
        CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[e.Type()];
        if (set)
            p = set->Permits (e);
    }
    return b || !p;
}




bool UI_VObjCollection::DestroyVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0 && !CreatedViaResource()) {
        DestroyWindow (_handle);
        return TRUE;
    }
#elif defined(__X_MOTIF__)
    if ( _xwidget ) {
        XtUnmanageChild (_xwidget);
        XtDestroyWidget (_xwidget);
        _xwidget = NULL;
        return TRUE;
    }
#endif
    return FALSE;
}


typedef CL_Binding0<UI_VObjCollection> VObjCollBind;


#if defined(__GNUC__)
template class CL_Binding0 <UI_VObjCollection>;
#elif defined(_MSC_VER)
template CL_Binding0 <UI_VObjCollection>;
#endif


bool UI_VObjCollection::_ModelChanged()
{
    return UI_VisualObject::_ModelChanged();
}

void UI_VObjCollection::_PrivateInitialize()
{
    UI_VisualObject::_PrivateInitialize();
    if (_model) {
        VObjCollBind b (this, &UI_VObjCollection::_ModelChanged);
        _model->AddDependent (b);
    }
}



void UI_VObjCollection::AddChild (UI_VisualObject* child)
{
    if (child && child->ViewID() > 0)
        _objMap.Add (child->ViewID(), child);
}


UI_VisualObject* UI_VObjCollection::RemoveChild (UI_VisualObject* view)
{
    if (!view)
        return NULL;
    UI_ViewID childID = view->ViewID();
    if (childID > 0) {
        CL_IntPtrAssoc assoc = _objMap.Remove (childID);
        return (UI_VisualObject*) assoc.value;
    }
    return NULL;
}

bool UI_VObjCollection::PropagateFontChange (UI_VisualObject* initiator)
{
    if (!UI_VisualObject::PropagateFontChange (initiator))
        return FALSE;
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        ((UI_VisualObject*) assoc.value)->PropagateFontChange (initiator);
    }
    return TRUE;
}





// ----------------------- UI_VObjCollIterator methods ------------------


UI_VObjCollIterator::UI_VObjCollIterator (UI_VObjCollection& v)
: _itr (v._objMap)
{
    _itr.Reset();
}




void UI_VObjCollIterator::Reset ()
{
    _itr.Reset();
}



bool UI_VObjCollIterator::More ()
{
    return _itr.More();
}


UI_VisualObject* UI_VObjCollIterator::Next ()
{
    return (UI_VisualObject*) _itr.Next().value;
}



#if defined(__MS_WINDOWS__) || defined (__MS_WIN32__)
#include <windowsx.h>

#    if defined(USE_CTL3D)
#        include <ctl3d.h>
#    endif

#if !defined(GET_WM_HSCROLL_HWND)
#define GET_WM_HSCROLL_HWND(wp, lp) ((HWND)  HIWORD(lp))
#endif
#if !defined(GET_WM_HSCROLL_CODE)
#define GET_WM_HSCROLL_CODE(wp, lp) (wp)
#endif
#if !defined(GET_WM_HSCROLL_POS)
#define GET_WM_HSCROLL_POS(wp, lp) ((long)LOWORD(lp))
#endif
#if !defined(GET_WM_COMMAND_HWND)
#define GET_WM_COMMAND_HWND(wp, lp) ((HWND)  LOWORD(lp))
#endif
#if !defined(GET_WM_COMMAND_CMD)
#define GET_WM_COMMAND_CMD(wp, lp) ((long)  HIWORD(lp))
#endif
#if !defined(GET_WM_MENUSELECT_CMD)
#define GET_WM_MENUSELECT_CMD(wp, lp)               (wp)
#define GET_WM_MENUSELECT_FLAGS(wp, lp)             LOWORD(lp)
#define GET_WM_MENUSELECT_HMENU(wp, lp)             (HMENU)HIWORD(lp)
#endif

long UI_VObjCollection::WindowProcHook (HWND hWnd, UINT message, WPARAM wParam,
                                        LPARAM lParam)
{
    long retVal = 0;
    switch (message) {
    case WM_GETMINMAXINFO: {
        UI_CompositeVObject* v = (UI_CompositeVObject*) this;
        MINMAXINFO* mmi = (MINMAXINFO*) lParam;
        mmi->ptMinTrackSize.x = v->MinWidth();
        mmi->ptMinTrackSize.y = v->MinHeight();
        mmi->ptMaxTrackSize.x = v->MaxWidth();
        mmi->ptMaxTrackSize.y = v->MaxHeight();
        break;
    }

#if defined(USE_CTL3D)
#if defined(__MS_WINDOWS__)
    case WM_SETTEXT:
#endif
    case WM_NCPAINT:
    case WM_NCACTIVATE:
        if (!Has3DLook()) 
            retVal = DefaultProc (hWnd, message, wParam, lParam);
        else {
            SetWindowLong (hWnd, DWL_MSGRESULT,
                           Ctl3dDlgFramePaint (hWnd, message, wParam, lParam));
            retVal = 1;
        }
        break;
        
        
#if defined(__MS_WIN32__)
    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
    case WM_CTLCOLORSCROLLBAR:
    case WM_CTLCOLORMSGBOX:
    case WM_CTLCOLORSTATIC:
    case WM_CTLCOLOREDIT:
    case WM_CTLCOLORLISTBOX:
#else
    case WM_CTLCOLOR:
#endif
    {
#if defined(__MS_WIN32__)
        UI_VisualObject* v = (*_Controller)[(UI_ViewHandle) lParam];
#else
        UI_VisualObject* v = (*_Controller)[(UI_ViewHandle) LOWORD(lParam)];
#endif
        
        if (v && v->FgColorChanged())
            SetTextColor ((HDC) wParam, v->Foreground().NativeForm());
        if (v && v->BgColorChanged()) {
            UI_Color c = v->Background();
            UI_NativeColorRep clr = c.NativeForm();
            SetBkColor ((HDC) wParam, clr);
            CL_PtrIntMap brushPool = _Application->BrushPool(); 
            HBRUSH brush = (HBRUSH) brushPool [&c];
            if (!brush) {
                brush = CreateSolidBrush (clr);
                if (!brush)
                    brush = (HBRUSH) WHITE_BRUSH; // Failed creation
                else
                    brushPool.Add (new UI_Color(c), (long) brush);
            }
            retVal = (LRESULT) brush;
            break;
        }
        if (!Has3DLook())
            retVal = DefaultProc (hWnd, message, wParam, lParam);
        else {
            HBRUSH hbr = Ctl3dCtlColorEx  (message, wParam, lParam);
            if (hbr)
                retVal = (LRESULT) hbr;
            else
                retVal = (LRESULT) _Controller->ButtonFaceBrush();
        }
        break;
    }
#endif // CTL3D
    
    case WM_PAINT: {
        retVal = 0;
        break;
    }
        
//     case WM_ERASEBKGND: {
//         RECT rect;
//         GetClientRect (hWnd, &rect);
//         UI_VisualObject* v= (*this)[hWnd];
//         if (!v) {
//             retVal = DefaultProc (hWnd, message, wParam, lParam);
//             break;
//         }
//         HBRUSH brush = CreateSolidBrush (v->Background().NativeForm());
//         // HDC hdc = (HDC) wParam; Can't use this wParam DC: it's already
//         // clipped, and causes weird problems with CTL3D
//         HDC hdc = GetDC (hWnd);
//         FillRect (hdc, &rect, brush);
//         DeleteObject (brush);
//         ReleaseDC (hWnd, hdc);
//         retVal = 1;
//         // Windows sometimes sends ERASEBKGND without a subsequent PAINT
//         // message! the result is the window gets cleared! weird.
//         break;
//     }

    case WM_CLOSE:
        retVal = 0;
        break;
        
    default:
        retVal = DefaultProc (hWnd, message, wParam, lParam);
        break;
    }
    return retVal;
}


LRESULT UI_VObjCollection::DefaultProc (HWND hWnd, UINT msg, WPARAM wParam,
                                        LPARAM lParam)
{
    return DefWindowProc (hWnd, msg, wParam, lParam);
}


#endif
