




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#ifdef __GNUC__
#pragma implementation
#endif

// ---------------------- Include files --------------------------

#include "base/clntset.h"
#include "base/tree.h"

#include "ui/visualob.h"
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/dsplsurf.h"
#include "ui/font.h"
// #include "ui/colormap.h"

#if defined(__X_MOTIF__)  || defined(__X_YACL__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <iostream.h> // DEBUG
#    if defined(__X_MOTIF__)
#        include <X11/Intrinsic.h>
#        include <X11/StringDefs.h>
#        include <Xm/Xm.h>
#        include <Xm/Label.h>
#        include "ui/support/x_motif/ycomp.h"
         const  Dimension   BORDER_WIDTH = 1;
#    else // X_YACL
#        include "ui/support/x_yacl/window.h"
#    endif
#endif

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_VisualObject>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_VisualObject>;
#endif


typedef CL_Binding0<UI_VisualObject> VObjBind;

// --------------- Initializations of static instance variables --------

UI_Controller*  UI_VisualObject::_Controller  = NULL;
UI_Application* UI_VisualObject::_Application = NULL;


//
//  -----------------Constructor---------------------
//

UI_VisualObject::UI_VisualObject
    (UI_VisualObject* parent, 
     const UI_Rectangle& shape, UI_ViewID id, long style)
{
    _shape = shape;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _style = style;
#elif defined (__X_MOTIF__)
    _xwidget = NULL;
    _cursor.AddDependent (VObjBind (this, &UI_VisualObject::_CursorChanged));
#elif defined(__X_YACL__)
    _window = 0;
#endif
    _Init (parent, id);
}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_VisualObject::UI_VisualObject (UI_VObjCollection* parent,
                                  UI_ViewID id, UI_ViewHandle hndl)
{
    _Init (parent, id);
    _id = id;
    long n = GetWindowTextLength (hndl);
    char* buf = NULL;
    if (n) {
        buf = new char[n+1];
        GetWindowText (hndl, buf, n+1);
        _title = buf;
        delete [] buf;
    }
    RECT rec;
    POINT array[2];
    GetWindowRect (hndl, &rec);

    _handle    = hndl;
#if defined(__MS_WIN32__)
    _id        = GetWindowLong    (_handle,GWL_ID);
#else
    _id        = GetWindowWord    (_handle,GWW_ID);
#endif
    _style     = GetWindowLong    (_handle,GWL_STYLE); 
    _visible   = (_style & WS_VISIBLE) ? TRUE : FALSE;
    array[0].x = rec.left;
    array[0].y = rec.top;
    array[1].x = rec.right;
    array[1].y = rec.bottom;
    MapWindowPoints (NULL, parent->ViewHandle(), array, 2);
    UI_Point org (array[0].x, array[0].y);
    UI_Rectangle shp (org, array[1].x - array[0].x, array[1].y - array[0].y);
    _SetShapeRectangle (shp);
}
#endif


void UI_VisualObject::_SetShapeRectangle (const UI_Rectangle& r)
{
     VObjBind b (this, &UI_VisualObject::_ShapeRectChanged);
 
    _shape.RemoveDependent (b);
    _shape = r;
    _shape.AddDependent (b);
}


void UI_VisualObject::_SetTitle (const char* p)
{
     VObjBind b (this, &UI_VisualObject::_TitleChanged);
 
    _title.RemoveDependent (b);
    _title = p;
    _title.AddDependent (b);
}


void UI_VisualObject::_Init (UI_VisualObject* prnt, UI_ViewID idnum)
{
    if (!prnt && _Controller->Root())
        CL_Error::Fatal ("Fatal: Attempt to create two root windows.");
#if defined(__X_MOTIF__)
    _hasBeenInited = FALSE; // Set to TRUE by the Controller (yes, I know,
                            // this is a terrible hack).
#endif
    _borderShown = FALSE;
    _model = NULL;
    _displaySurface = NULL;
    _eventDependents = NULL;
    _bgColorChanged = FALSE;
    _fgColorChanged = FALSE;
#if defined(__OS2__)
    _id = idnum & 0xffff; // OS/2 2.1 does not like long view id's
#else
    _id = idnum;
#endif
    _parent = prnt;
    _isTabStop = TRUE;

    VObjBind bind (this, &UI_VisualObject::_TitleChanged);
    _title.AddDependent (bind);

    VObjBind b2 (this, &UI_VisualObject::_ShapeRectChanged);
    _shape.AddDependent (b2);
    _ownFont = FALSE;
    if (!_parent)
        _font = NULL;
    else
        _font = _parent->_font;

    _created = FALSE;
    _enabled = TRUE; // At construction time, we assume it's enabled

#if defined(__OS2__)
    _handle = 0;
    _borderHandle = 0;
#endif
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _handle = 0;
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
#else
    _visible = TRUE; // By default, we're visible
#endif

#if defined(__X_YACL__)
    // Hard-wire the default background and foreground:
    _bgColor = UI_Color (0.7, 0.7, 0.7);
    _fgColor = UIColor_Black;
    _visualElement = NULL;
#endif
    if (_parent)
        _parent->AddChild (this);
    UI_Event* e1 = new UI_Event (Event_MakeInterface, this, _parent);
    _Controller->AddEvent (e1);
}






UI_VisualObject::~UI_VisualObject () 
{
    if ( _displaySurface )
        delete _displaySurface;
    if ( _ownFont )
        delete _font;
    if (_eventDependents) {
        _eventDependents->DestroyContents();
        delete _eventDependents;
    }
}






//
//  -----------------Query---------------------------
//


UI_WindowClass UI_VisualObject::WindowClass () const
{
    CL_Error::Warning ("UI_VisualObject::WindowClass: derived class %s"
                       " did not override!", ClassName());
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_YACL__)
    return NULL; // For now
#elif defined(__X_MOTIF__)
    return yCompositeWidgetClass;
#endif
}

UI_DisplaySurface& UI_VisualObject::CreateDisplaySurface ()
{
    if (!_displaySurface)
        _displaySurface = new UI_DisplaySurface (this);
    _displaySurface->SetFont (_font);
    return *_displaySurface;
}



void UI_VisualObject::DestroyDisplaySurface()
{
    if ( _displaySurface ) {
        delete _displaySurface;
        _displaySurface = NULL;
    }
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

bool UI_VisualObject::CreatedViaResource ()
{
    return _parent &&  _parent->CreatedViaResource();
}


bool UI_VisualObject::Has3DLook () const
{
    return  _parent ? _parent->Has3DLook() : FALSE;
}

#endif


//
//------------------------Event Handling----------------
//

bool UI_VisualObject::HandleEvent (UI_Event* e)
{
    return ProcessEvent (e);
}



bool UI_VisualObject::ProcessEvent (UI_Event* e)
{
    switch (e->Type()) {
    case Event_LButtonPress:
        return ButtonDown (e->Position(), UIM_Left,
                           e->ShiftKeyPressed(), e->CtrlKeyPressed());

    case Event_LButtonRelease:
        return ButtonUp (e->Position(), UIM_Left);

    case Event_LButtonDblClk:
        return DoubleClick (e->Position(), UIM_Left);


        
    case Event_MButtonPress:
        return ButtonDown (e->Position(), UIM_Middle,
                           e->ShiftKeyPressed(), e->CtrlKeyPressed());

    case Event_MButtonRelease:
        return ButtonUp (e->Position(), UIM_Middle);

    case Event_MButtonDblClk:
        return DoubleClick (e->Position(), UIM_Middle);

        
    case Event_RButtonPress:
        return ButtonDown (e->Position(), UIM_Right,
                           e->ShiftKeyPressed(), e->CtrlKeyPressed());

    case Event_RButtonRelease:
        return ButtonUp (e->Position(), UIM_Right);

    case Event_RButtonDblClk:
        return DoubleClick (e->Position(), UIM_Right);

    case Event_MouseMove:
        return MouseMove (e->Position());

    case Event_ViewEnter:  
        return ViewEnter (e->Position());

    case Event_ViewLeave:
        return ViewLeave (e->Position());

    case Event_GetFocus:
        return GetFocus ();

    case Event_LoseFocus:
        return LoseFocus ();

    case Event_KeyTyped:
        return KeyTyped (e->Key());

    case Event_Paint: {
        if (!_created)
            return FALSE;
        // In this case, the Controller has decoded the event so that
        // e->Shape() contains the invalid rectangle. So:
        return Paint (e->Shape());
    }
        
    case Event_Reconfigure:
        return Reconfigure (e->Shape());

    case Event_ChildCreated:
        return FALSE;

    case Event_Select:
        return Select ();

    case Event_Iconify:
        return Iconify ();

    case Event_Deiconify:
        return Deiconify ();

    case Event_CloseDown:
        CloseDown ();
        return FALSE;
        
    default:
        return FALSE;
    }
}



//
//------------------Mouse Events----------------------
//

bool UI_VisualObject::ButtonDown (const UI_Point&, UI_MouseButton, bool, bool)
{
    return FALSE;
}
    

bool UI_VisualObject::ButtonUp (const UI_Point&, UI_MouseButton)
{
    return FALSE;
}


bool UI_VisualObject::DoubleClick (const UI_Point&, UI_MouseButton)
{
    return FALSE;
}


bool UI_VisualObject::ViewEnter (const UI_Point&)
{
    return FALSE;
}


bool UI_VisualObject::ViewLeave (const UI_Point&)
{
    return FALSE;
}

//
//-------------Key Board Events-----------------
//

bool UI_VisualObject::GetFocus()
{
    return FALSE;
}


bool UI_VisualObject::LoseFocus()
{
    return FALSE;
}

bool UI_VisualObject::KeyTyped (char )
{
    return FALSE;
}


bool UI_VisualObject::MouseMove (const UI_Point& )
{
    return FALSE;
}


bool UI_VisualObject::Reconfigure (const UI_Rectangle&)
{
    return FALSE;
}


void UI_VisualObject::CloseDown ()
{
    // Here we enforce the restriction that if an event action is
    // currently active on a descendant of this VisualObject, we refrain
    // from destroying this object.
    bool doDestroy = TRUE;
    const CL_ObjectSequence& targets   = _Controller->CurrentEventStack();
    long n = targets.Size();
    if (n > 1) {
        // Look below the top of the stack, because the top element will be
        // this VisualObject since it's handling the CloseDown event
        CL_IntegerTree*  viewTree = _Controller->ViewTree();
        for (long i = n-2; i >= 0; i--) {
            UI_VisualObject* v = (UI_VisualObject*) targets[i];
            if (viewTree->IsAncestor ((long) ViewHandle(),
                                      (long) v->ViewHandle())) {
                doDestroy = FALSE;
                break;
            }
        }
                
    }
    if (doDestroy && WantToQuit ())
        _Application->Destroy (this);
}


//
//--------------Display Events---------------------
//



bool UI_VisualObject::_TitleChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        SendMessage (_handle, WM_SETTEXT,  0, (LPARAM) _title.AsPtr());
    }
#elif defined(__OS2__)
    if (_handle > 0) {
        WinSetWindowText (_handle, _title.AsPtr());
    }
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE; // Not yet set up
    XmString xmtitle;
    xmtitle = XmStringCreate ((char*)_title.AsPtr(),
                              XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (_xwidget, XmNlabelString, xmtitle, NULL);
    XmStringFree (xmtitle);
    XmUpdateDisplay (_xwidget);
#elif defined(__X_YACL__)
    //    Invalidate ();
#endif
    return TRUE;
}



void UI_VisualObject::MakeVisible ()
{
    _visible = TRUE;

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0)
        ShowWindow (_handle, SW_SHOW);
#elif defined(__OS2__)
    if (_handle)
        WinShowWindow (_handle, TRUE);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtManageChild   (_xwidget);
#elif defined(__X_YACL__)
    if (_window)
        XMapWindow (_Controller->AppDisplay(), _window);
#endif
}



void UI_VisualObject::MakeInvisible ()
{
    _visible = FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        ShowWindow ((UI_ViewHandle)_handle, SW_HIDE);
#elif defined(__OS2__)
    if (_handle) {
        WinShowWindow (_handle, FALSE);
        WinUpdateWindow    (_handle);
    }        
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtUnmanageChild (_xwidget);
#elif defined(__X_YACL__)
    if (_window)
        XUnmapWindow (_Controller->AppDisplay(), _window);
#endif
}



bool UI_VisualObject::WantToQuit()
{
    return TRUE;
}

//
//---------------other events-----------------
//


bool UI_VisualObject::Paint (const UI_Rectangle& r)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_WindowClass cls = WindowClass();
    if (cls == _YACLWindowClassName || cls == _YACLSimpleClassName)
        _FillWithBgColor (r);
#elif defined(__OS2__)
    UI_WindowClass cls = WindowClass();
    if (cls == _YACLWindowClassName)
        _FillWithBgColor (r);
#endif
    return FALSE;
}

void UI_VisualObject::_FillWithBgColor (const UI_Rectangle& invalidRect)
{
    // This method must be called *only* in response to a PAINT message, and
    // *only* under OS/2 or Windows.
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    HDC hdc = GetDC (_handle);
    RECT rect = invalidRect.AsMSRect();
    if (Has3DLook()) {
        HBRUSH hbr = _Controller->ButtonFaceBrush ();
        FillRect (hdc, &rect, hbr);
    }
    else {
        COLORREF color = _bgColor.NativeForm();
        HBRUSH hbr = CreateSolidBrush (color);
        FillRect (hdc, &rect, hbr);
        DeleteObject (hbr);
    }
    ReleaseDC (_handle, hdc);
#elif defined(__OS2__)
    UI_Event* evt = _Controller->CurrentEvent();
    NativeEventStruct* native = NULL;
    if (evt && ((native = evt->NativeEvent()) != NULL) &&
        native->msg == WM_PAINT) {
        RECTL rect;
        rect.xLeft   = invalidRect.Left();
        rect.yBottom = _shape.Height() - invalidRect.Bottom() - 1;
        rect.xRight  = invalidRect.Right();
        rect.yTop    = _shape.Height() - invalidRect.Top() - 1;
//         CL_Error::Warning ("%s (%s): rect: xL %d yB %d xR %d yT %d\n",
//                            ClassName(), _title.AsPtr(), rect.xLeft,
//                            rect.yBottom, rect.xRight, rect.yTop);//DEBUG
        HPS hps = WinBeginPaint (_handle, (HPS) NULL, &rect);
//         CL_Error::Warning ("rect: xL %d yB %d xR %d yT %d\n", rect.xLeft,
//                            rect.yBottom, rect.xRight, rect.yTop);//DEBUG
        GpiCreateLogColorTable (hps, LCOL_RESET, LCOLF_RGB, 0L, 0L, NULL);
        WinFillRect     (hps, &rect, _bgColor.NativeForm());
        WinEndPaint (hps);
    }
#endif
}

bool UI_VisualObject::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    short x = _shape.Left();
    short y = _shape.Top ();
    short w = _shape.Width();
    short h = _shape.Height();
    const char* label = (_title.Length() > 0) ? _title.AsPtr() : NULL;
    const char* class_name = WindowClass ();
    HINSTANCE hInst = (HINSTANCE) _Application->ProcessId();
    if (!_visible)
        _style &= ~WS_VISIBLE;
    HMENU parentHandle = _parent ? _parent->ViewHandle() : 0;
//     short lowBits = _style & 0x0f;
//     if (lowBits == BS_AUTORADIOBUTTON || lowBits == BS_AUTOCHECKBOX) {
//         if (CL_String (_parent->WindowClass()) == "button") {
//             parentHandle = GetParent (parentHandle);
//             if (_parent) {
//                 UI_Point topLeft = _parent->Shape().Origin();
//                 x += topLeft.XCoord();
//                 y += topLeft.YCoord();
//             }
//         }
//     }
    _handle = CreateWindow (class_name, label, _style, x, y, w, h,
                            parentHandle, (HMENU) _id, (HANDLE) hInst, NULL);
    if (!_handle) {
        CL_Error::Warning
            ("YACL: VisualObject CreateWindow failed:\nClass %s ID %d",
             class_name, _id);
        return FALSE;
    }
    return TRUE;

#elif defined(__OS2__)
    long ht = _YACLWindowHeight (_parent ? _parent->ViewHandle()
                                : HWND_DESKTOP);
    long x = _shape.Left();
    long y = ht - _shape.Top() - _shape.Height();
    long w = _shape.Width();
    long h = _shape.Height();
    const char* label = (_title.Length() > 0) ? _title.AsPtr()
        : (const char*) NULL;
    UI_WindowClass class_name = WindowClass ();
    if (!_visible)
        _style &= ~WS_VISIBLE;
    HWND parentHandle = _parent ? _parent->ViewHandle() : HWND_DESKTOP;
    if (class_name == WC_BUTTON) {
        ushort styleBits = _style & BS_PRIMARYSTYLES;
        if (styleBits == BS_AUTORADIOBUTTON ||
            styleBits == BS_AUTOCHECKBOX) {
            UI_WindowClass pClass = _parent ? _parent->WindowClass() : 0;
            if (pClass == WC_STATIC) {
                // OS/2 PM doesn't like toggle buttons as children of button
                // groups. So we have yet another hack. Oh well...
                parentHandle = _parent->_parent ? _parent->_parent->_handle
                    : HWND_DESKTOP;
                x += _parent->_shape.Left();
                y += _YACLWindowHeight (parentHandle) -
                    _parent->_shape.Bottom ();
            }
        }
    }
    _handle = WinCreateWindow
        (parentHandle, class_name, label, _style,
         x, y, w, h, parentHandle, HWND_BOTTOM, _id, NULL, NULL);
    if (!_handle) {
        UI_Application::PMError ();
        CL_Error::Warning
            ("YACL: VisualObject CreateWindow failed:\nClass %s ID %d",
             class_name, _id);
        return FALSE;
    }
    return TRUE;

#elif defined(__X_MOTIF__)

    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = p ? p->ViewHandle() : (Widget) NULL;

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources

    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    XmStringFree (title);
    return TRUE;
#endif
}


void UI_VisualObject::_PrivateInitialize()
{
    _created = TRUE;
    _Controller->AddEvent (new UI_Event (Event_ChildCreated, this, _parent));
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!_enabled && _handle)
        EnableWindow   (_handle, FALSE);
    if (!_visible && _handle)
        ShowWindow   (_handle, SW_HIDE);
//     if (Has3DLook()) {
//         COLORREF color = GetSysColor (COLOR_BTNFACE);
//         // We're using Ctl3d; otherwise  we would want COLOR_WINDOW
//         _bgColor = UI_Color (GetRValue (color)/((float) UI_MAXCOLORS),
//                              GetGValue (color)/((float) UI_MAXCOLORS),
//                              GetBValue (color)/((float) UI_MAXCOLORS));
//     }
//     else
//         _bgColor = UIColor_White;
    UI_WindowClass cls = WindowClass();
    if (_handle && lstrcmp (cls, "menu") != 0 && lstrlen (cls) != 0) {
        // Not a menu or menu item
        RECT msrec;
        GetClientRect (_handle, &msrec);
        POINT ms_pt;
        ms_pt.x = ms_pt.y = 0;
        HWND parentHandle = _parent ? _parent->_handle : GetDesktopWindow();
        MapWindowPoints (_handle, parentHandle, &ms_pt, 1);
        // If this is a child window, then it seems to give me width and
        // height off by 1. It gives me the correct values for non-child
        // windows. Yet Another Windows Bug! :-(
        short pad = _style & WS_CHILD ? 0 : 1;
        UI_Rectangle rec (ms_pt.x, ms_pt.y, msrec.right - msrec.left + pad,
	                  msrec.bottom - msrec.top + pad);
        _SetShapeRectangle (rec);
    }
#elif defined(__OS2__)
    if (!_enabled && _handle)
        WinEnableWindow   (_handle, FALSE);
    if (!_visible && _handle)
        WinShowWindow   (_handle, FALSE);
    _DoShowBorder (_borderShown);
#elif defined(__X_YACL__)
    if (!_window)
        return;
    Display* dp = _Controller->AppDisplay();
    if (_visible)
        XMapWindow (dp, _window);
    if (!_font) {
        if (!_parent) {
            _font = new UI_Font (this);
            _ownFont = TRUE;
        }
        else
            _font = _parent->_font;
    }
#elif defined(__X_MOTIF__)
    if (_xwidget) {
        if (WindowClass() != NULL) { // Don't do this for menu items
            if (_visible)
                XtManageChild (_xwidget);
            if (_borderShown)
                XtVaSetValues (_xwidget, XmNborderWidth, BORDER_WIDTH, NULL);
        }
        if (!_enabled)
            XtSetSensitive (_xwidget, FALSE);
    }
#endif
    if (_bgColorChanged)
        _DoSetBackground ();
    if (_fgColorChanged)
        _DoSetForeground ();
    if (_font) {
        _SetPlatformFont (ViewHandle());
        if (_ownFont) {
            VObjBind b (this, &UI_VisualObject::_FontChanged);
            _font->AddDependent (b);
        }
    }
}



bool UI_VisualObject::DestroyVisualElement()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle && !_parent->CreatedViaResource()) {
        DestroyWindow (_handle);
        return TRUE;
    }
#elif defined(__X_MOTIF__)
    if ( _xwidget ) {
        XtUnmanageChild (_xwidget);
        XtDestroyWidget (_xwidget);
        _xwidget = NULL;
        return TRUE;
    }
#elif defined(__OS2__)
    if (_handle)
        WinDestroyWindow (_handle);
#elif defined(__X_YACL__)
    if (_visualElement)
        delete _visualElement;
#endif
    return TRUE;
}


bool UI_VisualObject::Enable ()
{
    _enabled = TRUE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return _handle ? EnableWindow   (_handle, TRUE) : TRUE;
#elif defined(__OS2__)
    return _handle ? WinEnableWindow   (_handle, TRUE) : TRUE;
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtSetSensitive (_xwidget, TRUE);
    return TRUE;
#endif

}



bool UI_VisualObject::Disable()
{
    _enabled = FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return _handle ? EnableWindow (_handle, FALSE) : TRUE;
#elif defined(__OS2__)
    return _handle ? WinEnableWindow   (_handle, FALSE) : TRUE;
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtSetSensitive (_xwidget, FALSE);
    return TRUE;

#endif
}


void UI_VisualObject::Invalidate ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        InvalidateRect (_handle, NULL, TRUE);
#elif defined(__OS2__)
    if (_handle) {
        RECTL rect;
        WinQueryWindowRect (_handle, &rect);
        WinInvalidateRect  (_handle, &rect, TRUE);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget && XtIsRealized (_xwidget)) {
//         XClearArea (XtDisplay (_xwidget), XtWindow (_xwidget),
//                     0, 0, 0, 0, TRUE);
//         XmUpdateDisplay (_xwidget);
        _Controller->AddEvent (new UI_Event (Event_Paint, this, this));
    }
#elif defined(__X_YACL__)
    if (_window) {
        XClearArea (_Controller->AppDisplay(), _window,
                    0, 0, 0, 0, TRUE);
    }
#else
    NotImplemented ("Invalidate");
#endif
}


#if defined(__OS2__)
static RECTL _OS2Rect (UI_ViewHandle h, const UI_Rectangle& r)
{
    RECTL windowRect = {0, 0, 0, 0};
    if (!h || !WinQueryWindowRect (h, &windowRect))
        return windowRect;
    long ht = windowRect.yTop - windowRect.yBottom + 1;
    RECTL ret;
    ret.xLeft   = r.Left();
    ret.yBottom = ht - r.Top() - r.Height();
    ret.xRight  = ret.xLeft + r.Width() - 1;
    ret.yTop    = ret.yBottom + r.Height() - 1;
    return ret;
}
#endif


void UI_VisualObject::Invalidate (const UI_Rectangle& r)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        RECT rect = r.AsMSRect ();
        InvalidateRect (_handle, &rect, TRUE);
    }
#elif defined(__OS2__)
    if (_handle) {
        RECTL rect = _OS2Rect (_handle, r);
        WinInvalidateRect  (_handle, &rect, TRUE);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget && XtIsRealized (_xwidget)) {
        XClearArea (XtDisplay (_xwidget), XtWindow (_xwidget),
                    r.Left(), r.Top(), r.Width(), r.Height(), TRUE);
    }
#else
    NotImplemented ("Invalidate");
#endif
}


#if defined(__X_MOTIF__)  || defined(__X_YACL__)
CL_String UI_VisualObject::InstanceName()
{
    if (!_instanceName.Size())
        _instanceName = _Application->InstanceName (this);
    return _instanceName;
}
#endif



#if defined(__OS2__)
static UI_ViewHandle MenuBarHandle (UI_ViewHandle vObjHandle)
{
    if (!vObjHandle)
        return 0;
    HWND hParent = WinQueryWindow (vObjHandle, QW_PARENT);
    if (!hParent)
        return 0;
    char buf[20] = {20*0};
    WinQueryClassName (hParent, sizeof buf, buf);
    return 0;
}
#endif



bool UI_VisualObject::_ShapeRectChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!_handle)
        return TRUE;
    RECT rect = _shape.AsMSRect ();
    // Do we have a menu?
    bool haveMenu = (_style & WS_CHILD) ? FALSE : (GetMenu (_handle) != NULL);
    AdjustWindowRect (&rect, _style, haveMenu);
    if (Has3DLook ()) 
        MoveWindow (_handle, rect.left-1, rect.top-1,
                    rect.right-rect.left+3, rect.bottom-rect.top+3, TRUE);
    else
        MoveWindow (_handle, rect.left, rect.top,
                    rect.right-rect.left+1, rect.bottom-rect.top+1, TRUE);
    // Maybe this is because need to correct for Ctl3d problems. I'm not sure
    // why Windows needs co-ordinates fixed up like this.
    return TRUE;

#elif defined(__OS2__)
    if (!_handle)
        return TRUE;
    long ht = _YACLWindowHeight (_parent ? _parent->ViewHandle()
                                : HWND_DESKTOP);
    long y = ht - _shape.Top() - _shape.Height();

    // Now adjust if the parent has a menu bar
    UI_ViewHandle menuBarHandle = MenuBarHandle (_parent->ViewHandle());
    if (menuBarHandle) {
        RECTL rect;
        WinQueryWindowRect (menuBarHandle, &rect);
        y -= rect.yTop - rect.yBottom;
    }

    // Finally, set the window position
    WinSetWindowPos (_handle, HWND_TOP, _shape.Left(), y,
                     _shape.Width(), _shape.Height(),
                     SWP_SIZE | SWP_MOVE);
    if (_borderHandle) {
        WinSetWindowPos
            (_borderHandle, HWND_TOP, _shape.Left() - 1, y - 1,
             _shape.Width()+2, _shape.Height()+2, SWP_MOVE);
        if (_borderShown)
            WinShowWindow (_borderHandle, TRUE);
    }
    return TRUE;
#elif defined(__X_MOTIF__)
    if (!_xwidget || !WindowClass()) // Don't do this for menu classes
        return TRUE;
    // This little hack with Unmanage is needed to force Motif widgets to
    // resize themselves. Weird.
    XtUnmanageChild (_xwidget);
    Position  x = _shape.Origin().XCoord();
    Position  y = _shape.Origin().YCoord();
    Dimension w = _shape.Width();
    Dimension h = _shape.Height();
    XtVaSetValues (_xwidget, XtNx, x, XtNy, y, XtNwidth, w,
                   XtNheight, h, NULL);
    if (_visible)
        XtManageChild (_xwidget);
    return TRUE;
#elif defined(__X_YACL__)
    if (_window) {
        Display* d = _Controller->AppDisplay();
        XMoveResizeWindow   (d, _window, _shape.Left(),  _shape.Top(),
                             _shape.Width(), _shape.Height());
        return TRUE;
    }
    return FALSE;
#endif
}


bool UI_VisualObject::TakeFocus ()
{
    UI_ViewHandle h = ViewHandle ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (h) 
        return (SetFocus (h) != (HWND) 0) ? TRUE : FALSE;
    return FALSE;
#elif defined(__OS2__)
    if (h && h != WinQueryFocus (HWND_DESKTOP))
        return WinSetFocus (HWND_DESKTOP, h);
    return FALSE;
#elif defined(__X_MOTIF__)
    return h ? XmProcessTraversal (h, XmTRAVERSE_CURRENT) : FALSE;
#elif defined(__X_YACL__)
#endif
}




UI_Font& UI_VisualObject::Font()
{
    // If someone is asking for our font, we'll assume they're trying to
    // modify our font.
    if (!_ownFont) {
        VObjBind b (this, &UI_VisualObject::_FontChanged);
        if (_font)
            _font->RemoveDependent (b);
        _MakeNewFont ();
        if ( _displaySurface )
            _displaySurface->SetFont (_font);
        _font->AddDependent (b);
    }
    return *_font;
}



UI_Font* UI_VisualObject::OurFont ()
{
    return _ownFont ? _font : _parent->OurFont();
}


bool UI_VisualObject::_FontChanged ()
{
    return PropagateFontChange (this);
}

bool UI_VisualObject::PropagateFontChange (UI_VisualObject* v)
{
    if (!_ownFont || v == this) {
        _font = v->_font;
        _SetPlatformFont (ViewHandle());
    }
    return TRUE;
}




void UI_VisualObject::_MakeNewFont ()
{
    if (!_ownFont) {
        if (_parent && _parent->_font)
            _font = new UI_Font (*(_parent->_font));
        else {
            _font = new UI_Font (this);
        }
        PropagateFontChange (this);
        _ownFont = TRUE;
    }
}


bool UI_VisualObject::_SetPlatformFont (UI_ViewHandle handle) 
{
    if (!handle)
        return TRUE;
    if (_displaySurface)
        _displaySurface->SetFont (_font);
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ResourceHandle h  = _font ? _font->Handle() : 0;
    if (h  && handle)
        return SendMessage (handle, WM_SETFONT, (WPARAM) h, TRUE);
    return TRUE;
#elif defined(__OS2__)
    if (!_font || !handle)
        return TRUE;
    CL_String fontString = CL_String (_font->PointSize()) + "." +
        _font->TypeFace();
    ulong style = _font->Style ();
    if (style & UIFont_Italic)
        fontString += " Italic";
    if (style & UIFont_BoldFace)
        fontString += " Bold";
    if (style & UIFont_Underline)
        fontString += ".Underscore";
    if (style & UIFont_StrikeOut)
        fontString += ".Strikeout";
    bool b = WinSetPresParam (handle, PP_FONTNAMESIZE, fontString.Size()+1,
                              (void*) fontString.AsPtr());
    if (!b) {
        CL_String s = _Application->ErrorString();
        CL_Error::Warning
            ("WinSetPresParam '%s' failed, handle %d class %s: %s",
             fontString.AsPtr(), handle, ClassName(), s.AsPtr());
    }
    return b;
#elif defined(__X_YACL__)
    //    Invalidate ();
    return TRUE;
#elif defined (__X_MOTIF__)
    UI_ResourceHandle h  = _font ? _font->Handle() : 0;
    if (!h || !handle)
        return FALSE;

    Display *dpy = XtDisplay (handle);
    XmFontList f = XmFontListCreate (XQueryFont (dpy, h),
                                     XmSTRING_DEFAULT_CHARSET);
    Arg arg [1];
    XtSetArg       (arg [0], XmNfontList,  f);
    XtSetValues    (handle, arg, 1);
    XmFontListFree (f);
    return TRUE;
#endif
}



void UI_VisualObject::Foreground (const UI_Color& c)
{
    _fgColor = c;
    _fgColorChanged = TRUE;
    _DoSetForeground ();
}

void UI_VisualObject::_DoSetForeground ()
{
    if (!ViewHandle())
        return;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // Do nothing: Taken care of in vobjcoll.cxx, in response to the
    // WM_CTLCOLOR messages.
#elif defined(__OS2__)
    UI_NativeColorRep clr = _fgColor.NativeForm();
    WinSetPresParam (_handle, PP_FOREGROUNDCOLOR, sizeof clr, (void*) &clr);
#elif defined (__X_MOTIF__)
    XtVaSetValues (_xwidget, XmNforeground, _fgColor.XPixel(), 0);
#endif
}



void UI_VisualObject::Background (const UI_Color& c)
{
    _bgColor = c;
    if (ViewHandle())
        _DoSetBackground ();
    else
        _bgColorChanged = TRUE;
}


void UI_VisualObject::_DoSetBackground ()
{
    if (!ViewHandle())
        return;
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    // Do nothing: Taken care of in vobjcoll.cxx, in response to the
    // WM_CTLCOLOR messages.
#elif defined (__OS2__)
    UI_NativeColorRep clr = _bgColor.NativeForm();
    WinSetPresParam (_handle, PP_BACKGROUNDCOLOR, sizeof clr, (void*) &clr);
#elif defined(__X_YACL__)
    if (_displaySurface)
        XSetBackground (_Application->AppDisplay(),
                        _displaySurface->Handle(), _bgColor.XPixel());
#elif defined (__X_MOTIF__)
    XtVaSetValues (_xwidget, XmNbackground, _bgColor.XPixel(), 0);
#endif
}



#if defined(__X_MOTIF__)
void UI_VisualObject::_SetupStyle (void* p, short& argn)
{
    argn = 0;
    Arg* arg = (Arg*) p;

    short x = _shape.Left   ();
    short y = _shape.Top    ();
    short w = _shape.Width  ();
    short h = _shape.Height ();

    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;
}

bool UI_VisualObject::_CursorChanged ()
{
    if (_xwidget && XtWindow (_xwidget))
        _Controller->ChangeCursor (_xwidget, _cursor);
} 
#endif


bool UI_VisualObject::AddEventDependent
    (UI_EventType evt, const UI_AbstractEventBinding& bind)
{
    if (!_eventDependents)
        _eventDependents = new CL_IntPtrMap;
    if (!_eventDependents)
        return FALSE; // No memory
    CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[(long) evt];
    if (!set) {
        set = new CL_ClientSet;
        if (!set)
            return FALSE; // No memory
        _eventDependents->Add ((long) evt, set);
    }
    return set->Add (bind);   
}



bool UI_VisualObject::RemoveEventDependent
    (UI_EventType evt, const UI_AbstractEventBinding& bind)
{
    if (!_eventDependents)
        return FALSE;
    CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[(long) evt];
    if (!set)
        return FALSE;
    return set->Remove (bind);
}


bool UI_VisualObject::IsIconified ()
{
    return _parent && _parent->IsIconified();
}


bool UI_VisualObject::ShowBorder ()
{
    return _DoShowBorder (TRUE);
}


bool UI_VisualObject::HideBorder ()
{
    return _DoShowBorder (FALSE);
}

void UI_VisualObject::ScrollView
    (const UI_Rectangle& scrollArea, short xAmount, short yAmount)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        UpdateWindow (_handle);
        RECT r = scrollArea.AsMSRect();
        ScrollWindow (_handle, xAmount, yAmount, &r, NULL);
    }
#elif defined(__OS2__)
    if (_handle) {
        UI_Rectangle area = Shape ();
        RECTL rect;
        rect.xLeft    = scrollArea.Left();
        rect.yBottom  = area.Height() - scrollArea.Bottom () + 1;
        rect.xRight   = scrollArea.Right();
        rect.yTop     = area.Height() + 1 - scrollArea.Top ();
        WinScrollWindow (_handle, xAmount, yAmount, &rect, NULL, NULLHANDLE,
                         NULL, SW_INVALIDATERGN);
    }
#elif defined(__X_YACL__)
    if (!_window)
        return;
    GC gc;
    Display* dpy = _Application->AppDisplay();
    if (_displaySurface)
        gc = _displaySurface->Handle();
    else {
        XGCValues xvalues;
        gc = XCreateGC (dpy, _window, 0, &xvalues);
    }
    Drawable d = _window;
    long x = scrollArea.Left();
    long y = scrollArea.Top();
    XCopyArea (dpy, d, d, gc, x, y,
               scrollArea.Width(), scrollArea.Height(), x + xAmount,
               y + yAmount);
    if (!_displaySurface)
        XFreeGC (dpy, gc);
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return;
    GC gc;
    Display* dpy = XtDisplay (_xwidget);
    if (_displaySurface)
        gc = _displaySurface->Handle();
    else {
        XGCValues xvalues;
        gc = XCreateGC (dpy, XtWindow (_xwidget), 0, &xvalues);
    }
    Drawable d = XtWindow (_xwidget);
    long x = scrollArea.Left();
    long y = scrollArea.Top();
    XCopyArea (dpy, d, d, gc, x, y,
               scrollArea.Width(), scrollArea.Height(), x + xAmount,
               y + yAmount);
    if (!_displaySurface)
        XFreeGC (dpy, gc);
#endif
}


bool UI_VisualObject::_DoShowBorder (bool shown)
{
    _borderShown = shown;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        _style = GetWindowLong (_handle, GWL_STYLE);
    _style = shown ? (_style | WS_BORDER) : (_style & ~WS_BORDER);
    if (_handle) {
        SetWindowLong (_handle, GWL_STYLE, _style);
        SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_SHOWWINDOW | 
                       SWP_NOSIZE | SWP_NOMOVE | 
                       SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
    }
#elif defined(__OS2__)
    if (!shown) {
        if (_borderHandle)
            WinShowWindow (_borderHandle, FALSE);
    }
    else {
        if (!_parent)
            return FALSE; // Don't care about root window
        HWND parentHandle = _parent->ViewHandle();
        if (!_borderHandle) {
            _borderHandle = WinCreateWindow
                (parentHandle, WC_STATIC, NULL, WS_VISIBLE | SS_FGNDFRAME,
                 _shape.Left() - 1,
                 _YACLWindowHeight (parentHandle) - _shape.Bottom() - 2,
                 _shape.Width()+2, _shape.Height()+2, parentHandle,
                 HWND_BOTTOM, 0, NULL, NULL);
        }
        WinShowWindow (_borderHandle, TRUE);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtVaSetValues (_xwidget, XmNborderWidth, shown ? BORDER_WIDTH : 0,
                       NULL);
#endif
    return TRUE;
}


bool UI_VisualObject::_PrivateHandleEvent (UI_Event* e)
{
    if (e->Type() == Event_Reconfigure) {
        _SetShapeRectangle (e->Shape());
    }
    bool b = HandleEvent (e);
    bool p = TRUE;
    if (_eventDependents) {
        CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[e->Type()];
        if (set)
            p = set->Permits (*e);
    }
    // b will be TRUE if this object itself handled the event. p will be
    // TRUE if all the event dependents permitted the event to proceed up
    // the view tree, because none of them handled it.
    return b || !p; // If none of the dependents handled the event, they
                    // will all return TRUE, so we return FALSE.
}



void UI_VisualObject :: _SetModelValue (const CL_Object& value)
{
    CL_Object* model = _model;
    if ( !model )
        return;
    VObjBind bnd (this, &UI_VisualObject::_ModelChanged);
    model->RemoveDependent (bnd);
    *model = value;
    model->AddDependent (bnd);
}

void UI_VisualObject::_PrivateFinalize ()
{
    if (_parent)
        _parent->RemoveChild (this);
    if (_font) {
        VObjBind b (this, &UI_VisualObject::_FontChanged);
        _font->RemoveDependent (b);
    }
}


bool UI_VisualObject::AdjustPosition ()
{
    // Called by our parent to tell us that it has a menu bar.
    return TRUE;
}

void UI_VisualObject::AddChild    (UI_VisualObject* )
{
    // Do nothing
}


UI_VisualObject* UI_VisualObject::RemoveChild (UI_VisualObject* )
{
    // Do nothing
    return 0;
}




#if defined(__X_YACL__)
void UI_VisualObject::DrawVisualElement ()
{
    // Do nothing, by default. This should really be a pure virtual method.
}

#endif


#if defined(__OS2__)

long _YACLWindowHeight (UI_ViewHandle h)
{
    if (!h)
        return 0;
    RECTL windowRect;
    if (!WinQueryWindowRect (h, &windowRect))
        return 0;
    return windowRect.yTop - windowRect.yBottom + 1;
}

#endif


bool UI_VisualObject::_PrivateHandleChildEvent (UI_Event& )
{
    return FALSE; // Do nothing
}



#if defined(__MS_WINDOWS__) || defined (__MS_WIN32__)

long UI_VisualObject::WindowProcHook (HWND hWnd, UINT message, WPARAM wParam,
                                      LPARAM lParam)
{
    
    return DefaultProc (hWnd, message, wParam, lParam);
}


LRESULT UI_VisualObject::DefaultProc (HWND hWnd, UINT msg, WPARAM wParam,
                                        LPARAM lParam)
{
    return DefWindowProc (hWnd, msg, wParam, lParam);
}


#endif
