

#ifndef _toglbtn_h_ /* Fri Mar 11 08:37:05 1994 */
#define _toglbtn_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






//  ToggleButton is a SimpleVObject representing a toggle button. The
//  model for this object is a 
//  {\tt CL_Integer} whose value is either 0 or 1 depending on
//  current button state. The model can be inspected or modified via the {\tt
//  Model()} method.


#if defined(__GNUC__)
#pragma interface
#endif



#include "base/integer.h"
#include "ui/simple.h"

class YACL_UI UI_CompositeVObject;

class YACL_UI UI_ToggleButton: public UI_SimpleVObject {

public:

    UI_ToggleButton (UI_VisualObject* parent, const UI_Rectangle& shape,
                     UI_ViewID id = -1);
    // Construct a ToggleButton with the given parent, shape and view id.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ToggleButton (UI_VObjCollection* parent, UI_ViewID id,
                     UI_ViewHandle h);
    // [MS-Windows-specific, for YACL internal use only] Resource-based
    // construction.

#endif

    CL_Object& Model ();
    // Return a reference to this object's model, which is a {\tt CL_Integer}.

    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName () const {return "UI_ToggleButton";};


protected:

    void _PrivateInitialize ();
    // Override the inherited method to set up the initial setting of the
    // button. In addition, under Motif, the implementation sets
    // up resources. Under Windows, it subclasses the control for
    // supporting the 3-d look. 
    
    bool _ModelChanged ();
    // Called to tell this object that its model's contents have changed.

    ~UI_ToggleButton() {};
    // Destructor: does nothing.

    
#if defined (__X_MOTIF__)
    static void SelectionCallback (struct _WidgetRec*, void *, void *);
    // [X-windows-specific, for YACL internal use only] The callback
    // executed under Motif when the user changes the button's selection.

#elif defined(__X_YACL__)
    bool MakeVisualElement ();
    
    void DrawVisualElement ();
    // Draw the visual representation of this button.

    bool HandleEvent (UI_Event*);
    // Override the inherited method.

    bool _TitleChanged();
    // Override the inherited method.
    
#endif
    
};



#endif /* _toglbtn_h_ */
