

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */
#if defined(__GNUC__)
#pragma implementation
#endif



#include "base/set.h"

#include "ui/timer.h"
#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/composit.h"

#if defined(__UNIX__)
#include <sys/time.h>
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#include <windows.h>
static CL_IntPtrMap    _TimerMap;       // Map of Windows timer indices to
                                        // UI_Timer objects

static UINT FAR PASCAL TimerFunc (HWND, UINT, int id, DWORD)
{
    UI_Timer* tmr = (UI_Timer*) _TimerMap[id];
    if (tmr)
        tmr->DoAlarm();
    return 0;
}

static long _AllocateId ()
{
    // Find the smallest unused timer id
    CL_IntPtrMapIterator itr (_TimerMap);
    long count = 1;
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        if (assoc.key != count)
            break;
        count++;
    }
    return count;
}

#elif defined(__OS2__)
CL_IntPtrMap UI_Timer::_TimerMap;
#endif





UI_Timer::UI_Timer (const CL_AbstractBinding& bnd)
{
    _bind = (CL_AbstractBinding*) bnd.Clone();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _id = 0;
#endif
}


UI_Timer::UI_Timer ()
{
    _bind = NULL;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _id = 0;
#endif
}


UI_Timer::~UI_Timer ()
{
    Stop();
#if defined(__OS2__) || defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _TimerMap.Remove (_id);
#endif
    if (_bind)
        delete _bind;
}



bool UI_Timer::Start (long msecs)
{
    _msecs = msecs;
    UI_Application* app = YACLApp();
    if (!app)
        return FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    long n = _AllocateId ();
    if (SetTimer (app->MainWindow()->ViewHandle(),
                  n, msecs, (FARPROC) TimerFunc)) {
        _id = n;
        _TimerMap.Add (n, this);
        _running = TRUE;
        return TRUE;
    }
    return FALSE;
#elif defined(__OS2__)
    _id = WinStartTimer (app->Controller().AnchorBlockHandle(),
                         NULLHANDLE, 0, msecs);
    _TimerMap.Add (_id, this);
    _running = TRUE;
    return TRUE;
#elif defined(__X_MOTIF__)
    _id = app->Controller().RegisterTimeOut
        (msecs, &UI_Timer::DoAlarm, this);
    if (_id) {
        _running = TRUE;
        return TRUE;
    }
    return FALSE;
#elif defined (__X_YACL__)
    _id = app->Controller().RegisterTimeOut (msecs, this);
    if (_id) {
        _running = TRUE;
        return TRUE;
    }
    return FALSE;
#endif
}


bool UI_Timer::Stop ()
{
    UI_Application* app = YACLApp();
    if (!app)
        return FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_id > 0) {
        KillTimer (NULL, _id);
        _TimerMap.Remove (_id);
        _id = 0;
        _running = FALSE;
        return TRUE;
    }
    return FALSE;
#elif defined(__OS2__)
    if (_running) {
        WinStopTimer (app->Controller().AnchorBlockHandle(),
                      NULLHANDLE, _id);
        _running = FALSE;
    }
    return TRUE;
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    if (app && _running) {
        app->Controller().UnregisterTimeOut (_id);
        _running = FALSE;
    }
    return TRUE;
#endif
}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
void UI_Timer::DoAlarm ()
{
    if (_id >= 1 && _running && _bind)
        _bind->Execute (*this);
}
#elif defined(__X_MOTIF__)
void UI_Timer::DoAlarm (void* p, ulong* )
{
    UI_Timer* tmr = (UI_Timer*) p;
    if (tmr && tmr->_bind && tmr->_running) {
        tmr->_bind->Execute (*tmr);
        tmr->_id = YACLApp()->Controller().RegisterTimeOut
            (tmr->_msecs, &UI_Timer::DoAlarm, tmr);
    }
}

#elif defined(__OS2__)
void UI_Timer::DoAlarm (ulong id)
{
    UI_Timer* t = (UI_Timer*) _TimerMap [id];
    if (t && t->_bind)
        t->_bind->Execute (*t);
}

#elif defined(__X_YACL__)
void UI_Timer::DoAlarm (UI_Timer* tmr)
{
    if (tmr && tmr->_bind && tmr->_running) {
        tmr->_bind->Execute (*tmr);
        tmr->_id = YACLApp()->Controller().RegisterTimeOut (tmr->_msecs, tmr);
    }
}

#endif



