



#ifndef _window_h_ /* Mon Apr 22 22:53:50 1996 */
#define _window_h_


// This is a private class representing the visual element of a Label. This
// class is meant for YACL internal use only. YVE stands for YACL Visual
// Element. 

#include "ui/uidefs.h"
#include "ui/rectangl.h"


class CL_EXPORT UI_VisualObject;
class CL_EXPORT UI_CompositeVObject;
class CL_EXPORT UI_Bitmap;

class YVE_Window {

public:
    YVE_Window (UI_VisualObject* vObj);
    // Build a window for the given visual object.

    ~YVE_Window ();
    
    UI_ViewHandle Handle () const { return _window;};

    virtual void Reshape (const UI_Rectangle& rect);
    
protected:
    UI_ViewHandle      _window;
    UI_VisualObject*   _vObj;

};


class YVE_StringWindow: public YVE_Window {

public:

    YVE_StringWindow (UI_VisualObject* vObj);
    // Build a StringWindow for the given visual object.

    virtual void Draw (const char* content, UI_ReliefStyle style,
                       UI_TextStyle tStyle);
    


protected:
    Window         _handle;
    CL_String      _content;
    UI_ReliefStyle _style;
    UI_TextStyle   _tStyle;
};



// class YVE_PictureWindow: public YVE_Window {
// 
// public:
// 
//     YVE_PictureWindow (UI_VisualObject* vObj, const UI_Bitmap& bMap);
//     // Build a PictureWindow for the given visual object, using the given
//     // Bitmap as picture.
//     
//     virtual void Draw (UI_ReliefStyle style);
// 
// 
// protected:
//     const UI_Bitmap& _bMap;
// };
// 
// class YVE_CompositeWindow: public YVE_Window {
// 
// public:
//     YVE_CompositeWindow (UI_CompositeVObject* vObj);
//     // Build a window for the given visual object.
//     
//     virtual void Reshape (const UI_Rectangle& rect);
//     
// };
// 
// 
#endif /* _window_h_ */
