



#ifndef _label_h_ /* Mon Apr 22 22:53:50 1996 */
#define _label_h_


// This is a private class representing the visual element of a Label. This
// class is meant for YACL internal use only.

#include "ui/uidefs.h"
#include "ui/rectangl.h"


class YVE_Window {

public:
    YVE_Window (UI_ViewHandle parent);
    
    UI_ViewHandle Handle () const { return _handle;};

    virtual void Paint () = 0;

    virtual void Reshape (const UI_Rectangle& rect);
    
protected:
    UI_ViewHandle _handle, _parent;

};




class YVE_StringWindow: public YVE_Window {

public:

    enum LabelStyle { Plain, Raised, Recessed, Embossed, Grooved };
    
    YVE_StringWindow (UI_ViewHandle parent,
                      const UI_Rectangle& shape, LabelStyle
                      style = Recessed);

    virtual void SetTitle (const char* title);

    virtual void Paint ();


protected:
    Window  _handle;
};

class YVE_PixmapWindow: public YVE_Window {

public:
    
    YVE_PixmapWindow (UI_ViewHandle parent,
                      const UI_Rectangle& shape, const UI_Bitmap& bMap);

    virtual void Paint ();


protected:
    const UI_Bitmap& _bMap;
};

#endif /* _label_h_ */
