




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#    include <string.h>  // Without this, the X includes barf
#endif
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>


#include "base/bytstrng.h"

#include "ui/stddlg.h"
#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/composit.h"


class MessageBox {

public:
    MessageBox (const char* message,
                UI_StandardDialogStyle style = UIS_Ok,
                UI_StandardDialogIconStyle icon = UIS_Information,
                UI_CompositeVObject* parent = NULL,
                const char* box_title = "");
    ~MessageBox();
    
    short RunModal ();

    const char* ClassName () const {return "MessageBox";};
    
    static void Callback (Widget w, void* client, void* call);

protected:
    Widget                 _widget;
    CL_String              _callbackBtn;
    short                  _terminator;
    CL_String              _msg;
    CL_String              _title;
    UI_StandardDialogStyle _style;
    UI_CompositeVObject*   _parent;

    bool Filter (UI_Event& e);

    bool Terminator ();
};


bool MessageBox::Filter (UI_Event& e)
{
    XEvent* xevt = e.NativeEvent();
    UI_EventType typ = e.Type();
    if (e.Origin() != NULL && (xevt->type != Expose))
        return FALSE;
    // Don't permit any non-Expose events to go to YACL visual objects, but
    // allow all other events.
    return TRUE;
//     bool b = (e.Origin() == NULL
//               || typ == Event_MouseMove
//               || typ == Event_LButtonRelease // ?? Should I allow this?
//               || typ == Event_ViewEnter
//               || typ == Event_ViewLeave
//               || typ == Event_None
//               || typ == Event_Other
//               || typ == Event_Paint
//               || typ == Event_Reconfigure);
}

bool MessageBox::Terminator ()
{
    return _terminator != -1;
}

#if defined(__GNUC__)
template class CL_Binding0<MessageBox>;
template class UI_EventBinding1<MessageBox>;
#endif


void MessageBox::Callback (Widget , void* client, void* call)
{
    MessageBox* m = (MessageBox*) client;
    XmAnyCallbackStruct* cb = (XmAnyCallbackStruct*) call;
    switch (cb->reason) {
    case XmCR_OK:
        if (m->_style == UIS_YesNo || m->_style == UIS_YesNoCancel)
            m->_terminator = UI_IDYES;
        else
            m->_terminator = UI_IDOK;
        break;

    case XmCR_CANCEL:
        if (m->_style == UIS_YesNo || m->_style == UIS_YesNoCancel)
            m->_terminator = UI_IDNO;
        else
            m->_terminator = UI_IDCANCEL;
        break;

    case XmCR_HELP:
    default:
        m->_terminator = UI_IDCANCEL; // For yes/no/cancel dialogs
        break;
    };
    
}

MessageBox::MessageBox (const char* message,
                        UI_StandardDialogStyle style,
                        UI_StandardDialogIconStyle icon,
                        UI_CompositeVObject* parent,
                        const char* box_title)
{
    _msg = message;
    _title = box_title;
    _style = style;
    _parent = parent;
    Widget pw = parent ? (Widget) parent->ViewHandle()
        : YACLApp()->Controller().RootShell();
    switch (icon) {
    case UIS_Information:
        _widget = XmCreateInformationDialog (pw, "infoDialog", NULL, 0);
        break;
        
    case UIS_Question:
        _widget = XmCreateQuestionDialog (pw, "questionDialog", NULL, 0);
        break;
        
    case UIS_Error:
        _widget = XmCreateErrorDialog (pw, "infoDialog", NULL, 0);
        break;
        
    case UIS_Warning:
    default:
        _widget = XmCreateWarningDialog (pw, "warningDialog", NULL, 0);
        break;
    };
        
    _terminator = -1;


}


short MessageBox::RunModal ()
{
    YACLApp()->Controller().DispatchPendingEvents();
    Arg arg[6];
    short argn = 0;
    XmString msg = XmStringCreateLtoR ((char*) _msg.AsPtr(), 
                                       XmSTRING_DEFAULT_CHARSET);
    XtSetArg (arg[0], XmNmessageString,  msg);  argn++;
    
    XmString okTitle = XmStringCreateLtoR
        ("Yes", XmSTRING_DEFAULT_CHARSET);
    XmString cnTitle = XmStringCreateLtoR
        ("No",  XmSTRING_DEFAULT_CHARSET);
    XmString hlTitle = XmStringCreateLtoR
        ("Cancel", XmSTRING_DEFAULT_CHARSET);

    switch (_style) {
    case UIS_Ok:
        XtUnmanageChild (XmMessageBoxGetChild
                         (_widget, XmDIALOG_HELP_BUTTON));
        XtUnmanageChild (XmMessageBoxGetChild
                         (_widget, XmDIALOG_CANCEL_BUTTON));
        break;
        
    case UIS_YesNo:
        XtSetArg (arg[1], XmNcancelLabelString, cnTitle); argn++;
        XtSetArg (arg[2], XmNokLabelString,     okTitle); argn++;
        // Fall through...

    case UIS_OkCancel:
        XtUnmanageChild (XmMessageBoxGetChild (_widget, XmDIALOG_HELP_BUTTON));
        break;

    case UIS_YesNoCancel:
        XtSetArg (arg[1], XmNcancelLabelString, cnTitle); argn++;
        XtSetArg (arg[2], XmNokLabelString,     okTitle); argn++;
        XtSetArg (arg[3], XmNhelpLabelString,   hlTitle); argn++;
        break;

    default:
        break;
    };
        
    XtSetValues (_widget, arg, argn);
    XmStringFree (okTitle);
    XmStringFree (cnTitle);
    XmStringFree (hlTitle);

    XtVaSetValues (XtParent (_widget), XmNdialogTitle, (char*)
                   _title.AsPtr(), NULL);
    XtVaSetValues (XtParent (_widget), XmNtitle, (char*)
                   _title.AsPtr(), NULL);
    

    XtAddCallback (_widget, XmNcancelCallback, &MessageBox::Callback,
                   (XtPointer) this);
    XtAddCallback (_widget, XmNokCallback,     &MessageBox::Callback,
                   (XtPointer) this);
    XtAddCallback (_widget, XmNhelpCallback,   &MessageBox::Callback,
                   (XtPointer) this);
    XtManageChild (_widget);
    XtRealizeWidget (_widget);
    XmStringFree (msg);

    XtVaSetValues (XtParent (_widget), XmNdeleteResponse, XmDO_NOTHING, NULL);
    // Don't let user delete the window.
    
    UI_Controller& controller = YACLApp()->Controller();
    extern XtAppContext _YACLXAppContext; // Declared in cntroler.cxx
    XEvent xevent;
    while (_terminator == -1) {
        XtAppNextEvent (_YACLXAppContext, &xevent);
        Widget w = XtWindowToWidget (xevent.xany.display, xevent.xany.window);
        UI_VisualObject* v = controller[w];
        if (xevent.type == Expose || v == NULL)
            XtDispatchEvent (&xevent);
    }

    return _terminator;
}


MessageBox::~MessageBox ()
{
    XtUnmanageChild (_widget);
    XtDestroyWidget (_widget);
}



UI_ViewID UI_StandardDialog (const char* message,
                             const char* box_title,
                             UI_CompositeVObject* parent,
                             UI_StandardDialogStyle style,
                             UI_StandardDialogIconStyle icon)
{
    MessageBox theBox (message, style, icon, parent, box_title);
    return theBox.RunModal ();
}





class FileSelectBox {

public:
    FileSelectBox (UI_VisualObject* parent, const char* initialDir,
                   const char* box_title = "", const char* typeMask = "*");
    ~FileSelectBox();
    
    short RunModal ();

    CL_String FileName () {return _fileName;};
    
    const char* ClassName () const {return "FileSelectBox";};
    
    static void Callback (Widget w, void* client, void* call);

protected:
    Widget     _widget;
    CL_String  _callbackBtn;
    short      _terminator;
    CL_String  _title;
    CL_String  _fileName;

    bool Filter (UI_Event&);

    bool Terminator ();
    
};



bool FileSelectBox::Filter (UI_Event&)
{
    return FALSE; // Do not dispatch any YACL events
}

bool FileSelectBox::Terminator ()
{
    return _terminator != -1;
}

#if defined(__GNUC__)
template class CL_Binding0<FileSelectBox>;
template class UI_EventBinding1<FileSelectBox>;
#endif


void FileSelectBox::Callback (Widget , void* client, void* call)
{
    FileSelectBox* m = (FileSelectBox*) client;
    XmFileSelectionBoxCallbackStruct* cb =
        (XmFileSelectionBoxCallbackStruct*) call;
    switch (cb->reason) {
    case XmCR_OK:
        m->_terminator = UI_IDOK;
        break;

    case XmCR_CANCEL:
    default:
        m->_fileName = "";
        m->_terminator = UI_IDCANCEL;
        break;
    };
    if (cb->reason != XmCR_OK)
        return;
    Widget box = XmFileSelectionBoxGetChild (m->_widget, XmDIALOG_TEXT);
    char* p = XmTextGetString (box);
    m->_fileName = p;
    XtFree (p);
    
}

FileSelectBox::FileSelectBox (UI_VisualObject* parent, const char* initialDir,
                              const char* box_title, const char* file_mask)
{
    _title = box_title;
    Widget pw = parent ? (Widget) (parent->ViewHandle())
        : YACLApp()->Controller().RootShell();
    _widget = XmCreateFileSelectionDialog (pw, "fileSelectionBox", NULL, 0);
    XmString strg = XmStringCreate ((char*) initialDir,
                                    XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (_widget, XmNdirectory, strg, NULL);
    XmString dirmask = XmStringCreate((char *)file_mask,
                                      XmSTRING_DEFAULT_CHARSET);
    XmFileSelectionDoSearch(_widget, dirmask);
    XmStringFree(dirmask);
    XmStringFree (strg);
    _terminator = -1;
}


short FileSelectBox::RunModal ()
{
    YACLApp()->Controller().DispatchPendingEvents();
    XtVaSetValues (XtParent (_widget), XmNtitle, (char*) _title.AsPtr(), NULL);
    
    XtAddCallback (_widget, XmNcancelCallback, &FileSelectBox::Callback,
                   (XtPointer) this);
    XtAddCallback (_widget, XmNokCallback,     &FileSelectBox::Callback,
                   (XtPointer) this);
    XtManageChild (_widget);
    XtRealizeWidget (_widget);

//     UI_Controller& controller = YACLApp()->Controller();
//     UI_EventBinding1<FileSelectBox> bind (this, FileSelectBox::Filter);
//     CL_Binding0<FileSelectBox> tbind (this, FileSelectBox::Terminator);
//     while (_terminator == -1) {
//         controller.EventLoop (&tbind, &bind);
//     }



    XtVaSetValues (XtParent (_widget), XmNdeleteResponse, XmDO_NOTHING, NULL);
    // Don't let user delete the window.
    
    UI_Controller& controller = YACLApp()->Controller();
    extern XtAppContext _YACLXAppContext; // Declared in cntroler.cxx
    XEvent xevent;
    while (_terminator == -1) {
        XtAppNextEvent (_YACLXAppContext, &xevent);
        Widget w = XtWindowToWidget (xevent.xany.display, xevent.xany.window);
        UI_VisualObject* v = controller[w];
        if (xevent.type == Expose || v == NULL)
            XtDispatchEvent (&xevent);
    }

    return _terminator;
}


FileSelectBox::~FileSelectBox ()
{
    XtUnmanageChild (_widget);
    XtDestroyWidget (_widget);
}


CL_String UI_FileSelectDialog (UI_VisualObject* parent,
                               const char* initialDir,
                               const char* box_title,
                               const char* typeMask)
{
    FileSelectBox box (parent, initialDir, box_title, typeMask);
    box.RunModal ();
    return box.FileName();
}




bool UI_FontDialog (UI_CompositeVObject* parent, UI_FontDesc& desc)
{
    return FALSE;
}


