


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



//  MS/Windows-specific stuff

#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/cntroler.h"
#include "ui/menu.h"
#include "ui/btngroup.h"
#include "ui/composit.h"
#include "ui/stred.h"
#include "ui/mdi.h"
#include "ui/scrolwin.h"

#if defined(USE_CTL3D)
#include <ctl3d.h>
#endif

#include <windowsx.h>

#define DIALOG_CLASS_NAME "#32770"  // SOMETHING VERY WINDOWS-SPECIFIC!!
                                    // Hopefully this is the class name
                                    // for dialogs under all versions of
                                    // Windows.

#if !defined(GET_WM_HSCROLL_HWND)
#define GET_WM_HSCROLL_HWND(wp, lp) ((HWND)  HIWORD(lp))
#endif
#if !defined(GET_WM_HSCROLL_CODE)
#define GET_WM_HSCROLL_CODE(wp, lp) (wp)
#endif
#if !defined(GET_WM_HSCROLL_POS)
#define GET_WM_HSCROLL_POS(wp, lp) ((long)LOWORD(lp))
#endif
#if !defined(GET_WM_COMMAND_HWND)
#define GET_WM_COMMAND_HWND(wp, lp) ((HWND)  LOWORD(lp))
#endif
#if !defined(GET_WM_COMMAND_CMD)
#define GET_WM_COMMAND_CMD(wp, lp) ((long)  HIWORD(lp))
#endif
#if !defined(GET_WM_MENUSELECT_CMD)
#define GET_WM_MENUSELECT_CMD(wp, lp)               (wp)
#define GET_WM_MENUSELECT_FLAGS(wp, lp)             LOWORD(lp)
#define GET_WM_MENUSELECT_HMENU(wp, lp)             (HMENU)HIWORD(lp)
#endif


static struct {
    UINT message;
    UI_EventType yaclEvent;
} TransTable [] = {
    WM_SETFOCUS,        Event_GetFocus,
    WM_KILLFOCUS,       Event_LoseFocus,
    WM_LBUTTONDOWN,     Event_LButtonPress,
    WM_LBUTTONUP,       Event_LButtonRelease,
    WM_LBUTTONDBLCLK,   Event_LButtonDblClk,
    WM_MBUTTONDOWN,     Event_MButtonPress,  
    WM_MBUTTONUP,       Event_MButtonRelease, 
    WM_MBUTTONDBLCLK,   Event_MButtonDblClk, 
    WM_RBUTTONDOWN,     Event_RButtonPress,
    WM_RBUTTONUP,       Event_RButtonRelease, 
    WM_RBUTTONDBLCLK,   Event_RButtonDblClk,
    WM_CHAR,            Event_KeyTyped,
    WM_MOUSEMOVE,       Event_MouseMove,
    WM_CLOSE,           Event_CloseDown,
    WM_INITMENU,        Event_GetFocus,
    WM_INITMENUPOPUP,   Event_GetFocus,
    WM_MENUSELECT,      Event_GetFocus,
    WM_MOVE,            Event_Reconfigure,
    WM_SIZE,            Event_Reconfigure,
    WM_PAINT,           Event_Paint,
    WM_COMMAND,         Event_Select,
    //    BM_SETCHECK,        Event_Select,
    WM_VSCROLL,         Event_None, // Set by special handling
    WM_HSCROLL,         Event_None, // Set by special handling
    0,                  Event_Other
};


long FAR PASCAL YACL_UI YACLWindowProc (HWND, unsigned, UINT, LONG);
long FAR PASCAL YACL_UI YACLDialogProc (HWND, unsigned, UINT, LONG);

void UI_Controller::MDIClientCreated (UI_MDIMainWindow*)
{
    _mainWindowIsMDI = TRUE;
}

bool UI_Controller::_DoOneEvent (NativeEventStruct& msg, UI_Event& e)
{
    // Process a single native event, return its translation in e. Return
    // TRUE if everything is ok, FALSE if the termination filter said YES.

    // Windows requires cursor setting on every mouse move, otherwise
    // it reverts to the window class cursor! (see the documentation
    // for the SetCursor call) Setting of cursor on every move
    // can only be avoided if we use a NULL for the window class
    // cursor; but if we do that, we'll not able to set our mouse
    // cursor when the mouse moves out of the client area and back in,
    // because we have no way of knowing when the mouse has moved out
    // of the client area. There's also the problem that cursor shape
    // changes on click. 

    if (msg.message == WM_SETCURSOR  || msg.message == WM_MOUSEMOVE) {
        if (_inWaitState)
            SetCurrentCursor (_defaultCursor);
        else {
            POINT p;
            GetCursorPos (&p);
            HWND hWnd = WindowFromPoint (p);
            UI_VisualObject* dest = (*this)[hWnd];
            if (dest)
                SetCurrentCursor (dest->Cursor());
        }
    }

    char className[40];
    GetClassName (msg.hwnd, className, 40);
    if (lstrcmp (className, _YACLWindowClassName) == 0 ||
        lstrcmp (className, _YACLSimpleClassName) == 0) {
        // It's for one of the YACL windows, and the corresponding
        // windowproc should do its dispatching. So:
        DispatchMessage (&msg);
        DispatchSoftEvents();
        return TRUE;
    }
    else if (lstrcmp (className, DIALOG_CLASS_NAME) == 0 // It's a dialog
             && (msg.message != WM_SYSCOMMAND || msg.wParam != SC_CLOSE)) {
        // It's a message to a dialog, but not one that closes the dialog
        DispatchMessage (&msg);
        DispatchSoftEvents();
        return TRUE;
    }

    // So now we know we're handling a non-YACL window class, or else a
    // close message to a dialog.
    
    bool dsp = FALSE;
    dsp =  TranslateNativeEvent (msg, e);

    // Now here's a major HACK to handle tabs:
    bool disp = (msg.message != WM_CHAR || msg.wParam != '\011' &&
                 msg.wParam != 0x0d);
    if (!disp && e._origin) {
        disp = (e._origin->_style & ES_MULTILINE) ||
            (lstrcmp (e._origin->WindowClass(), "edit") != 0);
        // A tab or newline sent to a single-line edit control would cause a 
        // beep, so we don't dispatch it.
    }

    if (disp && msg.message != WM_SETCURSOR) {
        DispatchMessage (&msg);

    }

    if (e._origin && dsp && _root
        && _visualObjMap.IncludesKey ((long) (e._origin->_handle))) { 
    //       ^^^^^^^^^^^^^^^^^^^^^^^
    // These tests are is needed because it is possible that the
    // DispatchMessage call above generated events that destroyed the
    // tree or e._origin or both.
        if ( !_eventFilter || _eventFilter->Execute (e) ) {
            DispatchNativeEvent (e);
            // We don't dispatch events from a VisualObject whose class is
            // YACLWindowClassName, because those are done by the
            // WindowProc.
        }
        if (_termination && _termination->Execute (e))
            return FALSE;
    }
    DispatchSoftEvents();
    return TRUE;
}

bool UI_Controller::ProcessNativeEvents ()
{
    NativeEventStruct msg;
    while (_root && GetMessage (&msg, NULL, 0, 0) ) {
        if (!_mainWindowIsMDI ||
            !TranslateMDISysAccel (_root->ViewHandle(), &msg))
            TranslateMessage (&msg);
        UI_Event e (Event_None, NULL);
        if (!_DoOneEvent (msg, e))
            return FALSE;
    }
    return TRUE;
}


void UI_Controller::FlushEventQueue ()
{
    // Commented out till I figure out why this doesn't work
//     NativeEventStruct msg;
//     while (_root &&  PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
//         TranslateMessage (&msg);
//         if (msg.message != WM_CLOSE && msg.message != WM_QUIT)
//             DispatchMessage (&msg);
//     }
}


void UI_Controller::DispatchPendingEvents ()
{
    DispatchSoftEvents ();
    NativeEventStruct msg;
    UI_Event e (Event_None, NULL);
    while (_root && PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)
           && _DoOneEvent (msg, e));
}



bool UI_Controller::DispatchNativeEvent ( UI_Event& e )
{
    if (!_root)
        return TRUE;
    
    bool ret_val = TRUE;
    switch (e.Type ()) {
    case Event_MouseMove:
        if ( _current != e.Destination () ) {
            // The mouse entered a different visual obj
            if ( _current ) {
                UI_Event leave (Event_ViewLeave, _current);
                DispatchEvent (&leave);
            }
            _current = e.Destination ();
            UI_Event enter (Event_ViewEnter, e.Destination ());
            ret_val = DispatchEvent (&enter);
        }
        ret_val = DispatchEvent (&e);
        break;

    default:
        ret_val = DispatchEvent (&e);
        break;
    }
    return ret_val;
}




// We need a MenuEntry class to maintain the _menuMap object. This is a map
// of <menu item id, parent handle> pairs to menu item objects. This is the
// only way we can decode the destination of a menu event.

class YACL_UI MenuEntry: public CL_Object {

public:
    MenuEntry (UI_ViewID id, UI_ViewHandle handle)
    : _id (id), _handle (handle) {};

    ~MenuEntry ();

    short Compare (const CL_Object& o) const;

    const char* ClassName () const {return "MenuEntry";};
    
private:
    UI_ViewID _id;
    UI_ViewHandle _handle;
};


MenuEntry::~MenuEntry ()
{
}

short MenuEntry::Compare (const CL_Object& o) const
{
    const MenuEntry& entry = (const MenuEntry&) o;
    if (_handle == entry._handle) 
        return _id == entry._id ? 0 : (_id < entry._id ? -1 : 1);
    return _handle < entry._handle ? -1 : 1;
}



bool UI_Controller::MenuItemCreated (UI_MenuItem* item)
    // Called from the MenuItem::_PrivateInitialize
{
    MenuEntry* entry = new MenuEntry
        (item->_id, item->Container().Parent()->ViewHandle());
    return _menuMap.Add (entry, (long) item);
}


bool UI_Controller::MenuItemDestroyed (UI_MenuItem* item)
    // Called from the MenuItem destructor
{
    MenuEntry entry (item->_id, item->Container().Parent()->ViewHandle());
    CL_PtrIntAssoc a = _menuMap.Remove (&entry);
    if (a.key) {
        delete a.key;
        return TRUE;
    }
    return FALSE;
}


bool UI_Controller::TranslateNativeEvent (NativeEventStruct& msg, UI_Event& e)
{
    e._nativeEvent = new NativeEventStruct;
    *(NativeEventStruct*)(e._nativeEvent) = msg;
    e.curPos = UI_Rectangle (LOWORD (msg.lParam), HIWORD (msg.lParam), 0, 0);
    e._metaKey = (msg.lParam & (1L << 29)) ? TRUE : FALSE;
    e._shiftKey = (GetKeyState (VK_SHIFT) & 0x8000) ? TRUE : FALSE;
    e._ctrlKey  = (GetKeyState (VK_CONTROL) & 0x8000) ? TRUE : FALSE;


    UI_VisualObject* view = NULL;
    short i;
    for (i = 0; TransTable [i].message != 0; i++) {
        if (TransTable [i].message == msg.message)
            break;
    }
    e._type = TransTable[i].yaclEvent;
    UI_ViewHandle window_key;
    if (msg.message == WM_INITMENU || msg.message == WM_INITMENUPOPUP) {
        window_key = (UI_ViewHandle) msg.wParam;
        e.param = msg.wParam;
    }
    else if (msg.message == WM_VSCROLL || msg.message == WM_HSCROLL) {
        window_key = GET_WM_HSCROLL_HWND (msg.wParam, msg.lParam);
        e.param = GET_WM_HSCROLL_POS (msg.wParam, msg.lParam);
        long code = GET_WM_HSCROLL_CODE (msg.wParam, msg.lParam);
        switch (code) {
        case SB_BOTTOM:
            e._type = Event_ScrollToEnd;
            break;

        case SB_ENDSCROLL:
            e._type = Event_FinishScroll;
            break;

        case SB_LINEDOWN:
            e._type = Event_ScrollForwardLine;
            break;

        case SB_PAGEDOWN:
            e._type = Event_ScrollForwardPage;
            break;

        case SB_LINEUP:
            e._type = Event_ScrollBackwardLine;
            break;

        case SB_PAGEUP:
            e._type = Event_ScrollBackwardPage;
            break;

        case SB_THUMBPOSITION:
            e._type = Event_ScrollToPosition;
            break;

        case SB_THUMBTRACK:
            e._type = Event_Scroll;
            break;
        }
    }
    else
        window_key = (UI_ViewHandle) msg.hwnd;
    view = (UI_VisualObject *) _visualObjMap [(long) window_key];
    e._origin = e._dest = view;

    switch (msg.message) {
    case WM_HSCROLL:
    case WM_VSCROLL:
    if (!window_key) {
        // This is a scroll message from a scroll bar attached to a
        // window that has the WS_VSCROLL or WS_HSCROLL style
        UI_ScrollableWindow* w = (UI_ScrollableWindow*)
            _visualObjMap [(long) msg.hwnd];
        view = e._origin = e._dest =
            ((msg.message == WM_HSCROLL) ? &(w->HorzScrollBar())
             : &(w->VertScrollBar()));
        break;
    }
        
    case WM_PAINT: {
        RECT rect;
#if defined(__MS_WIN32__)
        bool erase = TRUE;
#else
        bool erase = FALSE;
#endif
        if (view) {
            if (GetUpdateRect (view->_handle, &rect, erase)) {
                long w = rect.right  - rect.left + 1;
                long h = rect.bottom - rect.top  + 1;
                UI_Rectangle exposed (rect.left, rect.top, w, h);
                e.curPos = exposed;
            }
            else
                e.curPos = UI_Rectangle (0, 0, view->_shape.Width(),
                                         view->_shape.Height());
        }
        break;
    }
        
    case WM_MOVE: {
        long w = 0, h = 0;
        if (view) {
            w = view->_shape.Width();
            h = view->_shape.Height();
        }
        e.curPos = UI_Rectangle (LOWORD (msg.lParam), HIWORD
                                 (msg.lParam), w, h);
        break;
    }

    case WM_SIZE: {
        long x = 0, y = 0;
        if (view) {
            x = view->_shape.Left();
            y = view->_shape.Top();
        }
        e.curPos = UI_Rectangle (x, y, LOWORD (msg.lParam), HIWORD
                                 (msg.lParam));
        switch (msg.wParam) {
        case SIZE_MINIMIZED:
            e._type = Event_Iconify;
            break;
            
        case SIZE_MAXIMIZED:
        case SIZE_RESTORED:
            e._type = (view && view->IsIconified()) ? Event_Deiconify
                : Event_Reconfigure;
            break;
            
        default:
            e._type = Event_Reconfigure;
            break;
        }
        break;
    }

    case WM_CHAR:
        e.key = msg.wParam;
        break;
        
    default:
        break;
    }
    // Now process the menu messages
    
    if (msg.message == WM_MENUSELECT) {
        UI_ViewID id = GET_WM_MENUSELECT_CMD(msg.wParam, msg.lParam);
        MenuEntry entry (id, msg.hwnd);
        UI_MenuItem* itm = (UI_MenuItem*) _menuMap[&entry];
        UINT flags = GET_WM_MENUSELECT_FLAGS(msg.wParam, msg.lParam);
        UI_ViewHandle hMenu = GET_WM_MENUSELECT_HMENU(msg.wParam, msg.lParam);
        if (flags == 0xffff && hMenu == 0) {
            // Menu closed
            e._type = Event_LoseFocus;
            e._origin = e._dest = itm;
            _focus = NULL;
        }
        else {
            if (_focus) {
                UI_Event loseFocus (Event_LoseFocus, _focus, _focus);
                DispatchEvent (&loseFocus);
            }
            e._type = Event_GetFocus;
            e._origin = e._dest = _focus = itm;
            e.param = msg.wParam;
        }
    }
//     else if (msg.message == WM_SYSCOMMAND && msg.wParam == SC_CLOSE) {
//         e._type = Event_CloseDown;
//     }
    else if (msg.message == WM_COMMAND) {
        if (LOWORD (msg.lParam) == 0) {
            // Message from a menu: Event_Select
            MenuEntry entry (msg.wParam, msg.hwnd);
            UI_MenuItem* itm = (UI_MenuItem*) _menuMap[&entry];
            e._origin = e._dest = itm;
            e.param = msg.wParam; // Set the menu id
        }
        else {
            // Message from a control
            HWND h = GET_WM_COMMAND_HWND (msg.wParam, msg.lParam);
            e._origin = e._dest = (UI_VisualObject*) _visualObjMap  [(long)h];
            long cmd = GET_WM_COMMAND_CMD (msg.wParam, msg.lParam);
            switch (cmd) {
            case LBN_SELCHANGE:
            // case CBN_SELCHANGE:
            // windows.h defines CBN_SELCHANGE == LBN_SELCHANGE!!
            case BN_CLICKED:
                e._type = Event_Select;
                break;


            default:
                e._type = Event_Other;
                break;
            }
        }
    }
    return e._dest != NULL;
}



void UI_Controller::_MakeWindowsInterface (const UI_Event& e)
{
    // We don't create the interface for the child of a composite if the
    // composite was built from a resource under MS/Windows

    bool b = TRUE;
    UI_VisualObject* origin = e.Origin();
    UI_VisualObject* parent = origin->_parent;
    bool res = parent && parent->CreatedViaResource ();
    if (!parent || !res)
        b = origin->MakeVisualElement ();
    if (b && origin->ViewHandle ()) {
        Register (origin);
        if (!res)
            ShowWindow (origin->ViewHandle (), 
                        origin->_visible ? SW_SHOW : SW_HIDE
                        );
    }
    origin->_PrivateInitialize ();
    origin->Initialize ();
}


long UI_Controller::WindowProc (HWND hWnd, unsigned message,
                                UINT wParam, LONG lParam)
{
    UI_VObjCollection* v = (UI_VObjCollection*) _visualObjMap[(long) hWnd];
    // --------------------^^^^^^^^^^^^^^^^^^^^^^
    // Note the cast-down here. Don't use this WindowProc for any class
    // other than ones derived from VObjCollection!!
    if (!v)
        return DefWindowProc (hWnd, message, wParam, lParam);

    NativeEventStruct msg;
    msg.hwnd = hWnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    UI_Event e (Event_None, NULL);
    TranslateNativeEvent (msg, e);
    long retVal = 0;
    if (message == WM_COMMAND) {
        retVal = DefWindowProc (hWnd, message, wParam, lParam);
        short cmd = GET_WM_COMMAND_CMD (wParam, lParam);
        if (cmd == 0) {
            // Menu item was selected; now make it lose focus:
            UI_Event event (Event_LoseFocus, e._origin, e._origin);
            DispatchEvent (&event);
        }
        else if (cmd == EN_CHANGE) {
            // Edit control's contents have changed; notify it
            HWND h = GET_WM_COMMAND_HWND (msg.wParam, msg.lParam);
            UI_StringEditor* edit = (UI_StringEditor*) (*this)[h];
            edit->Update();
        }
    }
    else
         retVal = v->WindowProcHook (hWnd, message, wParam, lParam);

    if (!_eventFilter || _eventFilter->Execute (e) )
        DispatchNativeEvent (e);
    if (message == WM_PAINT)
        ValidateRgn (hWnd, NULL); // Assume that the Paint method did
                                  // its job. Without this call I'll be
                                  // flooded with WM_PAINT messages
    return retVal;
}



long UI_Controller::DialogProc (HWND hWnd, unsigned message,
                                UINT wParam, LONG lParam)
{
    UI_Event e (Event_None, NULL);
    NativeEventStruct msg;
    msg.hwnd = hWnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    TranslateNativeEvent (msg, e);
    if ( !_eventFilter || _eventFilter->Execute (e) )
        DispatchNativeEvent (e);
    switch (message) {

#if defined(USE_CTL3D)
#if defined(__MS_WINDOWS__)
    case WM_SETTEXT:
#endif
    case WM_NCPAINT:
    case WM_NCACTIVATE:
        SetWindowLong (hWnd, DWL_MSGRESULT,
                       Ctl3dDlgFramePaint (hWnd, message, wParam, lParam));
        return TRUE;
        
        
#if defined(__MS_WIN32__)
    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
    case WM_CTLCOLORSCROLLBAR:
    case WM_CTLCOLORMSGBOX:
    case WM_CTLCOLORSTATIC:
        // I leave out the edit and listbox controls so that their
        // backgrounds may be painted white instead of grey. Otherwise the
        // part of the control with strings in it appears white, the rest
        // appears grey, and the result is ugly.
//    case WM_CTLCOLOREDIT:
//    case WM_CTLCOLORLISTBOX:
#else
    case WM_CTLCOLOR:
#endif
    {
        HBRUSH hbr = Ctl3dCtlColorEx  (message, wParam, lParam);
        return hbr ? (LRESULT) hbr : (LRESULT) _buttonFaceBrush;
    }
#endif // USE_CTL3D
    
        
    case WM_COMMAND: {
        short cmd = GET_WM_COMMAND_CMD (msg.wParam, msg.lParam);
        if (cmd == 0) {
            // Menu item was selected; now make it lose focus:
            UI_Event event (Event_LoseFocus, e._origin, e._origin);
            DispatchEvent (&event);
        }
        else if (cmd == EN_CHANGE) {
            // Edit control's contents have changed; notify it
            HWND h = GET_WM_COMMAND_HWND (msg.wParam, msg.lParam);
            UI_StringEditor* edit = (UI_StringEditor*) (*this)[h];
            edit->Update();
        }
        break;
    }

    default:
        break;

    }


    return 0;
}

long UI_Controller::BtnGroupProc (HWND hWnd, unsigned msg,
                                  UINT wParam, LONG lP)
{
    UI_ButtonGroup* group = (UI_ButtonGroup*) _visualObjMap[(long) hWnd];
#if defined(__MS_WIN32__)
    FARPROC realProc = (FARPROC) GetProp (hWnd, BTNGROUP_PROPERTY1);
    if (realProc == 0 || !group)
        return DefWindowProc (hWnd, msg, wParam, lP);
#else
    int low = GetProp (hWnd, BTNGROUP_PROPERTY1);
    int hi  = GetProp (hWnd, BTNGROUP_PROPERTY2);
    if (low == 0 || hi == 0 || !group)
        return DefWindowProc (hWnd, msg, wParam, lP);
    FARPROC realProc = (FARPROC) MAKELONG (low, hi);
#endif
    long retVal = 0L;
    switch (msg) {

    case WM_ERASEBKGND: {
        RECT rect;
        GetClientRect (hWnd, &rect);
        HBRUSH brush;
#if defined(USE_CTL3D)
        int color =  (group->Has3DLook()) ? COLOR_BTNFACE : COLOR_WINDOW;
#else
        int color = COLOR_BTNFACE;
#endif
        brush = CreateSolidBrush (GetSysColor (color));
        FillRect ((HDC) wParam, &rect, brush);
        DeleteObject (brush);
//         // Now just call the real proc, pretending that no painting was
//         // done, and let it do its thing:
//         retVal = CallWindowProc (realProc, hWnd, msg, wParam, lP);
        retVal = 1;
        break;
    }

#if defined(__MS_WIN32__)
    case WM_PAINT: {
        // Under Win NT, it seems like the button group does not get
        // painted correctly. So:
// #if defined(USE_CTL3D)
        if (group->Has3DLook()) {
            // Fill it with gray
            RECT rect;
            GetClientRect (hWnd, &rect);
            FillRect ((HDC) wParam, &rect, _buttonFaceBrush);
        }
// #endif
        
        // Now call the real painting code
        retVal = CallWindowProc (realProc, hWnd, msg, wParam, lP);
        break;
    }
#endif

#if defined(USE_CTL3D)
#if defined(__MS_WIN32__)
    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
    case WM_CTLCOLOREDIT:
    case WM_CTLCOLORSCROLLBAR:
    case WM_CTLCOLORMSGBOX:
    case WM_CTLCOLORSTATIC:
#else
    case WM_CTLCOLOR:
#endif
    {
        if (group && group->Has3DLook())
            retVal = (long) Ctl3dCtlColorEx  (msg, wParam, lP);
        else
            retVal = CallWindowProc (realProc, hWnd, msg, wParam, lP);
        break;
    }
#endif // USE_CTL3D
    
    default:
        retVal = CallWindowProc (realProc, hWnd, msg, wParam, lP);
        break;
    }
    MSG mesg;
    mesg.hwnd = hWnd;
    mesg.message = msg;
    mesg.lParam = lP;
    mesg.wParam = wParam;
    UI_Event e (Event_None, NULL);
    TranslateNativeEvent (mesg, e);
    if (!_eventFilter || _eventFilter->Execute (e) )
        DispatchNativeEvent (e);
    return retVal;
}

#define PROP1 "YACL_PROP1"
#define PROP2 "YACL_PROP2"
long UI_Controller::BtnProc (HWND hWnd, unsigned msg, UINT wParam, LONG lParam)
{
#if defined(__MS_WIN32__)
    FARPROC realProc = (FARPROC) GetProp (hWnd, PROP1);
#else    
    int low = GetProp (hWnd, PROP1);
    int hi  = GetProp (hWnd, PROP2);
    if (!low || !hi)
        return DefWindowProc (hWnd, msg, wParam, lParam);
    FARPROC realProc = (FARPROC) MAKELONG (low, hi);
#endif

#if defined(USE_CTL3D)
    if (msg == WM_ERASEBKGND) {
        // Catch the ERASEBKGND message *before* it gets to the button, and
        // fill its background with grey:
        RECT rect;
        GetClientRect (hWnd, &rect);
        HBRUSH brush;
        UI_VisualObject* vObj = (*this)[hWnd];
        if (vObj && vObj->Has3DLook()) {
            brush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE));
        }
        else {
            brush = CreateSolidBrush (GetSysColor (COLOR_WINDOW));
        }
        FillRect ((HDC) wParam, &rect, brush);
        DeleteObject (brush);
        // Now just call the real proc, pretending that no painting was
        // done, and let it do its thing:
    }
#endif

    long retVal = CallWindowProc (realProc, hWnd, msg, wParam, lParam);
    if (msg == WM_KEYDOWN || msg == WM_KEYUP) {
        // Don't want to dispatch any other events from here, because
        // they'll be dispatched from the main event loop
        MSG mesg;
        mesg.hwnd    = hWnd;
        mesg.message = msg;
        mesg.lParam  = lParam;
        mesg.wParam  = wParam;
        UI_Event e (Event_None, NULL);
        TranslateNativeEvent (mesg, e);
        if (!_eventFilter || _eventFilter->Execute (e) )
            DispatchNativeEvent (e);
    }
    return retVal;
}

long UI_Controller::EditProc (HWND hWnd, unsigned msg,
                              UINT wParam, LONG lParam)
{
#if defined(__MS_WIN32__)
    FARPROC realProc = (FARPROC) GetProp (hWnd, PROP1);
#else
    int low = GetProp (hWnd, PROP1);
    int hi  = GetProp (hWnd, PROP2);
    if (!low || !hi)
        return DefWindowProc (hWnd, msg, wParam, lParam);
    FARPROC realProc = (FARPROC) MAKELONG (low, hi);
#endif
    if (msg == WM_CHAR) {
        UI_StringEditor* edit = (UI_StringEditor*) (*this)[hWnd];
        if (!edit->FilterChar ((short&) wParam))
            return 0;
    }
    else if (msg == WM_KEYDOWN && (wParam == VK_DELETE || wParam == VK_BACK)) {
        UI_StringEditor* edit = (UI_StringEditor*) (*this)[hWnd];
        if (!edit->PermitDelete ())
            return 0;
    }
    return CallWindowProc (realProc, hWnd, msg, wParam, lParam);
}


void UI_Controller::SubclassControl (UI_ViewHandle handle, FARPROC proc)
{
    FARPROC RealProc = (FARPROC) SetWindowLong (handle, GWL_WNDPROC, (long)
                                                proc);
#if defined(__MS_WIN32__)
    SetProp (handle, PROP1, (void*) (RealProc));
#else
    SetProp (handle, PROP1, LOWORD (RealProc));
    SetProp (handle, PROP2, HIWORD (RealProc));
#endif
}



long UI_Controller::MDIFrameProc (HWND hWnd, unsigned message,
                                  UINT wParam, LONG lParam)
{
    UI_MDIMainWindow* v = (UI_MDIMainWindow*) _visualObjMap[(long) hWnd];
    if (!v)
        return DefFrameProc (hWnd, GetWindow(hWnd, GW_CHILD),
                             message, wParam, lParam);
    UI_Event e (Event_None, NULL);
    NativeEventStruct msg;
    msg.hwnd = hWnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    TranslateNativeEvent (msg, e);
    long retVal = 0;
    if (message == WM_COMMAND) {
        retVal = DefFrameProc (hWnd, v->ClientHandle(),
                               message, wParam, lParam);
        short cmd = GET_WM_COMMAND_CMD (wParam, lParam);
        if (cmd == 0) {
            // Menu item was selected; now make it lose focus:
            UI_Event event (Event_LoseFocus, e._origin, e._origin);
            DispatchEvent (&event);
        }
        else if (cmd == EN_CHANGE) {
            // Edit control's contents have changed; notify it
            HWND h = GET_WM_COMMAND_HWND (msg.wParam, msg.lParam);
            UI_StringEditor* edit = (UI_StringEditor*) (*this)[h];
            edit->Update();
        }
    }
    else
         retVal = v->WindowProcHook (hWnd, message, wParam, lParam);
    if (!_eventFilter || _eventFilter->Execute (e) )
        DispatchNativeEvent (e);
    if (message == WM_PAINT)
        ValidateRgn (hWnd, NULL); // Assume that the Paint method did
                                  // its job. Without this call I'll be
                                  // flooded with WM_PAINT messages
    return retVal;
}


long UI_Controller::MDIChildProc (HWND hWnd, unsigned message,
                                  UINT wParam, LONG lParam)
{
    UI_MDIChild* v = (UI_MDIChild*) _visualObjMap[(long) hWnd];
    if (!v)
        return DefMDIChildProc (hWnd, message, wParam, lParam);
    UI_Event e (Event_None, NULL);
    NativeEventStruct msg;
    msg.hwnd = hWnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    TranslateNativeEvent (msg, e);
    long retVal = 0;
    if (message == WM_COMMAND) {
        retVal = DefMDIChildProc (hWnd, message, wParam, lParam);
        short cmd = GET_WM_COMMAND_CMD (wParam, lParam);
        if (cmd == 0) {
            // Menu item was selected; now make it lose focus:
            UI_Event event (Event_LoseFocus, e._origin, e._origin);
            DispatchEvent (&event);
        }
        else if (cmd == EN_CHANGE) {
            // Edit control's contents have changed; notify it
            HWND h = GET_WM_COMMAND_HWND (msg.wParam, msg.lParam);
            UI_StringEditor* edit = (UI_StringEditor*) (*this)[h];
            edit->Update();
        }
    }
    else
         retVal = v->WindowProcHook (hWnd, message, wParam, lParam);
    if (!_eventFilter || _eventFilter->Execute (e) )
        DispatchNativeEvent (e);
    if (message == WM_PAINT)
        ValidateRgn (hWnd, NULL); // Assume that the Paint method did
                                  // its job. Without this call I'll be
                                  // flooded with WM_PAINT messages
    return retVal;
}





// MS Windows window manager messages caught here

long FAR PASCAL YACL_UI YACLWindowProc (HWND hwnd, unsigned msg, UINT
                                        wParam, LONG lp)
{
   return YACLApp()->Controller().WindowProc (hwnd, msg, wParam, lp);
}



long FAR PASCAL YACL_UI YACLDialogProc  (HWND h, unsigned m, UINT w, LONG l)
    // (HWND, unsigned, UINT, LONG)
{
    return YACLApp()->Controller().DialogProc (h, m, w, l);
}


long FAR PASCAL YACL_UI YACLBtnGroupProc (HWND h, unsigned m,
                                          UINT w, LONG l)
{
    return YACLApp()->Controller().BtnGroupProc (h, m, w, l);
}

long FAR PASCAL YACL_UI YACLBtnProc (HWND h, unsigned m, UINT w, LONG l)
{
    return YACLApp()->Controller().BtnProc (h, m, w, l);
}

long FAR PASCAL YACL_UI YACLEditProc (HWND h, unsigned m, UINT w, LONG l)
{
    return YACLApp()->Controller().EditProc (h, m, w, l);
}

long FAR PASCAL YACL_UI YACLMDIFrameProc (HWND h, unsigned m, UINT w, LONG l)
{
    return YACLApp()->Controller().MDIFrameProc (h, m, w, l);
}

long FAR PASCAL YACL_UI YACLMDIChildProc (HWND h, unsigned m, UINT w, LONG l)
{
    return YACLApp()->Controller().MDIChildProc (h, m, w, l);
}

long FAR PASCAL YACL_UI YACLSimpleVObjProc (HWND hWnd, unsigned message,
                                              UINT wParam, LONG lParam)
{
    long result = DefWindowProc (hWnd, message, wParam, lParam);
    UI_Controller& ctrlr = YACLApp()->Controller();
    NativeEventStruct msg;
    msg.hwnd = hWnd;
    msg.message = message;
    msg.lParam = lParam;
    msg.wParam = wParam;
    UI_Event e (Event_None, 0);
    if (ctrlr.TranslateNativeEvent (msg, e)) {
        if (!ctrlr._eventFilter || ctrlr._eventFilter->Execute (e))
            ctrlr.DispatchNativeEvent (e);
    }
    return result;
}




short UI_Controller::Initialize
    (HANDLE hInstance, HANDLE hPrevInstance, LPSTR, short)
{
    hInst = hInstance;
    hPrevInst = hPrevInstance;
    if (hPrevInst) // Already registered
        return 0;
    
    WNDCLASS wc;

    wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
    wc.lpfnWndProc   = (WNDPROC) YACLWindowProc;
    wc.cbClsExtra    = NULL;
    wc.cbWndExtra    = NULL;
    wc.hInstance     = hInst;
    wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = _YACLWindowClassName;
    if ( !RegisterClass (&wc) )
        CL_Error::Warning ("UI_Controller: RegisterClass '%s' failed!",
                           wc.lpszClassName);

    wc.lpfnWndProc   = (WNDPROC) YACLSimpleVObjProc;
    wc.cbClsExtra    = NULL;
    wc.cbWndExtra    = NULL;
    wc.hInstance     = hInst;
    wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = _YACLSimpleClassName;
    if ( !RegisterClass (&wc) )
        CL_Error::Warning ("UI_Controller: RegisterClass '%s' failed!",
                           wc.lpszClassName);

    // Register the frame class 
    wc.style         = 0;
    wc.lpfnWndProc   = YACLMDIFrameProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInst;
    wc.hIcon         = LoadIcon   (NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_APPWORKSPACE+1);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = _YACLMDIFrameClassName;
    if ( !RegisterClass (&wc) )
        CL_Error::Warning ("UI_Controller: RegisterClass '%s' failed!",
                           wc.lpszClassName);

    // Register the MDI child class 
    wc.lpfnWndProc   = YACLMDIChildProc;
    wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
    wc.lpszMenuName  = NULL;
    wc.cbWndExtra    = 0;
    wc.lpszClassName = _YACLMDIChildClassName;
    if ( !RegisterClass (&wc) )
        CL_Error::Warning ("UI_Controller: RegisterClass '%s' failed!",
                           wc.lpszClassName);

    
    return 1;
}




